/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson.test;

import hudson.Extension;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.TopLevelItem;
import hudson.model.TopLevelItemDescriptor;
import hudson.security.ACL;
import hudson.security.Permission;
import hudson.security.SidACL;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;
import org.acegisecurity.acls.sid.Sid;
import org.jvnet.hudson.test.MockFolder;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class SecuredMockFolder
extends MockFolder {
    private String grantedUser;
    private Set<String> grantedPermissions;

    private SecuredMockFolder(ItemGroup parent, String name) {
        super(parent, name);
    }

    @Override
    public TopLevelItem getItem(String name) {
        TopLevelItem item = super.getItem(name);
        if (item != null && item.hasPermission(Item.READ)) {
            return item;
        }
        return null;
    }

    public boolean hasPermission(Permission p) {
        if (super.hasPermission(p)) {
            return true;
        }
        return this.hasPermissionInField(Jenkins.getAuthentication().getName(), p);
    }

    private boolean hasPermissionInField(String sid, @Nonnull Permission p) {
        return sid.equals(this.grantedUser) && this.grantedPermissions != null && this.grantedPermissions.contains(p.getId());
    }

    public ACL getACL() {
        return new ACLWrapper();
    }

    public void setPermissions(String username, Permission ... permissions) {
        this.grantedUser = username;
        if (this.grantedPermissions == null) {
            this.grantedPermissions = new HashSet<String>();
        } else {
            this.grantedPermissions.clear();
        }
        for (Permission p : permissions) {
            this.grantedPermissions.add(p.getId());
        }
    }

    private class ACLWrapper
    extends SidACL {
        private ACLWrapper() {
        }

        protected Boolean hasPermission(Sid p, Permission permission) {
            return SecuredMockFolder.this.hasPermissionInField(this.toString(p), permission);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends TopLevelItemDescriptor {
        public String getDisplayName() {
            return "MockFolder with security control";
        }

        public TopLevelItem newInstance(ItemGroup parent, String name) {
            return new SecuredMockFolder(parent, name);
        }
    }
}

