/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.User;
import hudson.security.ACL;
import hudson.security.AuthorizationStrategy;
import hudson.security.GlobalMatrixAuthorizationStrategy;
import hudson.security.Permission;
import hudson.security.SecurityRealm;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.jvnet.hudson.test.JenkinsRule;

public class CLICommandInvoker {
    private static final String username = "user";
    private final JenkinsRule rule;
    private final CLICommand command;
    private InputStream stdin;
    private List<String> args = Collections.emptyList();
    private List<Permission> permissions = Collections.emptyList();
    private Locale locale = Locale.ENGLISH;

    public CLICommandInvoker(JenkinsRule rule, CLICommand command) {
        if (command.getClass().getAnnotation(Extension.class) == null) {
            throw new AssertionError((Object)String.format("Command %s is missing @Extension annotation.", command.getClass()));
        }
        this.rule = rule;
        this.command = command;
    }

    public CLICommandInvoker(JenkinsRule rule, String command) {
        this.rule = rule;
        this.command = CLICommand.clone((String)command);
        if (this.command == null) {
            throw new AssertionError((Object)("No such command: " + command));
        }
    }

    public CLICommandInvoker authorizedTo(Permission ... permissions) {
        this.permissions = Arrays.asList(permissions);
        return this;
    }

    public CLICommandInvoker withStdin(InputStream stdin) {
        if (stdin == null) {
            throw new NullPointerException("No stdin provided");
        }
        this.stdin = stdin;
        return this;
    }

    public CLICommandInvoker withArgs(String ... args) {
        this.args = Arrays.asList(args);
        return this;
    }

    public Result invokeWithArgs(String ... args) {
        return this.withArgs(args).invoke();
    }

    public Result invoke() {
        this.setAuth();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayOutputStream err = new ByteArrayOutputStream();
        int returnCode = this.command.main(this.args, this.locale, this.stdin, new PrintStream(out), new PrintStream(err));
        return new Result(returnCode, out, err);
    }

    private void setAuth() {
        if (this.permissions.isEmpty()) {
            return;
        }
        JenkinsRule.DummySecurityRealm realm = this.rule.createDummySecurityRealm();
        realm.addGroups(username, "group");
        this.rule.jenkins.setSecurityRealm((SecurityRealm)realm);
        GlobalMatrixAuthorizationStrategy auth = new GlobalMatrixAuthorizationStrategy();
        for (Permission p : this.permissions) {
            p.setEnabled(true);
            auth.add(p, username);
        }
        this.rule.jenkins.setAuthorizationStrategy((AuthorizationStrategy)auth);
        this.command.setTransportAuth(this.user().impersonate());
        ACL.impersonate((Authentication)Jenkins.ANONYMOUS);
    }

    public User user() {
        return User.get((String)username);
    }

    public static abstract class Matcher
    extends TypeSafeMatcher<Result> {
        private final String description;

        private Matcher(String description) {
            this.description = description;
        }

        protected void describeMismatchSafely(Result result, Description description) {
            description.appendText(result.toString());
        }

        public void describeTo(Description description) {
            description.appendText(this.description);
        }

        public static Matcher hasNoStandardOutput() {
            return new Matcher("No standard output"){

                protected boolean matchesSafely(Result result) {
                    return "".equals(result.stdout());
                }
            };
        }

        public static Matcher hasNoErrorOutput() {
            return new Matcher("No error output"){

                protected boolean matchesSafely(Result result) {
                    return "".equals(result.stderr());
                }
            };
        }

        public static Matcher succeeded() {
            return new Matcher("Exited with 0 return code"){

                protected boolean matchesSafely(Result result) {
                    return result.result == 0;
                }
            };
        }

        public static Matcher succeededSilently() {
            return new Matcher("Succeeded silently"){

                protected boolean matchesSafely(Result result) {
                    return result.result == 0 && "".equals(result.stderr()) && "".equals(result.stdout());
                }
            };
        }

        public static Matcher failedWith(final long expectedCode) {
            return new Matcher("Exited with " + expectedCode + " return code"){

                protected boolean matchesSafely(Result result) {
                    return (long)result.result == expectedCode;
                }
            };
        }
    }

    public static class Result {
        private final int result;
        private final ByteArrayOutputStream out;
        private final ByteArrayOutputStream err;

        private Result(int result, ByteArrayOutputStream out, ByteArrayOutputStream err) {
            this.result = result;
            this.out = out;
            this.err = err;
        }

        public int returnCode() {
            return this.result;
        }

        public String stdout() {
            return this.out.toString();
        }

        public String stderr() {
            return this.err.toString();
        }

        public String toString() {
            String stderr;
            StringBuilder builder = new StringBuilder("CLI command exited with ").append(this.result);
            String stdout = this.stdout();
            if (!"".equals(stdout)) {
                builder.append("\nSTDOUT:\n").append(stdout);
            }
            if (!"".equals(stderr = this.stderr())) {
                builder.append("\nSTDERR:\n").append(stderr);
            }
            return builder.toString();
        }
    }
}

