/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.geo;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.InteractivePage;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebWindow;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptEngine;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.background.BackgroundJavaScriptFactory;
import com.gargoylesoftware.htmlunit.javascript.background.JavaScriptJob;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.geo.Coordinates;
import com.gargoylesoftware.htmlunit.javascript.host.geo.Position;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.IE, minVersion=11.0f)}), @JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME)})})
public class Geolocation
extends SimpleScriptable {
    private static final Log LOG = LogFactory.getLog(Geolocation.class);
    private static String PROVIDER_URL_ = "https://maps.googleapis.com/maps/api/browserlocation/json";
    private Function successHandler_;
    private Function errorHandler_;

    @JsxFunction
    public void getCurrentPosition(Function successCallback, Object errorCallback, Object options) {
        this.successHandler_ = successCallback;
        this.errorHandler_ = errorCallback instanceof Function ? (Function)errorCallback : null;
        WebWindow webWindow = this.getWindow().getWebWindow();
        if (webWindow.getWebClient().getOptions().isGeolocationEnabled()) {
            JavaScriptJob job = BackgroundJavaScriptFactory.theFactory().createJavaScriptJob(0, null, new Runnable(){

                @Override
                public void run() {
                    Geolocation.this.doGetPosition();
                }
            });
            webWindow.getJobManager().addJob(job, this.getWindow().getWebWindow().getEnclosedPage());
        }
    }

    @JsxFunction
    public int watchPosition(Function successCallback, Object errorCallback, Object options) {
        return 0;
    }

    @JsxFunction
    public void clearWatch(int watchId) {
    }

    private void doGetPosition() {
        String os = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
        String wifiStringString = null;
        if (os.contains("win")) {
            wifiStringString = this.getWifiStringWindows();
        }
        if (wifiStringString != null) {
            String url = PROVIDER_URL_;
            url = url.contains("?") ? url + '&' : url + '?';
            url = url + "browser=firefox&sensor=true";
            url = url + wifiStringString;
            while (url.length() >= 1900) {
                url = url.substring(0, url.lastIndexOf("&wifi="));
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Invoking URL: " + url));
            }
            try (WebClient webClient = new WebClient(BrowserVersion.FIREFOX_38);){
                Object page = webClient.getPage(url);
                String content = page.getWebResponse().getContentAsString();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Receieved Content: " + content));
                }
                double latitude = Double.parseDouble(this.getJSONValue(content, "lat"));
                double longitude = Double.parseDouble(this.getJSONValue(content, "lng"));
                double accuracy = Double.parseDouble(this.getJSONValue(content, "accuracy"));
                Coordinates coordinates = new Coordinates(latitude, longitude, accuracy);
                coordinates.setPrototype(this.getPrototype(coordinates.getClass()));
                Position position = new Position(coordinates);
                position.setPrototype(this.getPrototype(position.getClass()));
                JavaScriptEngine jsEngine = this.getWindow().getWebWindow().getWebClient().getJavaScriptEngine();
                jsEngine.callFunction((InteractivePage)((HtmlPage)this.getWindow().getWebWindow().getEnclosedPage()), this.successHandler_, (Scriptable)this, this.getParentScope(), new Object[]{position});
            }
            catch (Exception e) {
                LOG.error((Object)"", (Throwable)e);
            }
        } else {
            LOG.error((Object)("Operating System not supported: " + os));
        }
    }

    private String getJSONValue(String content, String key) {
        char ch;
        StringBuilder builder = new StringBuilder();
        int index = content.indexOf("\"" + key + "\"") + key.length() + 2;
        for (index = content.indexOf(58, index) + 1; index < content.length() && (ch = content.charAt(index)) != ',' && ch != '}'; ++index) {
            builder.append(ch);
        }
        return builder.toString().trim();
    }

    String getWifiStringWindows() {
        StringBuilder builder = new StringBuilder();
        try {
            List<String> lines = this.runCommand("netsh wlan show networks mode=bssid");
            Iterator<String> it = lines.iterator();
            block2: while (it.hasNext()) {
                String line = it.next();
                if (!line.startsWith("SSID ")) continue;
                String name = line.substring(line.lastIndexOf(32) + 1);
                if (it.hasNext()) {
                    it.next();
                }
                if (it.hasNext()) {
                    it.next();
                }
                if (it.hasNext()) {
                    it.next();
                }
                while (it.hasNext()) {
                    line = it.next();
                    if (line.trim().startsWith("BSSID ")) {
                        String mac = line.substring(line.lastIndexOf(32) + 1);
                        if (it.hasNext() && (line = it.next().trim()).startsWith("Signal")) {
                            String signal = line.substring(line.lastIndexOf(32) + 1, line.length() - 1);
                            int signalStrength = Integer.parseInt(signal) / 2 - 100;
                            builder.append("&wifi=").append("mac:").append(mac.replace(':', '-')).append("%7C").append("ssid:").append(name).append("%7C").append("ss:").append(signalStrength);
                        }
                    }
                    if (!line.trim().isEmpty()) continue;
                    continue block2;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return builder.toString();
    }

    private List<String> runCommand(String command) throws IOException {
        String line;
        ArrayList<String> list = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec(command);
        BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        while ((line = reader.readLine()) != null) {
            list.add(line);
        }
        reader.close();
        return list;
    }

    static void setProviderUrl(String url) {
        PROVIDER_URL_ = url;
    }
}

