/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.file;

import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.file.Blob;
import java.io.IOException;
import java.nio.file.Files;
import java.text.SimpleDateFormat;
import java.util.Date;

@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
public class File
extends Blob {
    private java.io.File file_;

    @JsxConstructor(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF, minVersion=38.0f)})
    public File() {
    }

    File(String pathname) {
        this.file_ = new java.io.File(pathname);
    }

    @JsxGetter
    public String getName() {
        return this.file_.getName();
    }

    @JsxGetter
    public String getLastModifiedDate() {
        Date date = new Date(this.getLastModified());
        return new SimpleDateFormat("EEE MMM dd yyyy HH:mm:ss").format(date) + " GMT" + new SimpleDateFormat("Z (zzzz)").format(date);
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)})
    public long getLastModified() {
        return this.file_.lastModified();
    }

    @JsxGetter(value={@WebBrowser(value=BrowserName.CHROME)})
    public String getWebkitRelativePath() {
        return "";
    }

    @JsxGetter
    public long getSize() {
        return this.file_.length();
    }

    @JsxGetter
    public String getType() {
        try {
            return Files.probeContentType(this.file_.toPath());
        }
        catch (IOException e) {
            return "";
        }
    }

    @JsxFunction
    public void slice() {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void msClose() {
    }
}

