/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.event;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ScriptResult;
import com.gargoylesoftware.htmlunit.html.DomDocumentFragment;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.javascript.SimpleScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.BrowserName;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClasses;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.WebBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.Window;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.EventListenersContainer;
import com.gargoylesoftware.htmlunit.javascript.host.html.HTMLElement;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Locale;
import net.sourceforge.htmlunit.corejs.javascript.Context;
import net.sourceforge.htmlunit.corejs.javascript.Function;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;

@JsxClasses(value={@JsxClass(browsers={@WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.FF)}), @JsxClass(isJSObject=false, isDefinedInStandardsMode=false, browsers={@WebBrowser(value=BrowserName.IE)})})
public class EventTarget
extends SimpleScriptable {
    private EventListenersContainer eventListenersContainer_;

    @JsxConstructor
    public EventTarget() {
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void addEventListener(String type, Scriptable listener, boolean useCapture) {
        this.getEventListenersContainer().addEventListener(type, listener, useCapture);
    }

    public EventListenersContainer getEventListenersContainer() {
        if (this.eventListenersContainer_ == null) {
            this.eventListenersContainer_ = new EventListenersContainer(this);
        }
        return this.eventListenersContainer_;
    }

    public ScriptResult executeEvent(Event event) {
        if (this.eventListenersContainer_ != null) {
            HtmlPage page = (HtmlPage)this.getDomNodeOrDie().getPage();
            Window window = (Window)page.getEnclosingWindow().getScriptObject();
            return window.executeEvent(event, this);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ScriptResult fireEvent(Event event) {
        Window window = this.getWindow();
        Object[] args = new Object[]{event};
        event.startFire();
        ScriptResult result = null;
        Event previousEvent = window.getCurrentEvent();
        window.setCurrentEvent(event);
        try {
            ScriptResult r;
            EventListenersContainer elc;
            EventTarget jsNode;
            Object node;
            EventListenersContainer windowsListeners = window.getEventListenersContainer();
            event.setEventPhase((short)1);
            boolean windowEventIfDetached = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_EVENT_WINDOW_EXECUTE_IF_DITACHED);
            boolean isAttached = false;
            for (node = this.getDomNodeOrNull(); node != null; node = ((DomNode)node).getParentNode()) {
                if (!(node instanceof Document) && !(node instanceof DomDocumentFragment)) continue;
                isAttached = true;
                break;
            }
            if (isAttached || windowEventIfDetached) {
                result = windowsListeners.executeCapturingListeners(event, args);
                if (event.isPropagationStopped()) {
                    node = result;
                    return node;
                }
            }
            ArrayList<EventTarget> eventTargetList = new ArrayList<EventTarget>();
            EventTarget eventTarget = this;
            while (eventTarget != null) {
                if (isAttached) {
                    eventTargetList.add(eventTarget);
                }
                DomNode domNode = eventTarget.getDomNodeOrNull();
                eventTarget = null;
                if (domNode == null || domNode.getParentNode() == null) continue;
                eventTarget = (EventTarget)domNode.getParentNode().getScriptObject();
            }
            boolean ie = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_CALL_RESULT_IS_LAST_RETURN_VALUE);
            for (int i = eventTargetList.size() - 1; i >= 0; --i) {
                jsNode = (EventTarget)eventTargetList.get(i);
                elc = jsNode.eventListenersContainer_;
                if (elc == null || !isAttached) continue;
                r = elc.executeCapturingListeners(event, args);
                result = ScriptResult.combine(r, result, ie);
                if (!event.isPropagationStopped()) continue;
                ScriptResult scriptResult = result;
                return scriptResult;
            }
            Object[] propHandlerArgs = this.getBrowserVersion().hasFeature(BrowserVersionFeatures.JS_EVENT_HANDLER_AS_PROPERTY_DONT_RECEIVE_EVENT) ? ArrayUtils.EMPTY_OBJECT_ARRAY : args;
            event.setEventPhase((short)2);
            eventTarget = this;
            while (eventTarget != null) {
                jsNode = eventTarget;
                elc = jsNode.eventListenersContainer_;
                if (!(elc == null || jsNode instanceof Window || !isAttached && jsNode instanceof HTMLElement)) {
                    r = elc.executeBubblingListeners(event, args, propHandlerArgs);
                    result = ScriptResult.combine(r, result, ie);
                    if (event.isPropagationStopped()) {
                        ScriptResult scriptResult = result;
                        return scriptResult;
                    }
                }
                DomNode domNode = eventTarget.getDomNodeOrNull();
                eventTarget = null;
                if (domNode != null && domNode.getParentNode() != null) {
                    eventTarget = (EventTarget)domNode.getParentNode().getScriptObject();
                }
                event.setEventPhase((short)3);
            }
            if (isAttached || windowEventIfDetached) {
                ScriptResult r2 = windowsListeners.executeBubblingListeners(event, args, propHandlerArgs);
                result = ScriptResult.combine(r2, result, ie);
            }
        }
        finally {
            event.endFire();
            window.setCurrentEvent(previousEvent);
        }
        return result;
    }

    public boolean hasEventHandlers(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return false;
        }
        return this.eventListenersContainer_.hasEventHandlers(StringUtils.substring((String)eventName, (int)2));
    }

    public Function getEventHandler(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        return this.eventListenersContainer_.getEventHandler(StringUtils.substring((String)eventName, (int)2));
    }

    protected Object getEventHandlerProp(String eventName) {
        if (this.eventListenersContainer_ == null) {
            return null;
        }
        String name = StringUtils.substring((String)eventName.toLowerCase(Locale.ENGLISH), (int)2);
        return this.eventListenersContainer_.getEventHandlerProp(name);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public boolean dispatchEvent(Event event) {
        event.setTarget(this);
        HtmlElement element = (HtmlElement)this.getDomNodeOrNull();
        ScriptResult result = null;
        if (event.getType().equals("click")) {
            try {
                element.click(event);
            }
            catch (IOException e) {
                throw Context.reportRuntimeError("Error calling click(): " + e.getMessage());
            }
        } else {
            result = this.fireEvent(event);
        }
        return !event.isAborted(result);
    }

    @JsxFunction(value={@WebBrowser(value=BrowserName.FF), @WebBrowser(value=BrowserName.CHROME), @WebBrowser(value=BrowserName.IE, minVersion=11.0f)})
    public void removeEventListener(String type, Function listener, boolean useCapture) {
        this.getEventListenersContainer().removeEventListener(type, listener, useCapture);
    }

    protected void setEventHandlerProp(String eventName, Object value) {
        this.getEventListenersContainer().setEventHandlerProp(StringUtils.substring((String)eventName.toLowerCase(), (int)2), value);
    }

    public void setEventHandler(String eventName, Function eventHandler) {
        this.setEventHandlerProp(eventName, eventHandler);
    }

    protected void clearEventListenersContainer() {
        this.eventListenersContainer_ = null;
    }
}

