/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.lib.envinject.service;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jenkinsci.lib.envinject.EnvInjectException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnvInjectSavable {
    private static final String ENVINJECT_TXT_FILENAME = "injectedEnvVars.txt";
    private static final String TOKEN = "=";

    public Map<String, String> getEnvironment(File envInjectBaseDir) throws EnvInjectException {
        if (envInjectBaseDir == null) {
            throw new NullPointerException("A base directory of the envinject file must be set.");
        }
        InputStreamReader fileReader = null;
        try {
            File f = new File(envInjectBaseDir, ENVINJECT_TXT_FILENAME);
            if (!f.exists()) {
                Map<String, String> map = null;
                return map;
            }
            fileReader = new FileReader(f);
            HashMap<String, String> result = new HashMap<String, String>();
            this.fromTxt((FileReader)fileReader, result);
            HashMap<String, String> hashMap = result;
            return hashMap;
        }
        catch (FileNotFoundException fne) {
            throw new EnvInjectException(fne);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException ioe) {
                    throw new EnvInjectException(ioe);
                }
            }
        }
    }

    public void saveEnvironment(File rootDir, Map<String, String> envMap) throws EnvInjectException {
        OutputStreamWriter fileWriter = null;
        try {
            File f = new File(rootDir, ENVINJECT_TXT_FILENAME);
            fileWriter = new FileWriter(f);
            TreeMap<String, String> map2Write = new TreeMap<String, String>();
            map2Write.putAll(envMap);
            this.toTxt(map2Write, (FileWriter)fileWriter);
        }
        catch (FileNotFoundException fne) {
            throw new EnvInjectException(fne);
        }
        catch (IOException ioe) {
            throw new EnvInjectException(ioe);
        }
        finally {
            if (fileWriter != null) {
                try {
                    fileWriter.close();
                }
                catch (IOException ioe) {
                    throw new EnvInjectException(ioe);
                }
            }
        }
    }

    private void fromTxt(FileReader fileReader, Map<String, String> result) throws EnvInjectException {
        BufferedReader bufferedReader = new BufferedReader(fileReader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                StringTokenizer tokenizer = new StringTokenizer(line, TOKEN);
                int tokens = tokenizer.countTokens();
                if (tokens != 2) continue;
                result.put(String.valueOf(tokenizer.nextElement()), String.valueOf(tokenizer.nextElement()));
            }
        }
        catch (IOException ioe) {
            throw new EnvInjectException(ioe);
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException ioe) {
                    throw new EnvInjectException(ioe);
                }
            }
        }
    }

    private void toTxt(Map<String, String> envMap, FileWriter fw) throws IOException {
        for (Map.Entry<String, String> entry : envMap.entrySet()) {
            fw.write(String.format("%s%s%s\n", entry.getKey(), TOKEN, entry.getValue()));
        }
    }
}

