/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.handler;

import java.io.IOException;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.util.component.AbstractLifeCycle;
import org.eclipse.jetty.util.log.Log;

public abstract class AbstractHandler
extends AbstractLifeCycle
implements Handler {
    private Server _server;

    protected void doStart() throws Exception {
        Log.debug((String)"starting {}", (Object)this);
    }

    protected void doStop() throws Exception {
        Log.debug((String)"stopping {}", (Object)this);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        String s = super.toString();
        b.append(s, s.lastIndexOf(46) + 1, s.length());
        ContextHandler.Context ctx = ContextHandler.getCurrentContext();
        if (ctx != null && ctx.getContextPath() != null && !(this instanceof ContextHandler)) {
            b.append('@');
            b.append(ctx.getContextPath());
        }
        return b.toString();
    }

    @Override
    public void setServer(Server server) {
        Server old_server = this._server;
        if (old_server != null && old_server != server) {
            old_server.getContainer().removeBean((Object)this);
        }
        this._server = server;
        if (this._server != null && this._server != old_server) {
            this._server.getContainer().addBean((Object)this);
        }
    }

    @Override
    public Server getServer() {
        return this._server;
    }

    @Override
    public void destroy() {
        if (!this.isStopped()) {
            throw new IllegalStateException("!STOPPED");
        }
        if (this._server != null) {
            this._server.getContainer().removeBean((Object)this);
        }
    }

    public String dump() {
        StringBuilder b = new StringBuilder();
        try {
            this.dump(b, "");
        }
        catch (IOException e) {
            Log.warn((Throwable)e);
        }
        return b.toString();
    }

    public void dump(Appendable out) throws IOException {
        this.dump(out, "");
    }

    protected void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(this.isStarted() ? " started" : " STOPPED").append('\n');
    }
}

