/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.jaxme.sqls.impl;

import org.apache.ws.jaxme.sqls.Column;
import org.apache.ws.jaxme.sqls.ColumnReference;
import org.apache.ws.jaxme.sqls.TableReference;
import org.apache.ws.jaxme.sqls.impl.ColumnImpl;

public class ColumnReferenceImpl
implements ColumnReference {
    private TableReference tableReference;
    private Column column;
    private Column.Name alias;

    protected ColumnReferenceImpl(TableReference pTableReference, Column pColumn) {
        if (pTableReference == null) {
            throw new NullPointerException("The referenced table must not be null.");
        }
        if (pColumn == null) {
            throw new NullPointerException("The referenced column must not be null.");
        }
        if (!pTableReference.getTable().equals(pColumn.getTable())) {
            throw new IllegalStateException("The columns table is not the referenced table.");
        }
        this.tableReference = pTableReference;
        this.column = pColumn;
    }

    public TableReference getTableReference() {
        return this.tableReference;
    }

    public Column getColumn() {
        return this.column;
    }

    public void setAlias(String pName) {
        this.setAlias(new ColumnImpl.NameImpl(pName));
    }

    public void setAlias(Column.Name pName) {
        this.alias = pName;
    }

    public Column.Name getAlias() {
        return this.alias;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof ColumnReference)) {
            return false;
        }
        ColumnReference ref = (ColumnReference)o;
        Column c1 = ref.getColumn();
        Column c2 = this.getColumn();
        if (c1 == null || c2 == null) {
            return super.equals(o);
        }
        TableReference t1 = ref.getTableReference();
        TableReference t2 = ref.getTableReference();
        if (t1 == null || t2 == null) {
            return super.equals(o);
        }
        return t1.equals(t2) && c1.equals(c2);
    }

    public int hashCode() {
        return this.getTableReference().hashCode() + this.getColumn().hashCode();
    }
}

