/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.List;
import org.apache.maven.plugin.surefire.report.Reporter;
import org.apache.maven.surefire.report.CategorizedReportEntry;
import org.apache.maven.surefire.report.ReportEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MulticastingReporter
implements Reporter {
    private final Reporter[] target;
    private final int size;
    private volatile long lastStartAt;

    public MulticastingReporter(List<Reporter> target) {
        this.size = target.size();
        this.target = target.toArray(new Reporter[target.size()]);
    }

    @Override
    public void testSetStarting(ReportEntry report) {
        this.lastStartAt = System.currentTimeMillis();
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSetStarting(report);
        }
    }

    @Override
    public void testSetCompleted(ReportEntry report) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSetCompleted(report);
        }
    }

    @Override
    public void testStarting(ReportEntry report) {
        this.lastStartAt = System.currentTimeMillis();
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testStarting(report);
        }
    }

    @Override
    public void testSucceeded(ReportEntry report) {
        ReportEntry wrapped = this.wrap(report);
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSucceeded(wrapped);
        }
    }

    @Override
    public void testError(ReportEntry report, String stdOut, String stdErr) {
        ReportEntry wrapped = this.wrap(report);
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testError(wrapped, stdOut, stdErr);
        }
    }

    @Override
    public void testFailed(ReportEntry report, String stdOut, String stdErr) {
        ReportEntry wrapped = this.wrap(report);
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testFailed(wrapped, stdOut, stdErr);
        }
    }

    @Override
    public void testSkipped(ReportEntry report) {
        ReportEntry wrapped = this.wrap(report);
        for (int i = 0; i < this.size; ++i) {
            this.target[i].testSkipped(wrapped);
        }
    }

    private ReportEntry wrap(ReportEntry other) {
        if (other.getElapsed() != null) {
            return other;
        }
        return new CategorizedReportEntry(other.getSourceName(), other.getName(), other.getGroup(), other.getStackTraceWriter(), Integer.valueOf((int)(System.currentTimeMillis() - this.lastStartAt)), other.getMessage());
    }

    @Override
    public void writeMessage(String message) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].writeMessage(message);
        }
    }

    @Override
    public void writeMessage(byte[] b, int off, int len) {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].writeMessage(b, off, len);
        }
    }

    @Override
    public void reset() {
        for (int i = 0; i < this.size; ++i) {
            this.target[i].reset();
        }
    }
}

