/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.recovery;

import com.google.common.annotations.VisibleForTesting;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.io.DataInputByteBuffer;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.token.delegation.DelegationKey;
import org.apache.hadoop.yarn.api.records.ApplicationAttemptId;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.proto.YarnServerCommonProtos;
import org.apache.hadoop.yarn.proto.YarnServerResourceManagerRecoveryProtos;
import org.apache.hadoop.yarn.security.client.RMDelegationTokenIdentifier;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.records.impl.pb.VersionPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.RMStateStore;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.AMRMTokenSecretManagerState;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationAttemptStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.ApplicationStateData;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.Epoch;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.AMRMTokenSecretManagerStatePBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationAttemptStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.ApplicationStateDataPBImpl;
import org.apache.hadoop.yarn.server.resourcemanager.recovery.records.impl.pb.EpochPBImpl;
import org.apache.hadoop.yarn.util.ConverterUtils;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class FileSystemRMStateStore
extends RMStateStore {
    public static final Log LOG = LogFactory.getLog(FileSystemRMStateStore.class);
    protected static final String ROOT_DIR_NAME = "FSRMStateRoot";
    protected static final Version CURRENT_VERSION_INFO = Version.newInstance((int)1, (int)2);
    protected static final String AMRMTOKEN_SECRET_MANAGER_NODE = "AMRMTokenSecretManagerNode";
    protected FileSystem fs;
    private Path rootDirPath;
    @InterfaceAudience.Private
    @VisibleForTesting
    Path rmDTSecretManagerRoot;
    private Path rmAppRoot;
    private Path dtSequenceNumberPath = null;
    @VisibleForTesting
    Path fsWorkingPath;
    Path amrmTokenSecretManagerRoot;

    @Override
    public synchronized void initInternal(Configuration conf) throws Exception {
        this.fsWorkingPath = new Path(conf.get("yarn.resourcemanager.fs.state-store.uri"));
        this.rootDirPath = new Path(this.fsWorkingPath, ROOT_DIR_NAME);
        this.rmDTSecretManagerRoot = new Path(this.rootDirPath, "RMDTSecretManagerRoot");
        this.rmAppRoot = new Path(this.rootDirPath, "RMAppRoot");
        this.amrmTokenSecretManagerRoot = new Path(this.rootDirPath, "AMRMTokenSecretManagerRoot");
    }

    @Override
    protected synchronized void startInternal() throws Exception {
        Configuration conf = new Configuration(this.getConfig());
        conf.setBoolean("dfs.client.retry.policy.enabled", true);
        String retryPolicy = conf.get("yarn.resourcemanager.fs.state-store.retry-policy-spec", "2000, 500");
        conf.set("dfs.client.retry.policy.spec", retryPolicy);
        this.fs = this.fsWorkingPath.getFileSystem(conf);
        this.fs.mkdirs(this.rmDTSecretManagerRoot);
        this.fs.mkdirs(this.rmAppRoot);
        this.fs.mkdirs(this.amrmTokenSecretManagerRoot);
    }

    @Override
    protected synchronized void closeInternal() throws Exception {
        this.fs.close();
    }

    @Override
    protected Version getCurrentVersion() {
        return CURRENT_VERSION_INFO;
    }

    @Override
    protected synchronized Version loadVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        if (this.fs.exists(versionNodePath)) {
            FileStatus status = this.fs.getFileStatus(versionNodePath);
            byte[] data = this.readFile(versionNodePath, status.getLen());
            VersionPBImpl version = new VersionPBImpl(YarnServerCommonProtos.VersionProto.parseFrom((byte[])data));
            return version;
        }
        return null;
    }

    @Override
    protected synchronized void storeVersion() throws Exception {
        Path versionNodePath = this.getNodePath(this.rootDirPath, "RMVersionNode");
        byte[] data = ((VersionPBImpl)CURRENT_VERSION_INFO).getProto().toByteArray();
        if (this.fs.exists(versionNodePath)) {
            this.updateFile(versionNodePath, data);
        } else {
            this.writeFile(versionNodePath, data);
        }
    }

    @Override
    public synchronized long getAndIncrementEpoch() throws Exception {
        Path epochNodePath = this.getNodePath(this.rootDirPath, "EpochNode");
        long currentEpoch = 0L;
        if (this.fs.exists(epochNodePath)) {
            FileStatus status = this.fs.getFileStatus(epochNodePath);
            byte[] data = this.readFile(epochNodePath, status.getLen());
            EpochPBImpl epoch = new EpochPBImpl(YarnServerResourceManagerRecoveryProtos.EpochProto.parseFrom(data));
            currentEpoch = ((Epoch)epoch).getEpoch();
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.updateFile(epochNodePath, storeData);
        } else {
            byte[] storeData = Epoch.newInstance(currentEpoch + 1L).getProto().toByteArray();
            this.writeFile(epochNodePath, storeData);
        }
        return currentEpoch;
    }

    @Override
    public synchronized RMStateStore.RMState loadState() throws Exception {
        RMStateStore.RMState rmState = new RMStateStore.RMState();
        this.loadRMDTSecretManagerState(rmState);
        this.loadRMAppState(rmState);
        this.loadAMRMTokenSecretManagerState(rmState);
        return rmState;
    }

    private void loadAMRMTokenSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus status;
        this.checkAndResumeUpdateOperation(this.amrmTokenSecretManagerRoot);
        Path amrmTokenSecretManagerStateDataDir = new Path(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        try {
            status = this.fs.getFileStatus(amrmTokenSecretManagerStateDataDir);
            assert (status.isFile());
        }
        catch (FileNotFoundException ex) {
            return;
        }
        byte[] data = this.readFile(amrmTokenSecretManagerStateDataDir, status.getLen());
        AMRMTokenSecretManagerStatePBImpl stateData = new AMRMTokenSecretManagerStatePBImpl(YarnServerResourceManagerRecoveryProtos.AMRMTokenSecretManagerStateProto.parseFrom(data));
        rmState.amrmTokenSecretManagerState = AMRMTokenSecretManagerState.newInstance(stateData.getCurrentMasterKey(), stateData.getNextMasterKey());
    }

    private void loadRMAppState(RMStateStore.RMState rmState) throws Exception {
        try {
            ArrayList<RMStateStore.ApplicationAttemptState> attempts = new ArrayList<RMStateStore.ApplicationAttemptState>();
            for (FileStatus appDir : this.fs.listStatus(this.rmAppRoot)) {
                this.checkAndResumeUpdateOperation(appDir.getPath());
                for (FileStatus childNodeStatus : this.fs.listStatus(appDir.getPath())) {
                    assert (childNodeStatus.isFile());
                    String childNodeName = childNodeStatus.getPath().getName();
                    if (this.checkAndRemovePartialRecord(childNodeStatus.getPath())) continue;
                    byte[] childData = this.readFile(childNodeStatus.getPath(), childNodeStatus.getLen());
                    if (childNodeName.startsWith("application_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading application from node: " + childNodeName));
                        }
                        ApplicationId appId = ConverterUtils.toApplicationId((String)childNodeName);
                        ApplicationStateDataPBImpl appStateData = new ApplicationStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationStateDataProto.parseFrom(childData));
                        RMStateStore.ApplicationState appState = new RMStateStore.ApplicationState(appStateData.getSubmitTime(), appStateData.getStartTime(), appStateData.getApplicationSubmissionContext(), appStateData.getUser(), appStateData.getState(), appStateData.getDiagnostics(), appStateData.getFinishTime());
                        assert (appId.equals((Object)appState.context.getApplicationId()));
                        rmState.appState.put(appId, appState);
                        continue;
                    }
                    if (childNodeName.startsWith("appattempt_")) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("Loading application attempt from node: " + childNodeName));
                        }
                        ApplicationAttemptId attemptId = ConverterUtils.toApplicationAttemptId((String)childNodeName);
                        ApplicationAttemptStateDataPBImpl attemptStateData = new ApplicationAttemptStateDataPBImpl(YarnServerResourceManagerRecoveryProtos.ApplicationAttemptStateDataProto.parseFrom(childData));
                        Credentials credentials = null;
                        if (attemptStateData.getAppAttemptTokens() != null) {
                            credentials = new Credentials();
                            DataInputByteBuffer dibb = new DataInputByteBuffer();
                            dibb.reset(new ByteBuffer[]{attemptStateData.getAppAttemptTokens()});
                            credentials.readTokenStorageStream((DataInputStream)dibb);
                        }
                        RMStateStore.ApplicationAttemptState attemptState = new RMStateStore.ApplicationAttemptState(attemptId, attemptStateData.getMasterContainer(), credentials, attemptStateData.getStartTime(), attemptStateData.getState(), attemptStateData.getFinalTrackingUrl(), attemptStateData.getDiagnostics(), attemptStateData.getFinalApplicationStatus(), attemptStateData.getAMContainerExitStatus(), attemptStateData.getFinishTime(), attemptStateData.getMemorySeconds(), attemptStateData.getVcoreSeconds());
                        assert (attemptId.equals((Object)attemptState.getAttemptId()));
                        attempts.add(attemptState);
                        continue;
                    }
                    LOG.info((Object)("Unknown child node with name: " + childNodeName));
                }
            }
            for (RMStateStore.ApplicationAttemptState attemptState : attempts) {
                ApplicationId appId = attemptState.getAttemptId().getApplicationId();
                RMStateStore.ApplicationState appState = rmState.appState.get(appId);
                assert (appState != null);
                appState.attempts.put(attemptState.getAttemptId(), attemptState);
            }
            LOG.info((Object)"Done loading applications from FS state store");
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to load state.", (Throwable)e);
            throw e;
        }
    }

    private boolean checkAndRemovePartialRecord(Path record) throws IOException {
        if (record.getName().endsWith(".tmp")) {
            LOG.error((Object)("incomplete rm state store entry found :" + record));
            this.fs.delete(record, false);
            return true;
        }
        return false;
    }

    private void checkAndResumeUpdateOperation(Path path) throws Exception {
        FileStatus[] newChildNodes;
        for (FileStatus newChildNodeStatus : newChildNodes = this.fs.listStatus(path, new PathFilter(){

            public boolean accept(Path path) {
                return path.getName().endsWith(".new");
            }
        })) {
            assert (newChildNodeStatus.isFile());
            String newChildNodeName = newChildNodeStatus.getPath().getName();
            String childNodeName = newChildNodeName.substring(0, newChildNodeName.length() - ".new".length());
            Path childNodePath = new Path(newChildNodeStatus.getPath().getParent(), childNodeName);
            this.replaceFile(newChildNodeStatus.getPath(), childNodePath);
        }
    }

    private void loadRMDTSecretManagerState(RMStateStore.RMState rmState) throws Exception {
        FileStatus[] childNodes;
        this.checkAndResumeUpdateOperation(this.rmDTSecretManagerRoot);
        for (FileStatus childNodeStatus : childNodes = this.fs.listStatus(this.rmDTSecretManagerRoot)) {
            assert (childNodeStatus.isFile());
            String childNodeName = childNodeStatus.getPath().getName();
            if (this.checkAndRemovePartialRecord(childNodeStatus.getPath())) continue;
            if (childNodeName.startsWith("RMDTSequenceNumber_")) {
                rmState.rmSecretManagerState.dtSequenceNumber = Integer.parseInt(childNodeName.split("_")[1]);
                continue;
            }
            Path childNodePath = this.getNodePath(this.rmDTSecretManagerRoot, childNodeName);
            byte[] childData = this.readFile(childNodePath, childNodeStatus.getLen());
            ByteArrayInputStream is = new ByteArrayInputStream(childData);
            DataInputStream fsIn = new DataInputStream(is);
            if (childNodeName.startsWith("DelegationKey_")) {
                DelegationKey key = new DelegationKey();
                key.readFields((DataInput)fsIn);
                rmState.rmSecretManagerState.masterKeyState.add(key);
            } else if (childNodeName.startsWith("RMDelegationToken_")) {
                RMDelegationTokenIdentifier identifier = new RMDelegationTokenIdentifier();
                identifier.readFields((DataInput)fsIn);
                long renewDate = fsIn.readLong();
                rmState.rmSecretManagerState.delegationTokenState.put(identifier, renewDate);
            } else {
                LOG.warn((Object)"Unknown file for recovering RMDelegationTokenSecretManager");
            }
            fsIn.close();
        }
    }

    @Override
    public synchronized void storeApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String appIdStr = appId.toString();
        Path appDirPath = this.getAppDir(this.rmAppRoot, appIdStr);
        this.fs.mkdirs(appDirPath);
        Path nodeCreatePath = this.getNodePath(appDirPath, appIdStr);
        LOG.info((Object)("Storing info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationStateInternal(ApplicationId appId, ApplicationStateData appStateDataPB) throws Exception {
        String appIdStr = appId.toString();
        Path appDirPath = this.getAppDir(this.rmAppRoot, appIdStr);
        Path nodeCreatePath = this.getNodePath(appDirPath, appIdStr);
        LOG.info((Object)("Updating info for app: " + appId + " at: " + nodeCreatePath));
        byte[] appStateData = appStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, appStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error updating info for app: " + appId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void storeApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info((Object)("Storing info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.writeFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error storing info for attempt: " + appAttemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void updateApplicationAttemptStateInternal(ApplicationAttemptId appAttemptId, ApplicationAttemptStateData attemptStateDataPB) throws Exception {
        Path appDirPath = this.getAppDir(this.rmAppRoot, appAttemptId.getApplicationId().toString());
        Path nodeCreatePath = this.getNodePath(appDirPath, appAttemptId.toString());
        LOG.info((Object)("Updating info for attempt: " + appAttemptId + " at: " + nodeCreatePath));
        byte[] attemptStateData = attemptStateDataPB.getProto().toByteArray();
        try {
            this.updateFile(nodeCreatePath, attemptStateData);
        }
        catch (Exception e) {
            LOG.info((Object)("Error updating info for attempt: " + appAttemptId), (Throwable)e);
            throw e;
        }
    }

    @Override
    public synchronized void removeApplicationStateInternal(RMStateStore.ApplicationState appState) throws Exception {
        String appId = appState.getAppId().toString();
        Path nodeRemovePath = this.getAppDir(this.rmAppRoot, appId);
        LOG.info((Object)("Removing info for app: " + appId + " at: " + nodeRemovePath));
        this.deleteFile(nodeRemovePath);
    }

    @Override
    public synchronized void storeRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(identifier, renewDate, false);
    }

    @Override
    public synchronized void removeRMDelegationTokenState(RMDelegationTokenIdentifier identifier) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        LOG.info((Object)("Removing RMDelegationToken_" + identifier.getSequenceNumber()));
        this.deleteFile(nodeCreatePath);
    }

    @Override
    protected void updateRMDelegationTokenState(RMDelegationTokenIdentifier rmDTIdentifier, Long renewDate) throws Exception {
        this.storeOrUpdateRMDelegationTokenState(rmDTIdentifier, renewDate, true);
    }

    private void storeOrUpdateRMDelegationTokenState(RMDelegationTokenIdentifier identifier, Long renewDate, boolean isUpdate) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDelegationToken_" + identifier.getSequenceNumber());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        identifier.write((DataOutput)fsOut);
        fsOut.writeLong(renewDate);
        if (isUpdate) {
            LOG.info((Object)("Updating RMDelegationToken_" + identifier.getSequenceNumber()));
            this.updateFile(nodeCreatePath, os.toByteArray());
        } else {
            LOG.info((Object)("Storing RMDelegationToken_" + identifier.getSequenceNumber()));
            this.writeFile(nodeCreatePath, os.toByteArray());
        }
        fsOut.close();
        Path latestSequenceNumberPath = this.getNodePath(this.rmDTSecretManagerRoot, "RMDTSequenceNumber_" + identifier.getSequenceNumber());
        LOG.info((Object)("Storing RMDTSequenceNumber_" + identifier.getSequenceNumber()));
        if (this.dtSequenceNumberPath == null) {
            if (!this.createFile(latestSequenceNumberPath)) {
                throw new Exception("Failed to create " + latestSequenceNumberPath);
            }
        } else if (!this.renameFile(this.dtSequenceNumberPath, latestSequenceNumberPath)) {
            throw new Exception("Failed to rename " + this.dtSequenceNumberPath);
        }
        this.dtSequenceNumberPath = latestSequenceNumberPath;
    }

    @Override
    public synchronized void storeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        DataOutputStream fsOut = new DataOutputStream(os);
        LOG.info((Object)("Storing RMDelegationKey_" + masterKey.getKeyId()));
        masterKey.write((DataOutput)fsOut);
        this.writeFile(nodeCreatePath, os.toByteArray());
        fsOut.close();
    }

    @Override
    public synchronized void removeRMDTMasterKeyState(DelegationKey masterKey) throws Exception {
        Path nodeCreatePath = this.getNodePath(this.rmDTSecretManagerRoot, "DelegationKey_" + masterKey.getKeyId());
        LOG.info((Object)("Removing RMDelegationKey_" + masterKey.getKeyId()));
        this.deleteFile(nodeCreatePath);
    }

    @Override
    public synchronized void deleteStore() throws IOException {
        if (this.fs.exists(this.rootDirPath)) {
            this.fs.delete(this.rootDirPath, true);
        }
    }

    private Path getAppDir(Path root, String appId) {
        return this.getNodePath(root, appId);
    }

    private void deleteFile(Path deletePath) throws Exception {
        if (!this.fs.delete(deletePath, true)) {
            throw new Exception("Failed to delete " + deletePath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readFile(Path inputPath, long len) throws Exception {
        byte[] byArray;
        FSDataInputStream fsIn = null;
        try {
            fsIn = this.fs.open(inputPath);
            byte[] data = new byte[(int)len];
            fsIn.readFully(data);
            byArray = data;
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsIn});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsIn});
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(Path outputPath, byte[] data) throws Exception {
        Path tempPath = new Path(outputPath.getParent(), outputPath.getName() + ".tmp");
        FSDataOutputStream fsOut = null;
        try {
            fsOut = this.fs.create(tempPath, true);
            fsOut.write(data);
            fsOut.close();
            fsOut = null;
            this.fs.rename(tempPath, outputPath);
        }
        catch (Throwable throwable) {
            IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsOut});
            throw throwable;
        }
        IOUtils.cleanup((Log)LOG, (Closeable[])new Closeable[]{fsOut});
    }

    protected void updateFile(Path outputPath, byte[] data) throws Exception {
        Path newPath = new Path(outputPath.getParent(), outputPath.getName() + ".new");
        this.writeFile(newPath, data);
        this.replaceFile(newPath, outputPath);
    }

    protected void replaceFile(Path srcPath, Path dstPath) throws Exception {
        if (this.fs.exists(dstPath)) {
            this.deleteFile(dstPath);
        } else {
            LOG.info((Object)("File doesn't exist. Skip deleting the file " + dstPath));
        }
        this.fs.rename(srcPath, dstPath);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    boolean renameFile(Path src, Path dst) throws Exception {
        return this.fs.rename(src, dst);
    }

    private boolean createFile(Path newFile) throws Exception {
        return this.fs.createNewFile(newFile);
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    Path getNodePath(Path root, String nodeName) {
        return new Path(root, nodeName);
    }

    @Override
    public synchronized void storeOrUpdateAMRMTokenSecretManagerState(AMRMTokenSecretManagerState amrmTokenSecretManagerState, boolean isUpdate) {
        Path nodeCreatePath = this.getNodePath(this.amrmTokenSecretManagerRoot, AMRMTOKEN_SECRET_MANAGER_NODE);
        AMRMTokenSecretManagerState data = AMRMTokenSecretManagerState.newInstance(amrmTokenSecretManagerState);
        byte[] stateData = data.getProto().toByteArray();
        try {
            if (isUpdate) {
                this.updateFile(nodeCreatePath, stateData);
            } else {
                this.writeFile(nodeCreatePath, stateData);
            }
        }
        catch (Exception ex) {
            LOG.info((Object)"Error storing info for AMRMTokenSecretManager", (Throwable)ex);
            this.notifyStoreOperationFailed(ex);
        }
    }
}

