/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.webapp;

import com.google.inject.Inject;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.yarn.MockApps;
import org.apache.hadoop.yarn.util.StringHelper;
import org.apache.hadoop.yarn.webapp.Controller;
import org.apache.hadoop.yarn.webapp.MyTestJAXBContextResolver;
import org.apache.hadoop.yarn.webapp.MyTestWebService;
import org.apache.hadoop.yarn.webapp.WebApp;
import org.apache.hadoop.yarn.webapp.WebAppException;
import org.apache.hadoop.yarn.webapp.WebApps;
import org.apache.hadoop.yarn.webapp.hamlet.Hamlet;
import org.apache.hadoop.yarn.webapp.view.HtmlPage;
import org.apache.hadoop.yarn.webapp.view.JQueryUI;
import org.apache.hadoop.yarn.webapp.view.TextPage;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestWebApp {
    static final Logger LOG = LoggerFactory.getLogger(TestWebApp.class);

    String echo(String s) {
        return s;
    }

    @Test
    public void testCreate() {
        WebApp app = WebApps.$for((Object)this).start();
        app.stop();
    }

    @Test
    public void testCreateWithPort() {
        WebApp app = WebApps.$for((Object)this).at(0).start();
        int port = app.getListenerAddress().getPort();
        Assert.assertTrue((port > 0 ? 1 : 0) != 0);
        app.stop();
        app = WebApps.$for((Object)this).at(port).start();
        Assert.assertEquals((long)port, (long)app.getListenerAddress().getPort());
        app.stop();
    }

    @Test(expected=WebAppException.class)
    public void testCreateWithBindAddressNonZeroPort() {
        WebApp app = WebApps.$for((Object)this).at("0.0.0.0:50000").start();
        int port = app.getListenerAddress().getPort();
        Assert.assertEquals((long)50000L, (long)port);
        WebApp app2 = WebApps.$for((Object)this).at("0.0.0.0:50000").start();
        app.stop();
        app2.stop();
    }

    @Test(expected=WebAppException.class)
    public void testCreateWithNonZeroPort() {
        WebApp app = WebApps.$for((Object)this).at(50000).start();
        int port = app.getListenerAddress().getPort();
        Assert.assertEquals((long)50000L, (long)port);
        WebApp app2 = WebApps.$for((Object)this).at(50000).start();
        app.stop();
        app2.stop();
    }

    @Test
    public void testServePaths() {
        WebApp app = WebApps.$for((String)"test", (Object)this).start();
        Assert.assertEquals((Object)"/test", (Object)app.getRedirectPath());
        String[] expectedPaths = new String[]{"/test", "/test/*"};
        Object[] pathSpecs = app.getServePathSpecs();
        Assert.assertEquals((long)2L, (long)pathSpecs.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])pathSpecs, (Object)expectedPaths[i]));
        }
        app.stop();
    }

    @Test
    public void testServePathsNoName() {
        WebApp app = WebApps.$for((String)"", (Object)this).start();
        Assert.assertEquals((Object)"/", (Object)app.getRedirectPath());
        String[] expectedPaths = new String[]{"/*"};
        Object[] pathSpecs = app.getServePathSpecs();
        Assert.assertEquals((long)1L, (long)pathSpecs.length);
        for (int i = 0; i < expectedPaths.length; ++i) {
            Assert.assertTrue((boolean)ArrayUtils.contains((Object[])pathSpecs, (Object)expectedPaths[i]));
        }
        app.stop();
    }

    @Test
    public void testDefaultRoutes() throws Exception {
        WebApp app = WebApps.$for((String)"test", (Object)this).start();
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/foo").trim());
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test/foo/index").trim());
            Assert.assertEquals((Object)"bar", (Object)TestWebApp.getContent(baseUrl + "test/foo/bar").trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent(baseUrl + "test").trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent(baseUrl + "test/").trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent(baseUrl).trim());
        }
        finally {
            app.stop();
        }
    }

    @Test
    public void testCustomRoutes() throws Exception {
        WebApp app = WebApps.$for((String)"test", TestWebApp.class, (Object)this, (String)"ws").start(new WebApp(){

            public void setup() {
                this.bind(MyTestJAXBContextResolver.class);
                this.bind(MyTestWebService.class);
                this.route("/:foo", FooController.class);
                this.route("/bar/foo", FooController.class, "bar");
                this.route("/foo/:foo", DefaultController.class);
                this.route("/foo/bar/:foo", DefaultController.class, "index");
            }
        });
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl).trim());
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl + "test").trim());
            Assert.assertEquals((Object)"foo1", (Object)TestWebApp.getContent(baseUrl + "test/1").trim());
            Assert.assertEquals((Object)"bar", (Object)TestWebApp.getContent(baseUrl + "test/bar/foo").trim());
            Assert.assertEquals((Object)"default", (Object)TestWebApp.getContent(baseUrl + "test/foo/bar").trim());
            Assert.assertEquals((Object)"default1", (Object)TestWebApp.getContent(baseUrl + "test/foo/1").trim());
            Assert.assertEquals((Object)"default2", (Object)TestWebApp.getContent(baseUrl + "test/foo/bar/2").trim());
            Assert.assertEquals((long)404L, (long)TestWebApp.getResponseCode(baseUrl + "test/goo"));
            Assert.assertEquals((long)200L, (long)TestWebApp.getResponseCode(baseUrl + "ws/v1/test"));
            Assert.assertTrue((boolean)TestWebApp.getContent(baseUrl + "ws/v1/test").contains("myInfo"));
        }
        finally {
            app.stop();
        }
    }

    @Test
    public void testYARNWebAppContext() throws Exception {
        System.setProperty("hadoop.log.dir", "/Not/Existing/dir");
        WebApp app = WebApps.$for((String)"test", (Object)this).start(new WebApp(){

            public void setup() {
                this.route("/", FooController.class);
            }
        });
        String baseUrl = TestWebApp.baseUrl(app);
        try {
            Assert.assertFalse((boolean)"foo".equals(TestWebApp.getContent(baseUrl + "static").trim()));
            Assert.assertEquals((long)404L, (long)TestWebApp.getResponseCode(baseUrl + "logs"));
            Assert.assertEquals((Object)"foo", (Object)TestWebApp.getContent(baseUrl).trim());
        }
        finally {
            app.stop();
        }
    }

    static String baseUrl(WebApp app) {
        return "http://localhost:" + app.port() + "/";
    }

    static String getContent(String url) {
        try {
            StringBuilder out = new StringBuilder();
            InputStream in = new URL(url).openConnection().getInputStream();
            byte[] buffer = new byte[65536];
            int len = in.read(buffer);
            while (len > 0) {
                out.append(new String(buffer, 0, len));
                len = in.read(buffer);
            }
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static int getResponseCode(String url) {
        try {
            HttpURLConnection c = (HttpURLConnection)new URL(url).openConnection();
            return c.getResponseCode();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        WebApps.$for((String)"test", (Object)new TestWebApp()).at(8888).inDevMode().start().joinThread();
    }

    static class TablesView
    extends HtmlPage {
        TablesView() {
        }

        public void render(Hamlet.HTML<HtmlPage._> html) {
            this.set("ui.dataTables.id", "t1 t2 t3 t4");
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t1"), JQueryUI.tableInit().append("}").toString());
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t2"), StringHelper.join((Object[])new Object[]{"{bJQueryUI:true, sDom:'t',", "aoColumns:[null, {bSortable:false, bSearchable:false}]}"}));
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t3"), "{bJQueryUI:true, sDom:'t'}");
            this.set(JQueryUI.initID((String)"ui.dataTables", (String)"t4"), "{bJQueryUI:true, sDom:'t'}");
            ((Hamlet.HTML)((Hamlet.DIV)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TD)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TBODY)((Hamlet.TR)((Hamlet.TD)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.TABLE)((Hamlet.THEAD)((Hamlet.DIV)((Hamlet.TABLE)((Hamlet.TBODY)((Hamlet.TBODY)((Hamlet.TABLE)((Hamlet.THEAD)html.title("Test DataTables").link("/static/yarn.css")._(JQueryUI.class).style(new Object[]{".wrapper { padding: 1em }", ".wrapper h2 { margin: 0.5em 0 }", ".dataTables_wrapper { min-height: 1em }"}).div(".wrapper").h2("Default table init").table("#t1").thead().tr().th("Column1").th("Column2")._())._()).tbody().tr().td("c1r1").td("c2r1")._()).tr().td("c1r2").td("c2r2")._())._())._()).h2("Nested tables").div(".info-wrap.ui-widget-content.ui-corner-bottom").table("#t2").thead().tr().th(".ui-state-default", "Column1").th(".ui-state-default", "Column2")._())._()).tbody().tr().td("r1").td().$class("table").table("#t3").thead().tr().th("SubColumn1").th("SubColumn2")._())._()).tbody().tr().td("subc1r1").td("subc2r1")._()).tr().td("subc1r2").td("subc2r2")._())._())._())._())._()).tr().td("r2").td().$class("table").table("#t4").thead().tr().th("SubColumn1").th("SubColumn2")._())._()).tbody().tr().td("subc1r1").td("subc2r1")._()).tr().td("subc1r2").td("subc2r2")._())._())._())._())._())._())._())._())._())._();
        }
    }

    static class DefaultController
    extends Controller {
        DefaultController() {
        }

        public void index() {
            this.set("key", "default");
            this.render(FooView.class);
        }
    }

    static class FooView
    extends TextPage {
        FooView() {
        }

        public void render() {
            this.puts(new Object[]{this.$("key"), this.$("foo")});
        }
    }

    static class FooController
    extends Controller {
        final TestWebApp test;

        @Inject
        FooController(TestWebApp test) {
            this.test = test;
        }

        public void index() {
            this.set("key", this.test.echo("foo"));
        }

        public void bar() {
            this.set("key", "bar");
        }

        public void names() {
            for (int i = 0; i < 20; ++i) {
                this.renderText(MockApps.newAppName() + "\n");
            }
        }

        public void ex() {
            boolean err = this.$("clear").isEmpty();
            this.renderText(err ? "Should redirect to an error page." : "No error!");
            if (err) {
                throw new RuntimeException("exception test");
            }
        }

        public void tables() {
            this.render(TablesView.class);
        }
    }
}

