/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.util;

import java.net.URISyntaxException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.yarn.api.TestContainerId;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestConverterUtils {
    @Test
    public void testConvertUrlWithNoPort() throws URISyntaxException {
        Path expectedPath = new Path("hdfs://foo.com");
        URL url = ConverterUtils.getYarnUrlFromPath((Path)expectedPath);
        Path actualPath = ConverterUtils.getPathFromYarnURL((URL)url);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testConvertUrlWithUserinfo() throws URISyntaxException {
        Path expectedPath = new Path("foo://username:password@example.com:8042");
        URL url = ConverterUtils.getYarnUrlFromPath((Path)expectedPath);
        Path actualPath = ConverterUtils.getPathFromYarnURL((URL)url);
        Assert.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    public void testContainerId() throws URISyntaxException {
        ContainerId id = TestContainerId.newContainerId(0, 0, 0L, 0);
        String cid = ConverterUtils.toString((ContainerId)id);
        Assert.assertEquals((Object)"container_0_0000_00_000000", (Object)cid);
        ContainerId gen = ConverterUtils.toContainerId((String)cid);
        Assert.assertEquals((Object)gen, (Object)id);
    }

    @Test
    public void testContainerIdNull() throws URISyntaxException {
        Assert.assertNull((Object)ConverterUtils.toString((ContainerId)null));
    }
}

