/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.examples.pi;

import com.google.common.base.Charsets;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import org.apache.hadoop.examples.pi.Combinable;
import org.apache.hadoop.examples.pi.DistSum;
import org.apache.hadoop.examples.pi.TaskResult;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.util.ToolRunner;

public class Util {
    public static final PrintStream out = System.out;
    public static final PrintStream err = System.out;
    static final int DOUBLE_PRECISION = 52;
    static final int MACHEPS_EXPONENT = 53;
    private static final String JOB_SEPARATION_PROPERTY = "pi.job.separation.seconds";
    private static final Semaphore JOB_SEMAPHORE = new Semaphore(1);

    public static String millis2String(long n) {
        if (n < 0L) {
            return "-" + Util.millis2String(-n);
        }
        if (n < 1000L) {
            return n + "ms";
        }
        StringBuilder b = new StringBuilder();
        int millis = (int)(n % 1000L);
        if (millis != 0) {
            b.append(String.format(".%03d", millis));
        }
        if ((n /= 1000L) < 60L) {
            return b.insert(0, n).append("s").toString();
        }
        b.insert(0, String.format(":%02d", (int)(n % 60L)));
        if ((n /= 60L) < 60L) {
            return b.insert(0, n).toString();
        }
        b.insert(0, String.format(":%02d", (int)(n % 60L)));
        if ((n /= 60L) < 24L) {
            return b.insert(0, n).toString();
        }
        b.insert(0, n % 24L);
        int days = (int)((n /= 24L) % 365L);
        b.insert(0, days == 1 ? " day " : " days ").insert(0, days);
        if ((n /= 365L) > 0L) {
            b.insert(0, n == 1L ? " year " : " years ").insert(0, n);
        }
        return b.toString();
    }

    public static long string2long(String s) {
        return Long.parseLong(s.trim().replace(",", ""));
    }

    public static String long2string(long n) {
        if (n < 0L) {
            return "-" + Util.long2string(-n);
        }
        StringBuilder b = new StringBuilder();
        while (n >= 1000L) {
            b.insert(0, String.format(",%03d", n % 1000L));
            n /= 1000L;
        }
        return n + b.toString();
    }

    public static long parseLongVariable(String name, String s) {
        return Util.string2long(Util.parseStringVariable(name, s));
    }

    public static String parseStringVariable(String name, String s) {
        if (!s.startsWith(name + '=')) {
            throw new IllegalArgumentException("!s.startsWith(name + '='), name=" + name + ", s=" + s);
        }
        return s.substring(name.length() + 1);
    }

    public static <T, E extends Callable<T>> void execute(int nThreads, List<E> callables) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool(nThreads);
        List futures = executor.invokeAll(callables);
        for (Future f : futures) {
            f.get();
        }
    }

    public static int printUsage(String[] args, String usage) {
        err.println("args = " + Arrays.asList(args));
        err.println();
        err.println("Usage: java " + usage);
        err.println();
        ToolRunner.printGenericCommandUsage((PrintStream)err);
        return -1;
    }

    public static <T extends Combinable<T>> List<T> combine(Collection<T> items) {
        ArrayList<T> sorted = new ArrayList<T>(items);
        if (sorted.size() <= 1) {
            return sorted;
        }
        Collections.sort(sorted);
        ArrayList<Combinable> combined = new ArrayList<Combinable>(items.size());
        Combinable prev = (Combinable)sorted.get(0);
        for (int i = 1; i < sorted.size(); ++i) {
            Combinable curr = (Combinable)sorted.get(i);
            Combinable c = curr.combine(prev);
            if (c != null) {
                prev = c;
                continue;
            }
            combined.add(prev);
            prev = curr;
        }
        combined.add(prev);
        return combined;
    }

    public static void checkDirectory(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            throw new IllegalArgumentException("!dir.mkdirs(), dir=" + dir);
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException("dir (=" + dir + ") is not a directory.");
        }
    }

    public static PrintWriter createWriter(File dir, String prefix) throws IOException {
        Util.checkDirectory(dir);
        SimpleDateFormat dateFormat = new SimpleDateFormat("-yyyyMMdd-HHmmssSSS");
        File f;
        while ((f = new File(dir, prefix + dateFormat.format(new Date(System.currentTimeMillis())) + ".txt")).exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
            }
        }
        return new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(f), Charsets.UTF_8));
    }

    public static void printBitSkipped(long b) {
        out.println();
        out.println("b = " + Util.long2string(b) + " (" + (b < 2L ? "bit" : "bits") + " skipped)");
    }

    public static String pi2string(double pi, long terms) {
        long value = (long)(pi * 4.503599627370496E15);
        int acc_bit = Util.accuracy(terms, false);
        int acc_hex = acc_bit / 4;
        int shift = 52 - acc_bit;
        return String.format("%0" + acc_hex + "X %0" + (13 - acc_hex) + "X (%d hex digits)", value >> shift, value & (long)((1 << shift) - 1), acc_hex);
    }

    public static int accuracy(long terms, boolean print) {
        double error = terms <= 0L ? 2.0 : Math.log(terms) / Math.log(2.0) / 2.0;
        int bits = 53 - (int)Math.ceil(error);
        if (print) {
            out.println("accuracy: bits=" + bits + ", terms=" + Util.long2string(terms) + ", error exponent=" + error);
        }
        return bits - bits % 4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runJob(String name, Job job, DistSum.Machine machine, String startmessage, Timer timer) {
        JOB_SEMAPHORE.acquireUninterruptibly();
        Long starttime = null;
        try {
            try {
                starttime = timer.tick("starting " + name + " ...\n  " + startmessage);
                machine.init(job);
                job.submit();
                long sleeptime = 1000L * (long)job.getConfiguration().getInt(JOB_SEPARATION_PROPERTY, 10);
                if (sleeptime > 0L) {
                    out.println(name + "> sleep(" + Util.millis2String(sleeptime) + ")");
                    Thread.sleep(sleeptime);
                }
            }
            finally {
                JOB_SEMAPHORE.release();
            }
            if (!job.waitForCompletion(false)) {
                throw new RuntimeException(name + " failed.");
            }
        }
        catch (Exception e) {
            throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
        }
        finally {
            if (starttime != null) {
                timer.tick(name + "> timetaken=" + Util.millis2String(timer.tick() - starttime));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static List<TaskResult> readJobOutputs(FileSystem fs, Path outdir) throws IOException {
        ArrayList<TaskResult> results = new ArrayList<TaskResult>();
        for (FileStatus status : fs.listStatus(outdir)) {
            if (!status.getPath().getName().startsWith("part-")) continue;
            try (BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)fs.open(status.getPath()), Charsets.UTF_8));){
                String line;
                while ((line = in.readLine()) != null) {
                    results.add(TaskResult.valueOf(line));
                }
            }
        }
        if (results.isEmpty()) {
            throw new IOException("Output not found");
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeResults(String name, List<TaskResult> results, FileSystem fs, String dir) throws IOException {
        Path outfile = new Path(dir, name + ".txt");
        out.println(name + "> writing results to " + outfile);
        try (PrintWriter out = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)fs.create(outfile), Charsets.UTF_8), true);){
            for (TaskResult r : results) {
                out.println(r);
            }
        }
    }

    static boolean createNonexistingDirectory(FileSystem fs, Path dir) throws IOException {
        if (fs.exists(dir)) {
            err.println("dir (= " + dir + ") already exists.");
            return false;
        }
        if (!fs.mkdirs(dir)) {
            throw new IOException("Cannot create working directory " + dir);
        }
        fs.setPermission(dir, new FsPermission(511));
        return true;
    }

    public static class Timer {
        private final boolean isAccumulative;
        private final long start;
        private long previous;

        public Timer(boolean isAccumulative) {
            this.previous = this.start = System.currentTimeMillis();
            this.isAccumulative = isAccumulative;
            StackTraceElement[] stack = Thread.currentThread().getStackTrace();
            StackTraceElement e = stack[stack.length - 1];
            out.println(e + " started at " + new Date(this.start));
        }

        public long tick() {
            return this.tick(null);
        }

        public synchronized long tick(String s) {
            long t = System.currentTimeMillis();
            long delta = t - (this.isAccumulative ? this.start : this.previous);
            if (s != null) {
                out.format("%15dms (=%-15s: %s%n", delta, Util.millis2String(delta) + ")", s);
                out.flush();
            }
            this.previous = t;
            return delta;
        }
    }
}

