/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.MiniDFSNNTopology;
import org.apache.hadoop.hdfs.server.namenode.ha.HATestUtil;
import org.apache.hadoop.hdfs.web.WebHdfsFileSystem;
import org.junit.Assert;
import org.junit.Test;

public class TestWebHDFSForHA {
    private static final String LOGICAL_NAME = "minidfs";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        conf.setBoolean("dfs.webhdfs.enabled", true);
        MiniDFSNNTopology topo = new MiniDFSNNTopology().addNameservice(new MiniDFSNNTopology.NSConf(LOGICAL_NAME).addNN(new MiniDFSNNTopology.NNConf("nn1")).addNN(new MiniDFSNNTopology.NNConf("nn2")));
        MiniDFSCluster cluster = new MiniDFSCluster.Builder(conf).nnTopology(topo).numDataNodes(3).build();
        HATestUtil.setFailoverConfigurations(cluster, conf, LOGICAL_NAME);
        WebHdfsFileSystem fs = null;
        try {
            cluster.waitActive();
            String uri = "webhdfs://minidfs";
            fs = (WebHdfsFileSystem)FileSystem.get((URI)new URI("webhdfs://minidfs"), (Configuration)conf);
            cluster.transitionToActive(0);
            Path dir = new Path("/test");
            Assert.assertTrue((boolean)fs.mkdirs(dir));
            cluster.shutdownNameNode(0);
            cluster.transitionToActive(1);
            Path dir2 = new Path("/test2");
            Assert.assertTrue((boolean)fs.mkdirs(dir2));
        }
        finally {
            if (fs != null) {
                fs.close();
            }
            cluster.shutdown();
        }
    }
}

