/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto.key;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.key.FailureInjectingJavaKeyStoreProvider;
import org.apache.hadoop.crypto.key.JavaKeyStoreProvider;
import org.apache.hadoop.crypto.key.KeyProvider;
import org.apache.hadoop.crypto.key.KeyProviderFactory;
import org.apache.hadoop.crypto.key.UserProvider;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.ProviderUtils;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.test.GenericTestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestKeyProviderFactory {
    private FileSystemTestHelper fsHelper;
    private File testRootDir;

    @Before
    public void setup() {
        this.fsHelper = new FileSystemTestHelper();
        String testRoot = this.fsHelper.getTestRootDir();
        this.testRootDir = new File(testRoot).getAbsoluteFile();
    }

    @Test
    public void testFactory() throws Exception {
        Configuration conf = new Configuration();
        String userUri = "user:///";
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        String jksUri = "jceks://file" + jksPath.toUri().toString();
        conf.set("hadoop.security.key.provider.path", "user:///," + jksUri);
        List providers = KeyProviderFactory.getProviders((Configuration)conf);
        Assert.assertEquals((long)2L, (long)providers.size());
        Assert.assertEquals(UserProvider.class, ((KeyProvider)providers.get(0)).getClass());
        Assert.assertEquals(JavaKeyStoreProvider.class, ((KeyProvider)providers.get(1)).getClass());
        Assert.assertEquals((Object)"user:///", (Object)((KeyProvider)providers.get(0)).toString());
        Assert.assertEquals((Object)jksUri, (Object)((KeyProvider)providers.get(1)).toString());
    }

    @Test
    public void testFactoryErrors() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.provider.path", "unknown:///");
        try {
            List providers = KeyProviderFactory.getProviders((Configuration)conf);
            Assert.assertTrue((String)"should throw!", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"No KeyProviderFactory for unknown:/// in hadoop.security.key.provider.path", (Object)e.getMessage());
        }
    }

    @Test
    public void testUriErrors() throws Exception {
        Configuration conf = new Configuration();
        conf.set("hadoop.security.key.provider.path", "unkn@own:/x/y");
        try {
            List providers = KeyProviderFactory.getProviders((Configuration)conf);
            Assert.assertTrue((String)"should throw!", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Bad configuration of hadoop.security.key.provider.path at unkn@own:/x/y", (Object)e.getMessage());
        }
    }

    static void checkSpecificProvider(Configuration conf, String ourUrl) throws Exception {
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        byte[] key1 = new byte[16];
        byte[] key2 = new byte[16];
        byte[] key3 = new byte[16];
        for (int i = 0; i < key1.length; ++i) {
            key1[i] = (byte)i;
            key2[i] = (byte)(i * 2);
            key3[i] = (byte)(i * 3);
        }
        Assert.assertEquals(null, (Object)provider.getKeyVersion("no-such-key"));
        Assert.assertEquals(null, (Object)provider.getMetadata("key"));
        try {
            provider.createKey("key3", key3, KeyProvider.options((Configuration)conf));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        KeyProvider.Metadata meta = provider.getMetadata("key3");
        Assert.assertEquals((Object)"AES/CTR/NoPadding", (Object)meta.getCipher());
        Assert.assertEquals((long)128L, (long)meta.getBitLength());
        Assert.assertEquals((long)1L, (long)meta.getVersions());
        Assert.assertArrayEquals((byte[])key3, (byte[])provider.getCurrentKey("key3").getMaterial());
        Assert.assertEquals((Object)"key3@0", (Object)provider.getCurrentKey("key3").getVersionName());
        try {
            provider.createKey("key3", key3, KeyProvider.options((Configuration)conf));
            Assert.assertTrue((String)"should throw", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)("Key key3 already exists in " + ourUrl), (Object)e.getMessage());
        }
        provider.deleteKey("key3");
        try {
            provider.deleteKey("key3");
            Assert.assertTrue((String)"should throw", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)("Key key3 does not exist in " + ourUrl), (Object)e.getMessage());
        }
        provider.createKey("key3", key3, KeyProvider.options((Configuration)conf));
        try {
            provider.createKey("key4", key3, KeyProvider.options((Configuration)conf).setBitLength(8));
            Assert.assertTrue((String)"should throw", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Wrong key length. Required 8, but got 128", (Object)e.getMessage());
        }
        provider.createKey("key4", new byte[]{1}, KeyProvider.options((Configuration)conf).setBitLength(8));
        provider.rollNewVersion("key4", new byte[]{2});
        meta = provider.getMetadata("key4");
        Assert.assertEquals((long)2L, (long)meta.getVersions());
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])provider.getCurrentKey("key4").getMaterial());
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])provider.getKeyVersion("key4@0").getMaterial());
        Assert.assertEquals((Object)"key4@1", (Object)provider.getCurrentKey("key4").getVersionName());
        try {
            provider.rollNewVersion("key4", key1);
            Assert.assertTrue((String)"should throw", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Wrong key length. Required 8, but got 128", (Object)e.getMessage());
        }
        try {
            provider.rollNewVersion("no-such-key", key1);
            Assert.assertTrue((String)"should throw", (boolean)false);
        }
        catch (IOException e) {
            Assert.assertEquals((Object)"Key no-such-key not found", (Object)e.getMessage());
        }
        provider.flush();
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])provider.getCurrentKey("key4").getMaterial());
        Assert.assertArrayEquals((byte[])key3, (byte[])provider.getCurrentKey("key3").getMaterial());
        Assert.assertEquals((Object)"key3@0", (Object)provider.getCurrentKey("key3").getVersionName());
        List keys = provider.getKeys();
        Assert.assertTrue((String)"Keys should have been returned.", (keys.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)"Returned Keys should have included key3.", (boolean)keys.contains("key3"));
        Assert.assertTrue((String)"Returned Keys should have included key4.", (boolean)keys.contains("key4"));
        List kvl = provider.getKeyVersions("key3");
        Assert.assertTrue((String)"KeyVersions should have been returned for key3.", (kvl.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)"KeyVersions should have included key3@0.", (boolean)((KeyProvider.KeyVersion)kvl.get(0)).getVersionName().equals("key3@0"));
        Assert.assertArrayEquals((byte[])key3, (byte[])((KeyProvider.KeyVersion)kvl.get(0)).getMaterial());
    }

    @Test
    public void testUserProvider() throws Exception {
        Configuration conf = new Configuration();
        String ourUrl = "user:///";
        conf.set("hadoop.security.key.provider.path", "user:///");
        TestKeyProviderFactory.checkSpecificProvider(conf, "user:///");
        Credentials credentials = UserGroupInformation.getCurrentUser().getCredentials();
        Assert.assertArrayEquals((byte[])new byte[]{1}, (byte[])credentials.getSecretKey(new Text("key4@0")));
        Assert.assertArrayEquals((byte[])new byte[]{2}, (byte[])credentials.getSecretKey(new Text("key4@1")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testJksProvider() throws Exception {
        Configuration conf = new Configuration();
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(this.testRootDir, "test.jks");
        file.delete();
        conf.set("hadoop.security.key.provider.path", ourUrl);
        TestKeyProviderFactory.checkSpecificProvider(conf, ourUrl);
        conf.set("hadoop.security.key.provider.path", ourUrl.replace("jceks", "failjceks"));
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        FailureInjectingJavaKeyStoreProvider fProvider = (FailureInjectingJavaKeyStoreProvider)provider;
        fProvider.setWriteFail(true);
        provider.createKey("key5", new byte[]{1}, KeyProvider.options((Configuration)conf).setBitLength(8));
        Assert.assertNotNull((Object)provider.getCurrentKey("key5"));
        try {
            provider.flush();
            Assert.fail((String)"Should not succeed");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertNull((Object)provider.getCurrentKey("key5"));
        fProvider.setWriteFail(false);
        fProvider.setBackupFail(true);
        provider.createKey("key6", new byte[]{1}, KeyProvider.options((Configuration)conf).setBitLength(8));
        Assert.assertNotNull((Object)provider.getCurrentKey("key6"));
        try {
            provider.flush();
            Assert.fail((String)"Should not succeed");
        }
        catch (Exception e) {
            // empty catch block
        }
        Assert.assertNull((Object)provider.getCurrentKey("key6"));
        conf.set("hadoop.security.key.provider.path", ourUrl.replace("failjceks", "jceks"));
        Path path = ProviderUtils.unnestUri((URI)new URI(ourUrl));
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assert.assertTrue((boolean)s.getPermission().toString().equals("rwx------"));
        Assert.assertTrue((String)(file + " should exist"), (boolean)file.isFile());
        File oldFile = new File(file.getPath() + "_OLD");
        file.renameTo(oldFile);
        file.delete();
        file.createNewFile();
        Assert.assertTrue((boolean)oldFile.exists());
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assert.assertTrue((boolean)file.exists());
        Assert.assertTrue((String)(oldFile + "should be deleted"), (!oldFile.exists() ? 1 : 0) != 0);
        this.verifyAfterReload(file, provider);
        Assert.assertTrue((!oldFile.exists() ? 1 : 0) != 0);
        File newFile = new File(file.getPath() + "_NEW");
        newFile.createNewFile();
        try {
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assert.fail((String)"_NEW and current file should not exist together !!");
        }
        catch (Exception e) {
        }
        finally {
            if (newFile.exists()) {
                newFile.delete();
            }
        }
        file.renameTo(newFile);
        file.delete();
        try {
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assert.assertFalse((boolean)newFile.exists());
            Assert.assertFalse((boolean)oldFile.exists());
        }
        catch (Exception e) {
            Assert.fail((String)"JKS should load from _NEW file !!");
        }
        this.verifyAfterReload(file, provider);
        newFile.createNewFile();
        file.renameTo(oldFile);
        file.delete();
        try {
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assert.assertFalse((boolean)newFile.exists());
            Assert.assertFalse((boolean)oldFile.exists());
        }
        catch (Exception e) {
            Assert.fail((String)"JKS should load from _OLD file !!");
        }
        finally {
            if (newFile.exists()) {
                newFile.delete();
            }
        }
        this.verifyAfterReload(file, provider);
        fs.setPermission(path, new FsPermission("777"));
        this.checkPermissionRetention(conf, ourUrl, path);
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        try {
            provider.createKey("UPPERCASE", KeyProvider.options((Configuration)conf));
            Assert.fail((String)"Expected failure on creating key name with uppercase characters");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains("Uppercase key names", e);
        }
    }

    private void verifyAfterReload(File file, KeyProvider provider) throws IOException {
        List existingKeys = provider.getKeys();
        Assert.assertTrue((boolean)existingKeys.contains("key4"));
        Assert.assertTrue((boolean)existingKeys.contains("key3"));
        Assert.assertTrue((boolean)file.exists());
    }

    public void checkPermissionRetention(Configuration conf, String ourUrl, Path path) throws Exception {
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        byte[] key = new byte[16];
        for (int i = 0; i < key.length; ++i) {
            key[i] = (byte)i;
        }
        try {
            provider.createKey("key5", key, KeyProvider.options((Configuration)conf));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        provider.flush();
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assert.assertArrayEquals((byte[])key, (byte[])provider.getCurrentKey("key5").getMaterial());
        FileSystem fs = path.getFileSystem(conf);
        FileStatus s = fs.getFileStatus(path);
        Assert.assertTrue((String)"Permissions should have been retained from the preexisting keystore.", (boolean)s.getPermission().toString().equals("rwxrwxrwx"));
    }

    @Test
    public void testJksProviderPasswordViaConfig() throws Exception {
        KeyProvider provider;
        Configuration conf = new Configuration();
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        String ourUrl = "jceks://file" + jksPath.toUri();
        File file = new File(this.testRootDir, "test.jks");
        file.delete();
        try {
            conf.set("hadoop.security.key.provider.path", ourUrl);
            conf.set("hadoop.security.keystore.java-keystore-provider.password-file", "javakeystoreprovider.password");
            provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
            provider.createKey("key3", new byte[16], KeyProvider.options((Configuration)conf));
            provider.flush();
        }
        catch (Exception ex) {
            Assert.fail((String)"could not create keystore with password file");
        }
        provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        Assert.assertNotNull((Object)provider.getCurrentKey("key3"));
        try {
            conf.set("hadoop.security.keystore.java-keystore-provider.password-file", "bar");
            KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assert.fail((String)"using non existing password file, it should fail");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            conf.set("hadoop.security.keystore.java-keystore-provider.password-file", "core-site.xml");
            KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assert.fail((String)"using different password file, it should fail");
        }
        catch (IOException ex) {
            // empty catch block
        }
        try {
            conf.unset("hadoop.security.keystore.java-keystore-provider.password-file");
            KeyProviderFactory.getProviders((Configuration)conf).get(0);
            Assert.fail((String)"No password file property, env not set, it should fail");
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    @Test
    public void testGetProviderViaURI() throws Exception {
        Configuration conf = new Configuration(false);
        Path jksPath = new Path(this.testRootDir.toString(), "test.jks");
        URI uri = new URI("jceks://file" + jksPath.toUri());
        KeyProvider kp = KeyProviderFactory.get((URI)uri, (Configuration)conf);
        Assert.assertNotNull((Object)kp);
        Assert.assertEquals(JavaKeyStoreProvider.class, kp.getClass());
        uri = new URI("foo://bar");
        kp = KeyProviderFactory.get((URI)uri, (Configuration)conf);
        Assert.assertNull((Object)kp);
    }

    @Test
    public void testJksProviderWithKeytoolKeys() throws Exception {
        Configuration conf = new Configuration();
        String keystoreDirAbsolutePath = conf.getResource("hdfs7067.keystore").getPath();
        String ourUrl = "jceks://file@/" + keystoreDirAbsolutePath;
        conf.set("hadoop.security.key.provider.path", ourUrl);
        KeyProvider provider = (KeyProvider)KeyProviderFactory.getProviders((Configuration)conf).get(0);
        KeyProvider.KeyVersion keyVersion = provider.getKeyVersion("testkey5@0");
        try {
            KeyProvider.KeyVersion keyVersionWrongKeyNameFormat = provider.getKeyVersion("testkey2");
            Assert.fail((String)"should have thrown an exception");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("No version in key path", e);
        }
        try {
            KeyProvider.KeyVersion keyVersionCurrentKeyNotWrongKeyNameFormat = provider.getCurrentKey("testkey5@0");
            Assert.fail((String)"should have thrown an exception getting testkey5@0");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("other non-Hadoop method", e);
        }
        try {
            KeyProvider.KeyVersion keyVersionCurrentKeyNotReally = provider.getCurrentKey("testkey2");
            Assert.fail((String)"should have thrown an exception getting testkey2");
        }
        catch (IOException e) {
            GenericTestUtils.assertExceptionContains("other non-Hadoop method", e);
        }
    }
}

