/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.crypto;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.crypto.CryptoCodec;
import org.apache.hadoop.crypto.CryptoInputStream;
import org.apache.hadoop.crypto.CryptoOutputStream;
import org.apache.hadoop.crypto.CryptoStreamsTestBase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Ignore;
import org.junit.Test;

public class TestCryptoStreamsForLocalFS
extends CryptoStreamsTestBase {
    private static final String TEST_ROOT_DIR = System.getProperty("test.build.data", "build/test/data") + "/work-dir/localfs";
    private final File base = new File(TEST_ROOT_DIR);
    private final Path file = new Path(TEST_ROOT_DIR, "test-file");
    private static LocalFileSystem fileSys;

    @BeforeClass
    public static void init() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("fs.file.impl", LocalFileSystem.class.getName());
        fileSys = FileSystem.getLocal((Configuration)conf);
        codec = CryptoCodec.getInstance((Configuration)conf);
    }

    @AfterClass
    public static void shutdown() throws Exception {
    }

    @Override
    @Before
    public void setUp() throws IOException {
        fileSys.delete(new Path(TEST_ROOT_DIR), true);
        super.setUp();
    }

    @After
    public void cleanUp() throws IOException {
        FileUtil.setWritable((File)this.base, (boolean)true);
        FileUtil.fullyDelete((File)this.base);
        Assert.assertTrue((!this.base.exists() ? 1 : 0) != 0);
    }

    @Override
    protected OutputStream getOutputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        return new CryptoOutputStream((OutputStream)fileSys.create(this.file), codec, bufferSize, key, iv);
    }

    @Override
    protected InputStream getInputStream(int bufferSize, byte[] key, byte[] iv) throws IOException {
        return new CryptoInputStream((InputStream)fileSys.open(this.file), codec, bufferSize, key, iv);
    }

    @Override
    @Ignore(value="ChecksumFSInputChecker doesn't support ByteBuffer read")
    @Test(timeout=1000L)
    public void testByteBufferRead() throws Exception {
    }

    @Override
    @Ignore(value="ChecksumFSOutputSummer doesn't support Syncable")
    @Test(timeout=1000L)
    public void testSyncable() throws IOException {
    }

    @Override
    @Ignore(value="ChecksumFSInputChecker doesn't support ByteBuffer read")
    @Test(timeout=1000L)
    public void testCombinedOp() throws Exception {
    }

    @Override
    @Ignore(value="ChecksumFSInputChecker doesn't support enhanced ByteBuffer access")
    @Test(timeout=1000L)
    public void testHasEnhancedByteBufferAccess() throws Exception {
    }

    @Override
    @Ignore(value="ChecksumFSInputChecker doesn't support seekToNewSource")
    @Test(timeout=1000L)
    public void testSeekToNewSource() throws Exception {
    }
}

