/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Preconditions;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.lifecycle.LifecycleSupervisor;
import org.apache.flume.node.ConfigurationProvider;
import org.apache.flume.node.NodeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeNode
implements LifecycleAware {
    private static final Logger logger = LoggerFactory.getLogger(FlumeNode.class);
    private String name;
    private LifecycleState lifecycleState;
    private NodeManager nodeManager;
    private ConfigurationProvider configurationProvider;
    private LifecycleSupervisor supervisor = new LifecycleSupervisor();

    public void start() {
        Preconditions.checkState((this.name != null ? 1 : 0) != 0, (Object)"Node name can not be null");
        Preconditions.checkState((this.nodeManager != null ? 1 : 0) != 0, (Object)"Node manager can not be null");
        this.supervisor.start();
        logger.info("Flume node starting - {}", (Object)this.name);
        this.supervisor.supervise((LifecycleAware)this.nodeManager, (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
        this.supervisor.supervise((LifecycleAware)this.configurationProvider, (LifecycleSupervisor.SupervisorPolicy)new LifecycleSupervisor.SupervisorPolicy.AlwaysRestartPolicy(), LifecycleState.START);
        this.lifecycleState = LifecycleState.START;
    }

    public void stop() {
        logger.info("Flume node stopping - {}", (Object)this.name);
        this.supervisor.stop();
        this.lifecycleState = LifecycleState.STOP;
    }

    public String toString() {
        return "{ name:" + this.name + " nodeManager:" + this.nodeManager + " configurationProvider:" + this.configurationProvider + " }";
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public NodeManager getNodeManager() {
        return this.nodeManager;
    }

    public void setNodeManager(NodeManager nodeManager) {
        this.nodeManager = nodeManager;
    }

    public ConfigurationProvider getConfigurationProvider() {
        return this.configurationProvider;
    }

    public void setConfigurationProvider(ConfigurationProvider configurationProvider) {
        this.configurationProvider = configurationProvider;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }
}

