/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf.properties;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.flume.Channel;
import org.apache.flume.ChannelSelector;
import org.apache.flume.Context;
import org.apache.flume.Sink;
import org.apache.flume.SinkProcessor;
import org.apache.flume.SinkRunner;
import org.apache.flume.Source;
import org.apache.flume.SourceRunner;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.channel.ChannelSelectorFactory;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.Configurables;
import org.apache.flume.conf.FlumeConfiguration;
import org.apache.flume.conf.channel.ChannelSelectorConfiguration;
import org.apache.flume.conf.file.AbstractFileConfigurationProvider;
import org.apache.flume.conf.file.SimpleNodeConfiguration;
import org.apache.flume.conf.sink.SinkConfiguration;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.conf.source.SourceConfiguration;
import org.apache.flume.node.NodeConfiguration;
import org.apache.flume.sink.DefaultSinkProcessor;
import org.apache.flume.sink.SinkGroup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesFileConfigurationProvider
extends AbstractFileConfigurationProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertiesFileConfigurationProvider.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void load() {
        File propertiesFile = this.getFile();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(propertiesFile));
            Properties properties = new Properties();
            properties.load(reader);
            SimpleNodeConfiguration conf = new SimpleNodeConfiguration();
            FlumeConfiguration fconfig = new FlumeConfiguration(properties);
            FlumeConfiguration.AgentConfiguration agentConf = fconfig.getConfigurationFor(this.getNodeName());
            if (agentConf != null) {
                this.getConfigurationAware().stopAllComponents();
                this.loadChannels(agentConf, conf);
                this.loadSources(agentConf, conf);
                this.loadSinks(agentConf, conf);
                this.getConfigurationAware().startAllComponents(conf);
            } else {
                LOGGER.warn("No configuration found for this host:{}", (Object)this.getNodeName());
            }
        }
        catch (IOException ex) {
            LOGGER.error("Unable to load file:" + propertiesFile + " (I/O failure) - Exception follows.", (Throwable)ex);
        }
        catch (InstantiationException ex) {
            LOGGER.error("Unable to load file:" + propertiesFile + " (failed to instantiate component) - Exception follows.", (Throwable)ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {
                    LOGGER.warn("Unable to close file reader for file: " + propertiesFile, (Throwable)ex);
                }
            }
        }
    }

    private void loadChannels(FlumeConfiguration.AgentConfiguration agentConf, NodeConfiguration conf) throws InstantiationException {
        Channel channel;
        LOGGER.info("Creating channels");
        Set channels = agentConf.getChannelSet();
        Map compMap = agentConf.getChannelConfigMap();
        for (String chName : channels) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(chName);
            if (comp == null) continue;
            channel = this.getChannelFactory().create(comp.getComponentName(), comp.getType());
            Configurables.configure((Object)channel, (ComponentConfiguration)comp);
            conf.getChannels().put(comp.getComponentName(), channel);
        }
        for (String ch : channels) {
            Context context = (Context)agentConf.getChannelContext().get(ch);
            if (context == null) continue;
            channel = this.getChannelFactory().create(ch, context.getString("type"));
            Configurables.configure((Object)channel, (Context)context);
            conf.getChannels().put(ch, channel);
            LOGGER.info("created channel " + ch);
        }
    }

    private void loadSources(FlumeConfiguration.AgentConfiguration agentConf, NodeConfiguration conf) throws InstantiationException {
        ChannelProcessor channelProcessor;
        ChannelSelector selector;
        ChannelSelectorConfiguration selectorConfig;
        Source source;
        Set sources = agentConf.getSourceSet();
        Map compMap = agentConf.getSourceConfigMap();
        for (String sourceName : sources) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(sourceName);
            if (comp == null) continue;
            SourceConfiguration config = (SourceConfiguration)comp;
            source = this.getSourceFactory().create(comp.getComponentName(), comp.getType());
            Configurables.configure((Object)source, (ComponentConfiguration)config);
            Set channelNames = config.getChannels();
            ArrayList<Channel> channels = new ArrayList<Channel>();
            for (String chName : channelNames) {
                channels.add(conf.getChannels().get(chName));
            }
            selectorConfig = config.getSelectorConfiguration();
            selector = ChannelSelectorFactory.create(channels, (ChannelSelectorConfiguration)selectorConfig);
            channelProcessor = new ChannelProcessor(selector);
            Configurables.configure((Object)channelProcessor, (ComponentConfiguration)config);
            source.setChannelProcessor(channelProcessor);
            conf.getSourceRunners().put(comp.getComponentName(), SourceRunner.forSource((Source)source));
        }
        Map sourceContexts = agentConf.getSourceContext();
        for (String src : sources) {
            String[] channelNames;
            Context context = (Context)sourceContexts.get(src);
            if (context == null) continue;
            source = this.getSourceFactory().create(src, context.getString("type"));
            ArrayList<Channel> channels = new ArrayList<Channel>();
            Configurables.configure((Object)source, (Context)context);
            for (String chName : channelNames = context.getString("channels").split("\\s+")) {
                channels.add(conf.getChannels().get(chName));
            }
            selectorConfig = context.getSubProperties("selector.");
            selector = ChannelSelectorFactory.create(channels, (Map)selectorConfig);
            channelProcessor = new ChannelProcessor(selector);
            Configurables.configure((Object)channelProcessor, (Context)context);
            source.setChannelProcessor(channelProcessor);
            conf.getSourceRunners().put(src, SourceRunner.forSource((Source)source));
        }
    }

    private void loadSinks(FlumeConfiguration.AgentConfiguration agentConf, NodeConfiguration conf) throws InstantiationException {
        Sink sink;
        Set sinkNames = agentConf.getSinkSet();
        Map compMap = agentConf.getSinkConfigMap();
        HashMap<String, Sink> sinks = new HashMap<String, Sink>();
        for (String sinkName : sinkNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(sinkName);
            if (comp == null) continue;
            SinkConfiguration config = (SinkConfiguration)comp;
            sink = this.getSinkFactory().create(comp.getComponentName(), comp.getType());
            Configurables.configure((Object)sink, (ComponentConfiguration)config);
            sink.setChannel(conf.getChannels().get(config.getChannel()));
            sinks.put(comp.getComponentName(), sink);
        }
        Map sinkContexts = agentConf.getSinkContext();
        for (String sinkName : sinkNames) {
            Context context = (Context)sinkContexts.get(sinkName);
            if (context == null) continue;
            sink = this.getSinkFactory().create(sinkName, context.getString("type"));
            Configurables.configure((Object)sink, (Context)context);
            sink.setChannel(conf.getChannels().get(context.getString("channel")));
            sinks.put(sinkName, sink);
        }
        this.loadSinkGroups(agentConf, sinks, conf);
    }

    private void loadSinkGroups(FlumeConfiguration.AgentConfiguration agentConf, Map<String, Sink> sinks, NodeConfiguration conf) throws InstantiationException {
        Set sinkgroupNames = agentConf.getSinkgroupSet();
        Map compMap = agentConf.getSinkGroupConfigMap();
        HashMap<String, String> usedSinks = new HashMap<String, String>();
        for (String string : sinkgroupNames) {
            ComponentConfiguration comp = (ComponentConfiguration)compMap.get(string);
            if (comp == null) continue;
            SinkGroupConfiguration groupConf = (SinkGroupConfiguration)comp;
            List groupSinkList = groupConf.getSinks();
            ArrayList<Sink> groupSinks = new ArrayList<Sink>();
            for (String sink : groupSinkList) {
                Sink s = sinks.remove(sink);
                if (s == null) {
                    String sinkUser = (String)usedSinks.get(sink);
                    if (sinkUser != null) {
                        throw new InstantiationException(String.format("Sink %s of group %s already in use by group %s", sink, string, sinkUser));
                    }
                    throw new InstantiationException(String.format("Sink %s of group %s does not exist or is not properly configured", sink, string));
                }
                groupSinks.add(s);
                usedSinks.put(sink, string);
            }
            SinkGroup group = new SinkGroup(groupSinks);
            Configurables.configure((Object)group, (ComponentConfiguration)groupConf);
            conf.getSinkRunners().put(comp.getComponentName(), new SinkRunner(group.getProcessor()));
        }
        for (Map.Entry entry : sinks.entrySet()) {
            if (usedSinks.containsValue(entry.getKey())) continue;
            DefaultSinkProcessor pr = new DefaultSinkProcessor();
            ArrayList sinkMap = new ArrayList();
            sinkMap.add(entry.getValue());
            pr.setSinks(sinkMap);
            Configurables.configure((Object)pr, (Context)new Context());
            conf.getSinkRunners().put((String)entry.getKey(), new SinkRunner((SinkProcessor)pr));
        }
    }
}

