/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.annotation.plugin.bnd;

import aQute.bnd.osgi.Analyzer;
import aQute.bnd.osgi.ClassDataCollector;
import aQute.bnd.osgi.Clazz;
import aQute.bnd.osgi.EmbeddedResource;
import aQute.bnd.osgi.Resource;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.felix.dm.annotation.plugin.bnd.AnnotationCollector;
import org.apache.felix.dm.annotation.plugin.bnd.Logger;
import org.apache.felix.dm.annotation.plugin.bnd.MetaType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DescriptorGenerator {
    private Analyzer m_analyzer;
    Map<String, Resource> m_resources = new HashMap<String, Resource>();
    private Resource m_metaTypeResource;
    private final Logger m_logger;
    private Set<String> m_importService = new HashSet<String>();
    private Set<String> m_exportService = new HashSet<String>();

    public DescriptorGenerator(Analyzer analyzer, Logger logger) {
        this.m_analyzer = analyzer;
        this.m_logger = logger;
    }

    public boolean execute() throws Exception {
        boolean annotationsFound = false;
        Clazz clazz = null;
        Collection expanded = this.m_analyzer.getClasses(new String[]{"", Clazz.QUERY.NAMED.toString(), "*"});
        MetaType metaType = new MetaType();
        Iterator i$ = expanded.iterator();
        while (i$.hasNext()) {
            Clazz c;
            clazz = c = (Clazz)i$.next();
            AnnotationCollector reader = new AnnotationCollector(this.m_logger, metaType);
            c.parseClassFileWithCollector((ClassDataCollector)reader);
            if (!reader.finish()) continue;
            String name = c.getFQN();
            Resource resource = this.createComponentResource(reader);
            this.m_resources.put("META-INF/dependencymanager/" + name, resource);
            annotationsFound = true;
            this.m_importService.addAll(reader.getImportService());
            this.m_exportService.addAll(reader.getExportService());
        }
        if (metaType.getSize() > 0) {
            this.m_metaTypeResource = this.createMetaTypeResource(metaType);
        }
        return annotationsFound;
    }

    public String getDescriptorPaths() {
        StringBuilder descriptorPaths = new StringBuilder();
        String del = "";
        for (Map.Entry<String, Resource> entry : this.m_resources.entrySet()) {
            descriptorPaths.append(del);
            descriptorPaths.append(entry.getKey());
            del = ",";
        }
        return descriptorPaths.toString();
    }

    public Map<String, Resource> getDescriptors() {
        return this.m_resources;
    }

    public Resource getMetaTypeResource() {
        return this.m_metaTypeResource;
    }

    public Set<String> getImportService() {
        return this.m_importService;
    }

    public Set<String> getExportService() {
        return this.m_exportService;
    }

    private Resource createComponentResource(AnnotationCollector collector) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        collector.writeTo(pw);
        pw.close();
        byte[] data = out.toByteArray();
        out.close();
        return new EmbeddedResource(data, 0L);
    }

    private Resource createMetaTypeResource(MetaType metaType) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        metaType.writeTo(pw);
        pw.close();
        byte[] data = out.toByteArray();
        out.close();
        return new EmbeddedResource(data, 0L);
    }
}

