/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetric;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TimelineMetricsCache {
    private final TimelineMetricHolder timelineMetricCache = new TimelineMetricHolder();
    private static final Log LOG = LogFactory.getLog(TimelineMetric.class);
    public static final int MAX_RECS_PER_NAME_DEFAULT = 10000;
    public static final int MAX_EVICTION_TIME_MILLIS = 59000;
    private final int maxRecsPerName;
    private final int maxEvictionTimeInMillis;
    private boolean skipCounterTransform = true;
    private final Map<String, Double> counterMetricLastValue = new HashMap<String, Double>();

    public TimelineMetricsCache(int maxRecsPerName, int maxEvictionTimeInMillis) {
        this(maxRecsPerName, maxEvictionTimeInMillis, false);
    }

    public TimelineMetricsCache(int maxRecsPerName, int maxEvictionTimeInMillis, boolean skipCounterTransform) {
        this.maxRecsPerName = maxRecsPerName;
        this.maxEvictionTimeInMillis = maxEvictionTimeInMillis;
        this.skipCounterTransform = skipCounterTransform;
    }

    public TimelineMetric getTimelineMetric(String metricName) {
        if (this.timelineMetricCache.containsKey(metricName)) {
            return this.timelineMetricCache.evict(metricName);
        }
        return null;
    }

    public TimelineMetrics getAllMetrics() {
        return this.timelineMetricCache.evictAll();
    }

    public int getMaxEvictionTimeInMillis() {
        return this.maxEvictionTimeInMillis;
    }

    public void putTimelineMetric(TimelineMetric timelineMetric) {
        this.timelineMetricCache.put(timelineMetric.getMetricName(), timelineMetric);
    }

    private void transformMetricValuesToDerivative(TimelineMetric timelineMetric) {
        String metricName = timelineMetric.getMetricName();
        double firstValue = timelineMetric.getMetricValues().size() > 0 ? timelineMetric.getMetricValues().entrySet().iterator().next().getValue() : 0.0;
        Double value = this.counterMetricLastValue.get(metricName);
        double previousValue = value != null ? value : firstValue;
        TreeMap<Long, Double> metricValues = timelineMetric.getMetricValues();
        TreeMap<Long, Double> newMetricValues = new TreeMap<Long, Double>();
        for (Map.Entry entry : metricValues.entrySet()) {
            newMetricValues.put((Long)entry.getKey(), (Double)entry.getValue() - previousValue);
            previousValue = (Double)entry.getValue();
        }
        timelineMetric.setMetricValues(newMetricValues);
        this.counterMetricLastValue.put(metricName, previousValue);
    }

    public void putTimelineMetric(TimelineMetric timelineMetric, boolean isCounter) {
        if (isCounter && !this.skipCounterTransform) {
            this.transformMetricValuesToDerivative(timelineMetric);
        }
        this.putTimelineMetric(timelineMetric);
    }

    class TimelineMetricHolder
    extends ConcurrentSkipListMap<String, TimelineMetricWrapper> {
        private static final long serialVersionUID = 2L;
        private Map<String, Long> endOfBufferTimestamps = new HashMap<String, Long>();

        TimelineMetricHolder() {
        }

        public TimelineMetric evict(String metricName) {
            TimelineMetricWrapper metricWrapper = (TimelineMetricWrapper)this.get(metricName);
            if (metricWrapper == null || metricWrapper.getTimeDiff() < (long)TimelineMetricsCache.this.getMaxEvictionTimeInMillis()) {
                return null;
            }
            TimelineMetric timelineMetric = metricWrapper.getTimelineMetric();
            this.remove(metricName);
            return timelineMetric;
        }

        public TimelineMetrics evictAll() {
            ArrayList<TimelineMetric> metricList = new ArrayList<TimelineMetric>();
            Iterator it = this.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry cacheEntry = it.next();
                TimelineMetricWrapper metricWrapper = (TimelineMetricWrapper)cacheEntry.getValue();
                if (metricWrapper != null) {
                    TimelineMetric timelineMetric = ((TimelineMetricWrapper)cacheEntry.getValue()).getTimelineMetric();
                    metricList.add(timelineMetric);
                }
                it.remove();
            }
            TimelineMetrics timelineMetrics = new TimelineMetrics();
            timelineMetrics.setMetrics(metricList);
            return timelineMetrics;
        }

        @Override
        public void put(String metricName, TimelineMetric timelineMetric) {
            if (this.isDuplicate(timelineMetric)) {
                return;
            }
            TimelineMetricWrapper metric = (TimelineMetricWrapper)this.get(metricName);
            if (metric == null) {
                this.put(metricName, new TimelineMetricWrapper(timelineMetric));
            } else {
                metric.putMetric(timelineMetric);
            }
            this.endOfBufferTimestamps.put(metricName, timelineMetric.getStartTime());
        }

        private boolean isDuplicate(TimelineMetric timelineMetric) {
            return this.endOfBufferTimestamps.containsKey(timelineMetric.getMetricName()) && this.endOfBufferTimestamps.get(timelineMetric.getMetricName()).equals(timelineMetric.getStartTime());
        }
    }

    class TimelineMetricWrapper {
        private long timeDiff = -1L;
        private long oldestTimestamp = -1L;
        private TimelineMetric timelineMetric;

        TimelineMetricWrapper(TimelineMetric timelineMetric) {
            this.timelineMetric = timelineMetric;
            this.oldestTimestamp = timelineMetric.getStartTime();
        }

        private void updateTimeDiff(long timestamp) {
            if (this.oldestTimestamp != -1L && timestamp > this.oldestTimestamp) {
                this.timeDiff = timestamp - this.oldestTimestamp;
            } else {
                this.oldestTimestamp = timestamp;
            }
        }

        public synchronized void putMetric(TimelineMetric metric) {
            TreeMap<Long, Double> metricValues = this.timelineMetric.getMetricValues();
            if (metricValues.size() > TimelineMetricsCache.this.maxRecsPerName) {
                long newEldestTimestamp = this.oldestTimestamp + (long)TimelineMetricsCache.this.maxEvictionTimeInMillis;
                TreeMap<Long, Double> metricsSubSet = new TreeMap<Long, Double>(metricValues.tailMap(newEldestTimestamp));
                if (metricsSubSet.isEmpty()) {
                    this.oldestTimestamp = metric.getStartTime();
                    this.timelineMetric.setStartTime(metric.getStartTime());
                } else {
                    Long newStartTime = metricsSubSet.firstKey();
                    this.oldestTimestamp = newStartTime;
                    this.timelineMetric.setStartTime(newStartTime);
                }
                this.timelineMetric.setMetricValues(metricsSubSet);
                LOG.warn((Object)("Metrics cache overflow. Values for metric " + metric.getMetricName() + " older than " + newEldestTimestamp + " were removed to clean up the cache."));
            }
            this.timelineMetric.addMetricValues(metric.getMetricValues());
            this.updateTimeDiff(metric.getStartTime());
        }

        public synchronized long getTimeDiff() {
            return this.timeDiff;
        }

        public synchronized TimelineMetric getTimelineMetric() {
            return this.timelineMetric;
        }
    }
}

