/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.metrics2.sink.timeline.MetadataException;
import org.codehaus.jackson.annotate.JsonIgnore;

@XmlRootElement(name="metric_metadata")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineMetricMetadata {
    private String metricName;
    private String appId;
    private String units;
    private String type = "UNDEFINED";
    private Long seriesStartTime;
    boolean supportsAggregates = true;
    boolean isPersisted = false;

    public TimelineMetricMetadata() {
    }

    public TimelineMetricMetadata(String metricName, String appId, String units, String type, Long seriesStartTime, boolean supportsAggregates) {
        this.metricName = metricName;
        this.appId = appId;
        this.units = units;
        this.type = type;
        this.seriesStartTime = seriesStartTime;
        this.supportsAggregates = supportsAggregates;
    }

    @XmlElement(name="metricname")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @XmlElement(name="units")
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @XmlElement(name="type")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name="seriesStartTime")
    public Long getSeriesStartTime() {
        return this.seriesStartTime;
    }

    public void setSeriesStartTime(Long seriesStartTime) {
        this.seriesStartTime = seriesStartTime;
    }

    @XmlElement(name="supportsAggregation")
    public boolean isSupportsAggregates() {
        return this.supportsAggregates;
    }

    public void setSupportsAggregates(boolean supportsAggregates) {
        this.supportsAggregates = supportsAggregates;
    }

    @JsonIgnore
    public boolean isPersisted() {
        return this.isPersisted;
    }

    public void setIsPersisted(boolean isPersisted) {
        this.isPersisted = isPersisted;
    }

    public boolean needsToBeSynced(TimelineMetricMetadata metadata) throws MetadataException {
        if (!this.metricName.equals(metadata.getMetricName()) || !this.appId.equals(metadata.getAppId())) {
            throw new MetadataException("Unexpected argument: metricName = " + metadata.getMetricName() + ", appId = " + metadata.getAppId());
        }
        return this.units != null && !this.units.equals(metadata.getUnits()) || this.type != null && !this.type.equals(metadata.getType()) || !this.supportsAggregates == metadata.isSupportsAggregates();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineMetricMetadata that = (TimelineMetricMetadata)o;
        if (!this.metricName.equals(that.metricName)) {
            return false;
        }
        return !(this.appId == null ? that.appId != null : !this.appId.equals(that.appId));
    }

    public int hashCode() {
        int result = this.metricName.hashCode();
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        return result;
    }

    public static enum MetricType {
        GAUGE,
        COUNTER,
        UNDEFINED;

    }
}

