/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@XmlRootElement(name="metric")
@XmlAccessorType(value=XmlAccessType.NONE)
@InterfaceAudience.Public
@InterfaceStability.Unstable
public class TimelineMetric
implements Comparable<TimelineMetric> {
    private String metricName;
    private String appId;
    private String instanceId;
    private String hostName;
    private long timestamp;
    private long startTime;
    private String type;
    private String units;
    private TreeMap<Long, Double> metricValues = new TreeMap();

    public TimelineMetric() {
    }

    public TimelineMetric(TimelineMetric metric) {
        this.setMetricName(metric.getMetricName());
        this.setType(metric.getType());
        this.setUnits(metric.getUnits());
        this.setTimestamp(metric.getTimestamp());
        this.setAppId(metric.getAppId());
        this.setInstanceId(metric.getInstanceId());
        this.setHostName(metric.getHostName());
        this.setStartTime(metric.getStartTime());
        this.setMetricValues(new TreeMap<Long, Double>((SortedMap<Long, Double>)metric.getMetricValues()));
    }

    @XmlElement(name="metricname")
    public String getMetricName() {
        return this.metricName;
    }

    public void setMetricName(String metricName) {
        this.metricName = metricName;
    }

    @XmlElement(name="appid")
    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @XmlElement(name="instanceid")
    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    @XmlElement(name="hostname")
    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    @XmlElement(name="timestamp")
    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @XmlElement(name="starttime")
    public long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    @XmlElement(name="type", defaultValue="UNDEFINED")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @XmlElement(name="units")
    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    @XmlElement(name="metrics")
    public TreeMap<Long, Double> getMetricValues() {
        return this.metricValues;
    }

    public void setMetricValues(TreeMap<Long, Double> metricValues) {
        this.metricValues = metricValues;
    }

    public void addMetricValues(Map<Long, Double> metricValues) {
        this.metricValues.putAll(metricValues);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimelineMetric metric = (TimelineMetric)o;
        if (!this.metricName.equals(metric.metricName)) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(metric.hostName) : metric.hostName != null) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(metric.appId) : metric.appId != null) {
            return false;
        }
        if (this.instanceId != null ? !this.instanceId.equals(metric.instanceId) : metric.instanceId != null) {
            return false;
        }
        if (this.timestamp != metric.timestamp) {
            return false;
        }
        return this.startTime == metric.startTime;
    }

    public boolean equalsExceptTime(TimelineMetric metric) {
        if (!this.metricName.equals(metric.metricName)) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(metric.hostName) : metric.hostName != null) {
            return false;
        }
        if (this.appId != null ? !this.appId.equals(metric.appId) : metric.appId != null) {
            return false;
        }
        return !(this.instanceId != null ? !this.instanceId.equals(metric.instanceId) : metric.instanceId != null);
    }

    public int hashCode() {
        int result = this.metricName.hashCode();
        result = 31 * result + (this.appId != null ? this.appId.hashCode() : 0);
        result = 31 * result + (this.instanceId != null ? this.instanceId.hashCode() : 0);
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    @Override
    public int compareTo(TimelineMetric other) {
        if (this.timestamp > other.timestamp) {
            return -1;
        }
        if (this.timestamp < other.timestamp) {
            return 1;
        }
        return this.metricName.compareTo(other.metricName);
    }
}

