/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

public enum Precision {
    SECONDS,
    MINUTES,
    HOURS,
    DAYS;


    public static Precision getPrecision(String precision) throws PrecisionFormatException {
        if (precision == null) {
            return null;
        }
        try {
            return Precision.valueOf(precision.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PrecisionFormatException("precision should be seconds, minutes, hours or days", e);
        }
    }

    public static Precision getPrecision(long startTime, long endTime) {
        long HOUR = 3600000L;
        long timeRange = endTime - startTime;
        long DAY = 86400000L;
        if (timeRange > 30L * DAY) {
            return DAYS;
        }
        if (timeRange > 1L * DAY) {
            return HOURS;
        }
        if (timeRange > 2L * HOUR) {
            return MINUTES;
        }
        return SECONDS;
    }

    public static Precision getHigherPrecision(Precision precision) {
        if (precision == null) {
            return null;
        }
        if (precision.equals((Object)SECONDS)) {
            return MINUTES;
        }
        if (precision.equals((Object)MINUTES)) {
            return HOURS;
        }
        if (precision.equals((Object)HOURS)) {
            return DAYS;
        }
        return null;
    }

    public static class PrecisionFormatException
    extends IllegalArgumentException {
        public PrecisionFormatException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

