/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.polynomials.PolynomialSplineFunction;

public class PostProcessingUtil {
    public static Map<Long, Double> interpolateMissingData(Map<Long, Double> metricValues, long expectedInterval) {
        if (metricValues == null) {
            return null;
        }
        Long prevTime = null;
        Double prevVal = null;
        TreeMap<Long, Double> interpolatedMetricValues = new TreeMap<Long, Double>();
        for (Map.Entry<Long, Double> timeValueEntry : metricValues.entrySet()) {
            Long currTime = timeValueEntry.getKey();
            Double currVal = timeValueEntry.getValue();
            if (prevTime != null) {
                Long stepTime = prevTime;
                while (currTime - stepTime > expectedInterval) {
                    stepTime = stepTime + expectedInterval;
                    double interpolatedValue = PostProcessingUtil.interpolate(stepTime, prevTime, prevVal, currTime, currVal);
                    interpolatedMetricValues.put(stepTime, interpolatedValue);
                }
            }
            interpolatedMetricValues.put(currTime, currVal);
            prevTime = currTime;
            prevVal = currVal;
        }
        return interpolatedMetricValues;
    }

    public static Double interpolate(Long t, Long t1, Double m1, Long t2, Double m2) {
        if (m1 == null && m2 == null) {
            return null;
        }
        if (m1 == null) {
            return m2;
        }
        if (m2 == null) {
            return m1;
        }
        if (t1 == null || t2 == null) {
            return null;
        }
        double slope = (m2 - m1) / (double)(t2 - t1);
        return m1 + slope * (double)(t - t1);
    }

    public static Map<Long, Double> interpolate(Map<Long, Double> valuesMap, List<Long> requiredTimestamps) {
        LinearInterpolator linearInterpolator = new LinearInterpolator();
        if (valuesMap == null || valuesMap.isEmpty()) {
            return null;
        }
        if (requiredTimestamps == null || requiredTimestamps.isEmpty()) {
            return null;
        }
        HashMap<Long, Double> interpolatedValuesMap = new HashMap<Long, Double>();
        if (valuesMap.size() == 1) {
            Double value = null;
            for (Map.Entry<Long, Double> entry : valuesMap.entrySet()) {
                value = entry.getValue();
            }
            for (Long requiredTs : requiredTimestamps) {
                interpolatedValuesMap.put(requiredTs, value);
            }
            return interpolatedValuesMap;
        }
        double[] timestamps = new double[valuesMap.size()];
        double[] metrics = new double[valuesMap.size()];
        int i = 0;
        for (Map.Entry<Long, Double> entry : valuesMap.entrySet()) {
            timestamps[i] = entry.getKey().longValue();
            metrics[i++] = entry.getValue();
        }
        PolynomialSplineFunction function = linearInterpolator.interpolate(timestamps, metrics);
        PolynomialFunction[] splines = function.getPolynomials();
        PolynomialFunction first = splines[0];
        for (Long requiredTs : requiredTimestamps) {
            Double interpolatedValue = null;
            if (PostProcessingUtil.timestampInRange(requiredTs, timestamps[0], timestamps[timestamps.length - 1])) {
                interpolatedValue = function.value((double)requiredTs.longValue());
            } else if (first.getCoefficients() != null && first.getCoefficients().length > 0) {
                Double y1 = first.getCoefficients()[0];
                Double m = first.getCoefficients().length > 1 ? first.getCoefficients()[1] : 0.0;
                interpolatedValue = y1 + m * ((double)requiredTs.longValue() - timestamps[0]);
            }
            if (interpolatedValue == null || !(interpolatedValue >= 0.0)) continue;
            interpolatedValuesMap.put(requiredTs, interpolatedValue);
        }
        return interpolatedValuesMap;
    }

    private static boolean timestampInRange(Long timestamp, double left, double right) {
        return (double)timestamp.longValue() >= left && (double)timestamp.longValue() <= right;
    }
}

