/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.metrics2.sink.timeline;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.KeyStore;
import java.util.concurrent.atomic.AtomicInteger;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.sink.timeline.TimelineMetrics;
import org.apache.hadoop.metrics2.sink.timeline.UnableToConnectException;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.annotate.JsonSerialize;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public abstract class AbstractTimelineMetricsSink {
    public static final String TAGS_FOR_PREFIX_PROPERTY_PREFIX = "tagsForPrefix.";
    public static final String MAX_METRIC_ROW_CACHE_SIZE = "maxRowCacheSize";
    public static final String METRICS_SEND_INTERVAL = "sendInterval";
    public static final String METRICS_POST_TIMEOUT_SECONDS = "timeout";
    public static final String COLLECTOR_PROPERTY = "collector";
    public static final int DEFAULT_POST_TIMEOUT_SECONDS = 10;
    public static final String SKIP_COUNTER_TRANSFROMATION = "skipCounterDerivative";
    public static final String RPC_METRIC_PREFIX = "metric.rpc";
    public static final String RPC_METRIC_NAME_SUFFIX = "suffix";
    public static final String RPC_METRIC_PORT_SUFFIX = "port";
    public static final String WS_V1_TIMELINE_METRICS = "/ws/v1/timeline/metrics";
    public static final String SSL_KEYSTORE_PATH_PROPERTY = "truststore.path";
    public static final String SSL_KEYSTORE_TYPE_PROPERTY = "truststore.type";
    public static final String SSL_KEYSTORE_PASSWORD_PROPERTY = "truststore.password";
    protected static final AtomicInteger failedCollectorConnectionsCounter = new AtomicInteger(0);
    public static int NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS = 100;
    private SSLSocketFactory sslSocketFactory;
    protected final Log LOG = LogFactory.getLog(this.getClass());
    protected static ObjectMapper mapper = new ObjectMapper();

    protected boolean emitMetricsJson(String connectUrl, String jsonData) {
        int timeout = this.getTimeoutSeconds() * 1000;
        HttpURLConnection connection = null;
        try {
            int statusCode;
            if (connectUrl == null) {
                throw new IOException("Unknown URL. Unable to connect to metrics collector.");
            }
            connection = connectUrl.startsWith("https") ? this.getSSLConnection(connectUrl) : this.getConnection(connectUrl);
            connection.setRequestMethod("POST");
            connection.setRequestProperty("Content-Type", "application/json");
            connection.setRequestProperty("Connection", "Keep-Alive");
            connection.setConnectTimeout(timeout);
            connection.setReadTimeout(timeout);
            connection.setDoOutput(true);
            if (jsonData != null) {
                try (OutputStream os = connection.getOutputStream();){
                    os.write(jsonData.getBytes("UTF-8"));
                }
            }
            if ((statusCode = connection.getResponseCode()) != 200) {
                this.LOG.info((Object)("Unable to POST metrics to collector, " + connectUrl + ", " + "statusCode = " + statusCode));
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("Metrics posted to Collector " + connectUrl));
            }
            this.cleanupInputStream(connection.getInputStream());
            failedCollectorConnectionsCounter.set(0);
            return true;
        }
        catch (IOException ioe) {
            StringBuilder errorMessage = new StringBuilder("Unable to connect to collector, " + connectUrl + "\n" + "This exceptions will be ignored for next " + NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS + " times\n");
            try {
                if (connection != null) {
                    errorMessage.append(this.cleanupInputStream(connection.getErrorStream()));
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            if (failedCollectorConnectionsCounter.getAndIncrement() == 0) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)errorMessage, (Throwable)ioe);
                } else {
                    this.LOG.info((Object)errorMessage);
                }
                throw new UnableToConnectException(ioe).setConnectUrl(connectUrl);
            }
            failedCollectorConnectionsCounter.compareAndSet(NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS, 0);
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)String.format("Ignoring %s AMS connection exceptions", NUMBER_OF_SKIPPED_COLLECTOR_EXCEPTIONS));
            }
            return false;
        }
    }

    protected boolean emitMetrics(TimelineMetrics metrics) {
        String connectUrl = this.getCollectorUri();
        String jsonData = null;
        try {
            jsonData = mapper.writeValueAsString((Object)metrics);
        }
        catch (IOException e) {
            this.LOG.error((Object)"Unable to parse metrics", (Throwable)e);
        }
        if (jsonData != null) {
            return this.emitMetricsJson(connectUrl, jsonData);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String cleanupInputStream(InputStream is) throws IOException {
        StringBuilder sb = new StringBuilder();
        if (is != null) {
            try (InputStreamReader isr = new InputStreamReader(is);
                 BufferedReader br = new BufferedReader(isr);){
                String line;
                while ((line = br.readLine()) != null) {
                    if (!this.LOG.isDebugEnabled()) continue;
                    sb.append(line);
                }
            }
            finally {
                is.close();
            }
        }
        return sb.toString();
    }

    protected HttpURLConnection getConnection(String spec) throws IOException {
        return (HttpURLConnection)new URL(spec).openConnection();
    }

    protected HttpsURLConnection getSSLConnection(String spec) throws IOException, IllegalStateException {
        HttpsURLConnection connection = (HttpsURLConnection)new URL(spec).openConnection();
        connection.setSSLSocketFactory(this.sslSocketFactory);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadTruststore(String trustStorePath, String trustStoreType, String trustStorePassword) {
        if (this.sslSocketFactory == null) {
            if (trustStorePath == null || trustStorePassword == null) {
                String msg = String.format("Can't load TrustStore. Truststore path or password is not set.", new Object[0]);
                this.LOG.error((Object)msg);
                throw new IllegalStateException(msg);
            }
            FileInputStream in = null;
            try {
                in = new FileInputStream(new File(trustStorePath));
                KeyStore store = KeyStore.getInstance(trustStoreType == null ? KeyStore.getDefaultType() : trustStoreType);
                store.load(in, trustStorePassword.toCharArray());
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                tmf.init(store);
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, tmf.getTrustManagers(), null);
                this.sslSocketFactory = context.getSocketFactory();
            }
            catch (Exception e) {
                this.LOG.error((Object)"Unable to load TrustStore", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        this.LOG.error((Object)"Unable to load TrustStore", (Throwable)e);
                    }
                }
            }
        }
    }

    protected abstract String getCollectorUri();

    protected abstract int getTimeoutSeconds();

    static {
        JaxbAnnotationIntrospector introspector = new JaxbAnnotationIntrospector();
        mapper.setAnnotationIntrospector((AnnotationIntrospector)introspector);
        mapper.getSerializationConfig().withSerializationInclusion(JsonSerialize.Inclusion.NON_NULL);
    }
}

