/*
 * Decompiled with CFR 0.152.
 */
package webwork.util.editor;

import java.text.DateFormat;
import java.util.Date;
import webwork.action.ActionContext;
import webwork.action.ValidationEditorSupport;
import webwork.util.DateFormatter;
import webwork.util.editor.FastPropertyEditor;
import webwork.util.editor.PropertyEditorException;

public class DateEditor
extends ValidationEditorSupport
implements FastPropertyEditor {
    @Override
    public void setAsText(String txt) {
        this.setValue(this.getAsValue(txt));
    }

    @Override
    public Object getAsValue(String txt) {
        if (txt == null || txt.length() == 0) {
            return null;
        }
        try {
            DateFormatter formatter = new DateFormatter();
            try {
                formatter.setParser(DateFormat.getDateInstance(3, ActionContext.getLocale()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            formatter.setDate(txt);
            return formatter.getDate();
        }
        catch (Exception e) {
            throw new PropertyEditorException("BAD_DATE", txt);
        }
    }

    @Override
    public String getAsText() {
        return this.value == null ? "" : DateEditor.formatDate(this.value);
    }

    @Override
    public String getAsText(Object val) {
        return val == null ? "" : DateEditor.formatDate(val);
    }

    private static String formatDate(Object obj) {
        try {
            DateFormatter formatter = new DateFormatter();
            formatter.setDate((Date)obj);
            try {
                formatter.setFormat(DateFormat.getDateInstance(3, ActionContext.getLocale()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            return formatter.getFormattedDate();
        }
        catch (Exception e) {
            return "";
        }
    }
}

