/*
 * Decompiled with CFR 0.152.
 */
package webwork.config.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import webwork.config.Configuration;
import webwork.config.util.ActionInfo;
import webwork.config.util.ActionInfoImpl;

public class XMLConfigurationReader {
    public static final Log log = LogFactory.getLog(XMLConfigurationReader.class);
    private final Map<String, Object> actionMappings;
    private static final String EXTENSION_PROPERTY = "webwork.action.extension";
    private static final String DOT_ACTION_INFO_SUFFIX = ".actionInfo";
    private static final String DOT_ACTION_SUFFIX = ".action";
    private static final String DOT_ACTION_ROLES_SUFFIX = ".actionRoles";

    public XMLConfigurationReader(Element configurationRootElement) {
        this(configurationRootElement, null);
    }

    public XMLConfigurationReader(Element configurationRootElement, String sourceOfConfig) {
        this.actionMappings = this.getMappingsFromDocument(configurationRootElement, sourceOfConfig);
    }

    public Object getActionMapping(String mappingName) {
        String key = this.replaceExtension(mappingName);
        return this.actionMappings.get(key);
    }

    public Set getActionMappingNames() {
        return this.actionMappings.keySet();
    }

    private Map<String, Object> getMappingsFromDocument(Element element, String sourceOfConfig) {
        HashMap<String, Object> actionMap = new HashMap<String, Object>();
        NodeList actions = element.getElementsByTagName("action");
        int length = actions.getLength();
        for (int i = 0; i < length; ++i) {
            Element actionE = (Element)actions.item(i);
            String actionName = actionE.getAttribute("name");
            String actionAlias = actionE.getAttribute("alias");
            this.buildActionMapping(actionMap, actionE, actionName, actionAlias, sourceOfConfig);
            this.buildCommandMappings(actionMap, actionE, actionName, actionAlias, sourceOfConfig);
            this.buildRolesRequiredMappings(actionMap, actionE, actionName, this.defaultActionAlias(actionAlias, actionName));
        }
        return actionMap;
    }

    private void buildRolesRequiredMappings(Map<String, Object> actionMap, Element actionElement, String actionName, String actionAlias) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Adding roles required for action name: '%s' under alias: '%s", actionName, actionAlias));
        }
        actionMap.put(actionAlias + DOT_ACTION_ROLES_SUFFIX, this.rolesRequiredAttributeFor(actionElement));
        NodeList commands = actionElement.getElementsByTagName("command");
        for (int j = 0; j < commands.getLength(); ++j) {
            String rolesRequiredForCommand;
            Element commandElement = (Element)commands.item(j);
            String commandName = commandElement.getAttribute("name");
            String commandAlias = commandElement.getAttribute("alias");
            if (!"".equals(commandAlias)) {
                rolesRequiredForCommand = this.rolesRequiredAttributeFor(commandElement);
                if (!"".equals(rolesRequiredForCommand)) {
                    actionMap.put(commandAlias + DOT_ACTION_ROLES_SUFFIX, this.rolesRequiredAttributeFor(commandElement));
                    continue;
                }
                actionMap.put(commandAlias + DOT_ACTION_ROLES_SUFFIX, this.rolesRequiredAttributeFor(actionElement));
                continue;
            }
            rolesRequiredForCommand = this.rolesRequiredAttributeFor(commandElement);
            if (!"".equals(rolesRequiredForCommand)) {
                actionMap.put(actionAlias + "!" + commandName + DOT_ACTION_ROLES_SUFFIX, this.rolesRequiredAttributeFor(commandElement));
                continue;
            }
            actionMap.put(actionAlias + "!" + commandName + DOT_ACTION_ROLES_SUFFIX, this.rolesRequiredAttributeFor(actionElement));
        }
    }

    private String defaultActionAlias(String actionAlias, String actionName) {
        if ("".equals(actionAlias)) {
            return actionName;
        }
        return actionAlias;
    }

    private String rolesRequiredAttributeFor(Element actionE) {
        List<Node> attributes = this.findAttributes(actionE);
        for (Node attribute : attributes) {
            if (!attribute.getNodeName().equals("roles-required")) continue;
            return attribute.getNodeValue();
        }
        return "";
    }

    private void buildActionMapping(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias, String sourceOfConfig) {
        if (!"".equals(actionAlias)) {
            String magicActionKey = actionAlias + DOT_ACTION_SUFFIX;
            log.debug((Object)("Adding action alias " + actionAlias + "=" + actionName));
            actionMap.put(magicActionKey, actionName);
        }
        ActionInfoImpl.Builder builder = ActionInfoImpl.builder(actionName, actionAlias).setSource(sourceOfConfig).addAttributes(this.allAttributes(actionE));
        this.buildViewMappings(actionMap, actionE, actionName, actionAlias, builder);
        this.recordActionInfo(actionMap, actionName, actionAlias, builder);
    }

    private void buildViewMappings(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias, ActionInfoImpl.Builder builder) {
        Element view;
        NodeList views = actionE.getElementsByTagName("view");
        for (int j = 0; j < views.getLength() && (view = (Element)views.item(j)).getParentNode().equals(actionE); ++j) {
            NodeList viewMapping = view.getChildNodes();
            StringBuilder mapping = new StringBuilder();
            for (int k = 0; k < viewMapping.getLength(); ++k) {
                Node mappingNode = viewMapping.item(k);
                if (!(mappingNode instanceof Text)) continue;
                mapping.append(mappingNode.getNodeValue());
            }
            String viewName = view.getAttribute("name");
            String actionViewMapping = mapping.toString().trim();
            builder.startView(viewName, actionViewMapping).addAttributes(this.allAttributes(view)).endView();
            String actionViewName = "".equals(actionAlias) ? (!"".equals(actionName) ? actionName + "." + viewName : viewName) : actionAlias + "." + viewName;
            log.debug((Object)("Adding view mapping " + actionViewName + "=" + actionViewMapping));
            actionMap.put(actionViewName, actionViewMapping);
        }
    }

    private void buildCommandMappings(Map<String, Object> actionMap, Element actionE, String actionName, String actionAlias, String sourceOfConfig) {
        NodeList commands = actionE.getElementsByTagName("command");
        for (int j = 0; j < commands.getLength(); ++j) {
            Element commandE = (Element)commands.item(j);
            String commandName = commandE.getAttribute("name");
            String commandAlias = commandE.getAttribute("alias");
            if (!commandAlias.equals("")) {
                String magicCommandAliasKey = commandAlias + DOT_ACTION_SUFFIX;
                log.debug((Object)("Adding command alias " + commandAlias + "=" + actionName + "!" + commandName));
                actionMap.put(magicCommandAliasKey, actionName + "!" + commandName);
            }
            ActionInfoImpl.Builder builder = ActionInfoImpl.builder(commandName, commandAlias).setSource(sourceOfConfig).addAttributes(this.allAttributes(commandE));
            NodeList views = commandE.getElementsByTagName("view");
            for (int k = 0; k < views.getLength(); ++k) {
                Element view = (Element)views.item(k);
                NodeList viewMapping = view.getChildNodes();
                StringBuilder mapping = new StringBuilder();
                for (int l = 0; l < viewMapping.getLength(); ++l) {
                    Node mappingNode = viewMapping.item(l);
                    if (!(mappingNode instanceof Text)) continue;
                    mapping.append(mappingNode.getNodeValue());
                }
                String viewName = view.getAttribute("name");
                String commandViewMapping = mapping.toString().trim();
                builder.startView(viewName, commandViewMapping).addAttributes(this.allAttributes(view)).endView();
                String commandViewName = commandAlias.equals("") ? (actionAlias.equals("") ? actionName + "!" + commandName + "." + viewName : actionAlias + "!" + commandName + "." + viewName) : commandAlias + "." + viewName;
                log.debug((Object)("Adding command view mapping " + commandViewName + "=" + commandViewMapping));
                actionMap.put(commandViewName, commandViewMapping);
            }
            this.recordActionInfo(actionMap, commandName, commandAlias, builder);
        }
    }

    private void recordActionInfo(Map<String, Object> actionMap, String actionName, String actionAlias, ActionInfoImpl.Builder builder) {
        String actionPrefix = actionAlias;
        if ("".equals(actionAlias)) {
            actionPrefix = actionName;
        }
        String magicActionInfoKey = actionPrefix + DOT_ACTION_INFO_SUFFIX;
        ActionInfo existing = (ActionInfo)actionMap.get(magicActionInfoKey);
        ActionInfo actionInfo = builder.merge(existing).build();
        actionMap.put(magicActionInfoKey, actionInfo);
    }

    private Map<String, String> allAttributes(Element element) {
        List<Node> attributes = this.findAttributes(element);
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (Node attribute : attributes) {
            attributeMap.put(attribute.getNodeName(), attribute.getNodeValue());
        }
        return attributeMap;
    }

    private List<Node> findAttributes(Element actionE) {
        ArrayList<Node> attributes = new ArrayList<Node>();
        NamedNodeMap nodeList = actionE.getAttributes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node child = nodeList.item(i);
            if (child.getNodeType() != 2) continue;
            attributes.add(child);
        }
        return attributes;
    }

    private String replaceExtension(String actionName) {
        if (EXTENSION_PROPERTY.equals(actionName)) {
            return actionName;
        }
        String ext = "." + Configuration.get(EXTENSION_PROPERTY);
        if (actionName != null && !DOT_ACTION_SUFFIX.equals(ext)) {
            int idx;
            if (actionName.endsWith(ext)) {
                actionName = actionName.substring(0, actionName.lastIndexOf(ext)) + DOT_ACTION_SUFFIX;
            }
            if ((idx = actionName.indexOf(ext + "?")) > 0) {
                actionName = actionName.substring(0, idx) + ".action?" + actionName.substring(idx + ext.length() + 1);
            }
        }
        return actionName;
    }
}

