/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.apache.commons.logging.LogFactory;
import webwork.config.AbstractConfiguration;
import webwork.config.ConfigurationInterface;
import webwork.config.DelegatingConfiguration;
import webwork.config.PropertiesConfiguration;
import webwork.config.XMLActionConfiguration;
import webwork.util.ClassLoaderUtils;

public class DefaultConfiguration
extends AbstractConfiguration {
    ConfigurationInterface config;

    public DefaultConfiguration() {
        String name;
        ArrayList<ConfigurationInterface> configList = new ArrayList<ConfigurationInterface>();
        try {
            configList.add(new PropertiesConfiguration("webwork"));
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).warn((Object)"Could not find webwork.properties");
        }
        try {
            configList.add(new PropertiesConfiguration("webwork/default"));
        }
        catch (Exception e) {
            LogFactory.getLog(this.getClass()).error((Object)"Could not find webwork/default.properties", (Throwable)e);
        }
        this.config = new DelegatingConfiguration(configList);
        ArrayList<ConfigurationInterface> list = new ArrayList<ConfigurationInterface>();
        StringTokenizer configFiles = new StringTokenizer((String)this.config.getImpl("webwork.configuration.properties"), ",");
        while (configFiles.hasMoreTokens()) {
            name = configFiles.nextToken();
            try {
                list.add(new PropertiesConfiguration(name));
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).warn((Object)("Could not find " + name + ".properties. Skipping"));
            }
        }
        this.config = new DelegatingConfiguration(list);
        configFiles = new StringTokenizer((String)this.config.getImpl("webwork.configuration.xml"), ",");
        while (configFiles.hasMoreTokens()) {
            name = configFiles.nextToken();
            try {
                list.add(new XMLActionConfiguration(name));
            }
            catch (IllegalArgumentException e) {
                LogFactory.getLog(this.getClass()).warn((Object)("Skipping XML action configuration for " + name + ".xml"));
            }
            catch (Exception e) {
                LogFactory.getLog(this.getClass()).error((Object)"Could not create XML action configuration", (Throwable)e);
            }
        }
        ArrayList configurationObjects = new ArrayList();
        try {
            configFiles = new StringTokenizer((String)this.config.getImpl("webwork.configuration.class"), ",");
            while (configFiles.hasMoreTokens()) {
                String name2 = configFiles.nextToken();
                try {
                    Class configurationClass = ClassLoaderUtils.loadClass(name2, ConfigurationInterface.class);
                    if (configurationClass == null) {
                        LogFactory.getLog(this.getClass()).warn((Object)("Could not find configuration class '" + configurationClass + "' in classpath"));
                        continue;
                    }
                    if (!ConfigurationInterface.class.isAssignableFrom(configurationClass)) {
                        LogFactory.getLog(this.getClass()).warn((Object)("ConfigurationInterface class '" + configurationClass + "' is not of type 'ConfigurationInterface'"));
                        continue;
                    }
                    configurationObjects.add(configurationClass.newInstance());
                }
                catch (Exception e) {
                    LogFactory.getLog(this.getClass()).error((Object)("Skipping configuration for class '" + name2 + "'"), (Throwable)e);
                }
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        list.addAll(0, configurationObjects);
        this.config = new DelegatingConfiguration(list);
    }

    @Override
    public Object getImpl(String aName) throws IllegalArgumentException {
        return this.config.getImpl(aName);
    }

    @Override
    public void setImpl(String aName, Object aValue) throws IllegalArgumentException, UnsupportedOperationException {
        this.config.setImpl(aName, aValue);
    }

    @Override
    public Iterator listImpl() {
        return this.config.listImpl();
    }
}

