/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.info;

import com.tencent.tinker.build.patch.Configuration;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;

public class InfoWriter {
    protected final Configuration config;
    protected final String infoPath;
    protected final File infoFile;
    protected Writer infoWrite;

    public InfoWriter(Configuration config, String infoPath) throws IOException {
        this.config = config;
        this.infoPath = infoPath;
        if (infoPath != null) {
            this.infoFile = new File(infoPath);
            if (!this.infoFile.getParentFile().exists()) {
                this.infoFile.getParentFile().mkdirs();
            }
        } else {
            this.infoFile = null;
        }
    }

    public Configuration getConfig() {
        return this.config;
    }

    public void writeLinesToInfoFile(List<String> lines) throws IOException {
        for (String line : lines) {
            this.writeLineToInfoFile(line);
        }
    }

    public void writeLineToInfoFile(String line) {
        if (this.infoPath == null || line == null || line.length() == 0) {
            return;
        }
        try {
            this.checkWriter();
            this.infoWrite.write(line);
            this.infoWrite.write("\n");
            this.infoWrite.flush();
        }
        catch (Exception e) {
            throw new RuntimeException("write info file error, infoPath:" + this.infoPath + " content:" + line, e);
        }
    }

    private void checkWriter() throws IOException {
        if (this.infoWrite == null) {
            this.infoWrite = new BufferedWriter(new FileWriter(this.infoFile, false));
        }
    }

    public void close() {
        try {
            if (this.infoWrite != null) {
                this.infoWrite.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

