/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.util;

import com.tencent.tinker.android.dex.Dex;
import java.util.HashMap;
import java.util.Map;

public final class OffsetToIndexConverter {
    private final Map<Integer, Integer> typeListOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> classDataOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> encodedArrayOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> annotationOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> annotationSetOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> annotationSetRefListOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> annotationsDirectoryOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> codeOffsetToIndexMap = new HashMap<Integer, Integer>();
    private final Map<Integer, Integer> debugInfoItemOffsetToIndexMap = new HashMap<Integer, Integer>();

    public OffsetToIndexConverter(Dex dex) {
        int i;
        if (dex == null) {
            throw new IllegalArgumentException("dex is null.");
        }
        if (dex.getTableOfContents().typeLists.exists()) {
            Dex.Section typeListSec = dex.openSection(dex.getTableOfContents().typeLists);
            int typeListCount = dex.getTableOfContents().typeLists.size;
            for (i = 0; i < typeListCount; ++i) {
                this.typeListOffsetToIndexMap.put(typeListSec.readTypeList().off, i);
            }
        }
        if (dex.getTableOfContents().classDatas.exists()) {
            Dex.Section classDataSec = dex.openSection(dex.getTableOfContents().classDatas);
            int classDataCount = dex.getTableOfContents().classDatas.size;
            for (i = 0; i < classDataCount; ++i) {
                this.classDataOffsetToIndexMap.put(classDataSec.readClassData().off, i);
            }
        }
        if (dex.getTableOfContents().encodedArrays.exists()) {
            Dex.Section encodedArraySec = dex.openSection(dex.getTableOfContents().encodedArrays);
            int encodedArrayCount = dex.getTableOfContents().encodedArrays.size;
            for (i = 0; i < encodedArrayCount; ++i) {
                this.encodedArrayOffsetToIndexMap.put(encodedArraySec.readEncodedArray().off, i);
            }
        }
        if (dex.getTableOfContents().annotations.exists()) {
            Dex.Section annotationSec = dex.openSection(dex.getTableOfContents().annotations);
            int annotationCount = dex.getTableOfContents().annotations.size;
            for (i = 0; i < annotationCount; ++i) {
                this.annotationOffsetToIndexMap.put(annotationSec.readAnnotation().off, i);
            }
        }
        if (dex.getTableOfContents().annotationSets.exists()) {
            Dex.Section annotationSetSec = dex.openSection(dex.getTableOfContents().annotationSets);
            int annotationSetCount = dex.getTableOfContents().annotationSets.size;
            for (i = 0; i < annotationSetCount; ++i) {
                this.annotationSetOffsetToIndexMap.put(annotationSetSec.readAnnotationSet().off, i);
            }
        }
        if (dex.getTableOfContents().annotationSetRefLists.exists()) {
            Dex.Section annotationSetRefListSec = dex.openSection(dex.getTableOfContents().annotationSetRefLists);
            int annotationSetRefListCount = dex.getTableOfContents().annotationSetRefLists.size;
            for (i = 0; i < annotationSetRefListCount; ++i) {
                this.annotationSetRefListOffsetToIndexMap.put(annotationSetRefListSec.readAnnotationSetRefList().off, i);
            }
        }
        if (dex.getTableOfContents().annotationsDirectories.exists()) {
            Dex.Section annotationsDirectorySec = dex.openSection(dex.getTableOfContents().annotationsDirectories);
            int annotationsDirectoryCount = dex.getTableOfContents().annotationsDirectories.size;
            for (i = 0; i < annotationsDirectoryCount; ++i) {
                this.annotationsDirectoryOffsetToIndexMap.put(annotationsDirectorySec.readAnnotationsDirectory().off, i);
            }
        }
        if (dex.getTableOfContents().codes.exists()) {
            Dex.Section codeSec = dex.openSection(dex.getTableOfContents().codes);
            int codeCount = dex.getTableOfContents().codes.size;
            for (i = 0; i < codeCount; ++i) {
                this.codeOffsetToIndexMap.put(codeSec.readCode().off, i);
            }
        }
        if (dex.getTableOfContents().debugInfos.exists()) {
            Dex.Section debugInfoItemSec = dex.openSection(dex.getTableOfContents().debugInfos);
            int debugInfoItemCount = dex.getTableOfContents().debugInfos.size;
            for (i = 0; i < debugInfoItemCount; ++i) {
                this.debugInfoItemOffsetToIndexMap.put(debugInfoItemSec.readDebugInfoItem().off, i);
            }
        }
    }

    public int getTypeListIndexByOffset(int offset) {
        if (this.typeListOffsetToIndexMap.containsKey(offset)) {
            return this.typeListOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getClassDataIndexByOffset(int offset) {
        if (this.classDataOffsetToIndexMap.containsKey(offset)) {
            return this.classDataOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getEncodedArrayIndexByOffset(int offset) {
        if (this.encodedArrayOffsetToIndexMap.containsKey(offset)) {
            return this.encodedArrayOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getAnnotationIndexByOffset(int offset) {
        if (this.annotationOffsetToIndexMap.containsKey(offset)) {
            return this.annotationOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getAnnotationSetIndexByOffset(int offset) {
        if (this.annotationSetOffsetToIndexMap.containsKey(offset)) {
            return this.annotationSetOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getAnnotationSetRefListIndexByOffset(int offset) {
        if (this.annotationSetRefListOffsetToIndexMap.containsKey(offset)) {
            return this.annotationSetRefListOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getAnnotationsDirectoryIndexByOffset(int offset) {
        if (this.annotationsDirectoryOffsetToIndexMap.containsKey(offset)) {
            return this.annotationsDirectoryOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getCodeIndexByOffset(int offset) {
        if (this.codeOffsetToIndexMap.containsKey(offset)) {
            return this.codeOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }

    public int getDebugInfoItemIndexByOffset(int offset) {
        if (this.debugInfoItemOffsetToIndexMap.containsKey(offset)) {
            return this.debugInfoItemOffsetToIndexMap.get(offset);
        }
        throw new IllegalArgumentException("cannot find corresponding index of offset: " + offset);
    }
}

