/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.dexpatcher.algorithms.diff;

import com.tencent.tinker.android.dex.ClassDef;
import com.tencent.tinker.android.dex.Dex;
import com.tencent.tinker.android.dex.TableOfContents;
import com.tencent.tinker.android.dex.io.DexDataBuffer;
import com.tencent.tinker.android.dx.util.IndexMap;
import com.tencent.tinker.build.dexpatcher.algorithms.diff.DexSectionDiffAlgorithm;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class ClassDefSectionDiffAlgorithm
extends DexSectionDiffAlgorithm<ClassDef> {
    private Set<Integer> typeIdOfClassDefToRemoveSet = new HashSet<Integer>();

    public ClassDefSectionDiffAlgorithm(Dex oldDex, Dex newDex, IndexMap oldToNewIndexMap, IndexMap oldToPatchedIndexMap, IndexMap newToPatchedIndexMap, IndexMap selfIndexMapForSkip) {
        super(oldDex, newDex, oldToNewIndexMap, oldToPatchedIndexMap, newToPatchedIndexMap, selfIndexMapForSkip);
    }

    public void setTypeIdOfClassDefsToRemove(Collection<Integer> typeIdOfClassDefsToRemove) {
        this.typeIdOfClassDefToRemoveSet.clear();
        this.typeIdOfClassDefToRemoveSet.addAll(typeIdOfClassDefsToRemove);
    }

    public void clearTypeIdOfClassDefsToRemove() {
        this.typeIdOfClassDefToRemoveSet.clear();
    }

    @Override
    protected TableOfContents.Section getTocSection(Dex dex) {
        return dex.getTableOfContents().classDefs;
    }

    @Override
    protected ClassDef nextItem(DexDataBuffer section) {
        return section.readClassDef();
    }

    @Override
    protected boolean shouldSkipInNewDex(ClassDef newItem) {
        return this.typeIdOfClassDefToRemoveSet.contains(newItem.typeIndex);
    }

    @Override
    protected int getItemSize(ClassDef item) {
        return 32;
    }

    @Override
    protected ClassDef adjustItem(IndexMap indexMap, ClassDef item) {
        return indexMap.adjust(item);
    }
}

