/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.build.auxiliaryclass;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;

public final class AuxiliaryClassGenerator {
    private static final String JAVA_IDENTIFIER_PATTERN_STR = "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)";
    private static final String JAVA_FULL_CLASSNAME_PATTERN_STR = String.format("(%s(?:\\.%s)*)", "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)", "(?:\\p{javaJavaIdentifierStart}\\p{javaJavaIdentifierPart}*)");
    private static final Pattern JAVA_FULL_CLASSNAME_PATTERN = Pattern.compile(JAVA_FULL_CLASSNAME_PATTERN_STR);

    public static void generateAuxiliaryClass(File dirOutput, String dotClassName) throws IOException {
        if (!JAVA_FULL_CLASSNAME_PATTERN.matcher(dotClassName).matches()) {
            throw new IllegalArgumentException("Bad dotClassName: " + dotClassName);
        }
        if (AuxiliaryClassGenerator.isPrimitiveClass(dotClassName)) {
            throw new UnsupportedOperationException("Cannot generate primitive class.");
        }
        if (AuxiliaryClassGenerator.isArrayClass(dotClassName)) {
            throw new UnsupportedOperationException("Cannot generate array class.");
        }
        int lastDotSepPos = dotClassName.lastIndexOf(46);
        String classPkgPart = lastDotSepPos >= 0 ? dotClassName.substring(0, lastDotSepPos) : "";
        String classNamePart = dotClassName.substring(lastDotSepPos + 1);
        File realDirOutput = new File(dirOutput, classPkgPart.replace('.', '/'));
        if (!realDirOutput.exists()) {
            realDirOutput.mkdirs();
        }
        File fileOut = new File(realDirOutput, classNamePart + ".class");
        AuxiliaryClassGenerator.generateClass(dotClassName, fileOut);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateClass(String dotClassName, File fileOut) throws IOException {
        String classDesc = dotClassName.replace('.', '/');
        ClassWriter cw = new ClassWriter(0);
        cw.visit(51, 33, classDesc, null, "java/lang/Object", null);
        cw.visitSource(fileOut.getName(), null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V", false);
        mv.visitInsn(177);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        cw.visitEnd();
        byte[] classBytes = cw.toByteArray();
        OutputStream os = null;
        try {
            os = new BufferedOutputStream(new FileOutputStream(fileOut));
            os.write(classBytes);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static boolean isPrimitiveClass(String className) {
        try {
            return Class.forName(className).isPrimitive();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private static boolean isArrayClass(String className) {
        try {
            return Class.forName(className).isArray();
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }
}

