/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ShareSecurityCheck {
    private static final String TAG = "ShareSecurityCheck";
    private static PublicKey mPublicKey = null;
    private final Context mContext;
    private final HashMap<String, String> metaContentMap;
    private HashMap<String, String> packageProperties;

    public ShareSecurityCheck(Context context) {
        this.mContext = context;
        this.metaContentMap = new HashMap();
        if (mPublicKey == null) {
            this.init(this.mContext);
        }
    }

    public HashMap<String, String> getMetaContentMap() {
        return this.metaContentMap;
    }

    public String getTinkerID() {
        if (this.packageProperties != null) {
            String tinkerId = this.packageProperties.get("TINKER_ID");
            return tinkerId;
        }
        return null;
    }

    public String getNewTinkerID() {
        if (this.packageProperties != null) {
            String tinkerId = this.packageProperties.get("NEW_TINKER_ID");
            return tinkerId;
        }
        return null;
    }

    public HashMap<String, String> getPackagePropertiesIfPresent() {
        String[] lines;
        if (this.packageProperties != null) {
            return this.packageProperties;
        }
        String property = this.metaContentMap.get("assets/package_meta.txt");
        if (property == null) {
            return null;
        }
        for (String line : lines = property.split("\n")) {
            String[] kv;
            if (line == null || line.length() <= 0 || line.startsWith("#") || (kv = line.split("=", 2)) == null || kv.length < 2) continue;
            if (this.packageProperties == null) {
                this.packageProperties = new HashMap();
            }
            this.packageProperties.put(kv[0].trim(), kv[1].trim());
        }
        return this.packageProperties;
    }

    public boolean verifyPatchMetaSignature(File path) {
        if (path == null || !path.isFile() || !path.exists() || path.length() == 0L) {
            return false;
        }
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(path);
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                String name;
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry == null || (name = jarEntry.getName()).startsWith("META-INF/") || !name.endsWith("meta.txt")) continue;
                this.metaContentMap.put(name, SharePatchFileUtil.loadDigestes(jarFile, jarEntry));
                Certificate[] certs = jarEntry.getCertificates();
                if (certs == null) {
                    boolean bl = false;
                    return bl;
                }
                if (this.check(path, certs)) continue;
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            throw new TinkerRuntimeException(String.format("ShareSecurityCheck file %s, size %d verifyPatchMetaSignature fail", path.getAbsolutePath(), path.length()), e);
        }
        finally {
            try {
                if (jarFile != null) {
                    jarFile.close();
                }
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)path.getAbsolutePath(), (Throwable)e);
            }
        }
        return true;
    }

    private boolean check(File path, Certificate[] certs) {
        if (certs.length > 0) {
            for (int i = certs.length - 1; i >= 0; --i) {
                try {
                    certs[i].verify(mPublicKey);
                    return true;
                }
                catch (Exception e) {
                    Log.e((String)TAG, (String)path.getAbsolutePath(), (Throwable)e);
                    continue;
                }
            }
        }
        return false;
    }

    @SuppressLint(value={"PackageManagerGetSignatures"})
    private void init(Context context) {
        ByteArrayInputStream stream = null;
        try {
            PackageManager pm = context.getPackageManager();
            String packageName = context.getPackageName();
            PackageInfo packageInfo = pm.getPackageInfo(packageName, 64);
            CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
            stream = new ByteArrayInputStream(packageInfo.signatures[0].toByteArray());
            X509Certificate cert = (X509Certificate)certFactory.generateCertificate(stream);
            mPublicKey = cert.getPublicKey();
        }
        catch (Exception e) {
            try {
                throw new TinkerRuntimeException("ShareSecurityCheck init public key fail", e);
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeQuietly(stream);
                throw throwable;
            }
        }
        SharePatchFileUtil.closeQuietly(stream);
    }
}

