/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.util.Log;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareFileLockHelper;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class SharePatchInfo {
    public static final int MAX_EXTRACT_ATTEMPTS = 2;
    public static final String OLD_VERSION = "old";
    public static final String NEW_VERSION = "new";
    private static final String TAG = "PatchInfo";
    public String oldVersion;
    public String newVersion;

    public SharePatchInfo(String oldVer, String newVew) {
        this.oldVersion = oldVer;
        this.newVersion = newVew;
    }

    public static SharePatchInfo readAndCheckPropertyWithLock(File pathInfoFile, File lockFile) {
        SharePatchInfo patchInfo;
        File lockParentFile = lockFile.getParentFile();
        if (!lockParentFile.exists()) {
            lockParentFile.mkdirs();
        }
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            patchInfo = SharePatchInfo.readAndCheckProperty(pathInfoFile);
        }
        catch (Exception e) {
            throw new TinkerRuntimeException("readAndCheckPropertyWithLock fail", e);
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.close();
                }
            }
            catch (IOException e) {
                Log.i((String)TAG, (String)"releaseInfoLock error", (Throwable)e);
            }
        }
        return patchInfo;
    }

    public static boolean rewritePatchInfoFileWithLock(File pathInfoFile, SharePatchInfo info, File lockFile) {
        boolean rewriteSuccess;
        File lockParentFile = lockFile.getParentFile();
        if (!lockParentFile.exists()) {
            lockParentFile.mkdirs();
        }
        ShareFileLockHelper fileLock = null;
        try {
            fileLock = ShareFileLockHelper.getFileLock(lockFile);
            rewriteSuccess = SharePatchInfo.rewritePatchInfoFile(pathInfoFile, info);
        }
        catch (Exception e) {
            throw new TinkerRuntimeException("rewritePatchInfoFileWithLock fail", e);
        }
        finally {
            try {
                if (fileLock != null) {
                    fileLock.close();
                }
            }
            catch (IOException e) {
                Log.i((String)TAG, (String)"releaseInfoLock error", (Throwable)e);
            }
        }
        return rewriteSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SharePatchInfo readAndCheckProperty(File pathInfoFile) {
        boolean isReadPatchSuccessful = false;
        int numAttempts = 0;
        String oldVer = null;
        String newVer = null;
        while (numAttempts < 2 && !isReadPatchSuccessful) {
            ++numAttempts;
            Properties properties = new Properties();
            FileInputStream inputStream = null;
            try {
                inputStream = new FileInputStream(pathInfoFile);
                properties.load(inputStream);
                oldVer = properties.getProperty(OLD_VERSION);
                newVer = properties.getProperty(NEW_VERSION);
            }
            catch (IOException e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(inputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(inputStream);
            }
            SharePatchFileUtil.closeQuietly(inputStream);
            if (oldVer == null || newVer == null) continue;
            if (!oldVer.equals("") && !SharePatchFileUtil.checkIfMd5Valid(oldVer) || !SharePatchFileUtil.checkIfMd5Valid(newVer)) {
                Log.w((String)TAG, (String)("path info file  corrupted:" + pathInfoFile.getAbsolutePath()));
                continue;
            }
            isReadPatchSuccessful = true;
        }
        if (isReadPatchSuccessful) {
            return new SharePatchInfo(oldVer, newVer);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean rewritePatchInfoFile(File pathInfoFile, SharePatchInfo info) {
        if (pathInfoFile == null || info == null) {
            return false;
        }
        Log.i((String)TAG, (String)("rewritePatchInfoFile file path:" + pathInfoFile.getAbsolutePath() + " , oldVer:" + info.oldVersion + ", newVer:" + info.newVersion));
        boolean isWritePatchSuccessful = false;
        int numAttempts = 0;
        File parentFile = pathInfoFile.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
        while (numAttempts < 2 && !isWritePatchSuccessful) {
            SharePatchInfo tempInfo;
            ++numAttempts;
            Properties newProperties = new Properties();
            newProperties.put(OLD_VERSION, info.oldVersion);
            newProperties.put(NEW_VERSION, info.newVersion);
            FileOutputStream outputStream = null;
            try {
                outputStream = new FileOutputStream(pathInfoFile, false);
                String comment = "from old version:" + info.oldVersion + " to new version:" + info.newVersion;
                newProperties.store(outputStream, comment);
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeQuietly(outputStream);
                    throw throwable;
                }
                SharePatchFileUtil.closeQuietly(outputStream);
            }
            SharePatchFileUtil.closeQuietly(outputStream);
            if (isWritePatchSuccessful = (tempInfo = SharePatchInfo.readAndCheckProperty(pathInfoFile)) != null && tempInfo.oldVersion.equals(info.oldVersion) && tempInfo.newVersion.equals(info.newVersion)) continue;
            pathInfoFile.delete();
        }
        return isWritePatchSuccessful;
    }
}

