/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.shareutil;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.util.Log;
import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class SharePatchFileUtil {
    private static final String TAG = "Tinker.PatchFileUtil";

    public static File getPatchDirectory(Context context) {
        ApplicationInfo applicationInfo = context.getApplicationInfo();
        if (applicationInfo == null) {
            return null;
        }
        return new File(applicationInfo.dataDir, "tinker");
    }

    public static File getPatchInfoFile(String patchDirectory) {
        return new File(patchDirectory + "/" + "patch.info");
    }

    public static File getPatchInfoLockFile(String patchDirectory) {
        return new File(patchDirectory + "/" + "info.lock");
    }

    public static String getPatchVersionDirectory(String version) {
        if (version == null || version.length() != 32) {
            return null;
        }
        return "patch-" + version.substring(0, 8);
    }

    public static String getPatchVersionFile(String version) {
        if (version == null || version.length() != 32) {
            return null;
        }
        return SharePatchFileUtil.getPatchVersionDirectory(version) + ".apk";
    }

    public static boolean checkIfMd5Valid(String object) {
        return object != null && object.length() == 32;
    }

    public static final boolean fileExists(String filePath) {
        if (filePath == null) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static long getFileOrDirectorySize(File directory) {
        if (directory == null || !directory.exists()) {
            return 0L;
        }
        if (directory.isFile()) {
            return directory.length();
        }
        long totalSize = 0L;
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (file.isDirectory()) {
                    totalSize += SharePatchFileUtil.getFileOrDirectorySize(file);
                    continue;
                }
                totalSize += file.length();
            }
        }
        return totalSize;
    }

    public static final boolean safeDeleteFile(File file) {
        if (file == null) {
            return true;
        }
        Log.i((String)TAG, (String)("safeDeleteFile, try to delete path: " + file.getPath()));
        if (file.exists()) {
            boolean deleted = file.delete();
            if (!deleted) {
                Log.e((String)TAG, (String)("Failed to delete file, try to delete when exit. path: " + file.getPath()));
                file.deleteOnExit();
            }
            return deleted;
        }
        return true;
    }

    public static final boolean deleteDir(String dir) {
        if (dir == null) {
            return false;
        }
        return SharePatchFileUtil.deleteDir(new File(dir));
    }

    public static final boolean deleteDir(File file) {
        File[] files;
        if (file == null || !file.exists()) {
            return false;
        }
        if (file.isFile()) {
            SharePatchFileUtil.safeDeleteFile(file);
        } else if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (File subFile : files) {
                SharePatchFileUtil.deleteDir(subFile);
            }
            SharePatchFileUtil.safeDeleteFile(file);
        }
        return true;
    }

    public static boolean verifyFileMd5(File file, String md5) {
        if (md5 == null) {
            return false;
        }
        String fileMd5 = SharePatchFileUtil.getMD5(file);
        if (fileMd5 == null) {
            return false;
        }
        return md5.equals(fileMd5);
    }

    public static boolean isRawDexFile(String fileName) {
        if (fileName == null) {
            return false;
        }
        return fileName.endsWith(".dex");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean verifyDexFileMd5(File file, String md5) {
        ZipEntry classesDex;
        ZipFile dexJar;
        String fileMd5;
        block7: {
            if (file == null || md5 == null) {
                return false;
            }
            if (SharePatchFileUtil.isRawDexFile(file.getName())) {
                fileMd5 = SharePatchFileUtil.getMD5(file);
                return md5.equals(fileMd5);
            }
            dexJar = null;
            dexJar = new ZipFile(file);
            classesDex = dexJar.getEntry("classes.dex");
            if (null != classesDex) break block7;
            boolean bl = false;
            SharePatchFileUtil.closeZip(dexJar);
            return bl;
        }
        try {
            fileMd5 = SharePatchFileUtil.getMD5(dexJar.getInputStream(classesDex));
        }
        catch (IOException e) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                SharePatchFileUtil.closeZip(dexJar);
                throw throwable;
            }
            SharePatchFileUtil.closeZip(dexJar);
            return bl;
        }
        SharePatchFileUtil.closeZip(dexJar);
        return md5.equals(fileMd5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFileUsingStream(File source, File dest) throws IOException {
        FileInputStream is = null;
        FileOutputStream os = null;
        File parent = dest.getParentFile();
        if (parent != null && !parent.exists()) {
            parent.mkdirs();
        }
        try {
            int length;
            is = new FileInputStream(source);
            os = new FileOutputStream(dest, false);
            byte[] buffer = new byte[16384];
            while ((length = is.read(buffer)) > 0) {
                os.write(buffer, 0, length);
            }
        }
        catch (Throwable throwable) {
            SharePatchFileUtil.closeQuietly(is);
            SharePatchFileUtil.closeQuietly(os);
            throw throwable;
        }
        SharePatchFileUtil.closeQuietly(is);
        SharePatchFileUtil.closeQuietly(os);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadDigestes(JarFile jarFile, JarEntry je) throws Exception {
        BufferedInputStream bis = null;
        StringBuilder sb = new StringBuilder();
        try {
            int readBytes;
            InputStream is = jarFile.getInputStream(je);
            byte[] bytes = new byte[16384];
            bis = new BufferedInputStream(is);
            while ((readBytes = ((InputStream)bis).read(bytes)) > 0) {
                sb.append(new String(bytes, 0, readBytes));
            }
        }
        catch (Throwable throwable) {
            SharePatchFileUtil.closeQuietly(bis);
            throw throwable;
        }
        SharePatchFileUtil.closeQuietly(bis);
        return sb.toString();
    }

    public static final String getMD5(InputStream is) {
        if (is == null) {
            return null;
        }
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(is);
            MessageDigest md = MessageDigest.getInstance("MD5");
            StringBuilder md5Str = new StringBuilder(32);
            byte[] buf = new byte[102400];
            while ((readCount = bis.read(buf)) != -1) {
                md.update(buf, 0, readCount);
            }
            byte[] hashValue = md.digest();
            for (int i = 0; i < hashValue.length; ++i) {
                md5Str.append(Integer.toString((hashValue[i] & 0xFF) + 256, 16).substring(1));
            }
            return md5Str.toString();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getMD5(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            String md5 = SharePatchFileUtil.getMD5(fin);
            fin.close();
            String string = md5;
            return string;
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            try {
                if (fin != null) {
                    fin.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public static String optimizedPathFor(File path, File optimizedDirectory) {
        String fileName = path.getName();
        if (!fileName.endsWith(".dex")) {
            int lastDot = fileName.lastIndexOf(".");
            if (lastDot < 0) {
                fileName = fileName + ".dex";
            } else {
                StringBuilder sb = new StringBuilder(lastDot + 4);
                sb.append(fileName, 0, lastDot);
                sb.append(".dex");
                fileName = sb.toString();
            }
        }
        File result = new File(optimizedDirectory, fileName);
        return result.getPath();
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)e);
        }
    }

    public static void closeZip(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Failed to close resource", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static boolean checkResourceArscMd5(File resOutput, String destMd5) {
        ZipFile resourceZip;
        block10: {
            InputStream inputStream;
            block9: {
                ZipEntry arscEntry;
                block8: {
                    resourceZip = null;
                    resourceZip = new ZipFile(resOutput);
                    arscEntry = resourceZip.getEntry("resources.arsc");
                    if (arscEntry != null) break block8;
                    Log.i((String)TAG, (String)"checkResourceArscMd5 resources.arsc not found");
                    boolean bl = false;
                    SharePatchFileUtil.closeZip(resourceZip);
                    return bl;
                }
                inputStream = null;
                inputStream = resourceZip.getInputStream(arscEntry);
                String md5 = SharePatchFileUtil.getMD5(inputStream);
                if (md5 == null || !md5.equals(destMd5)) break block9;
                boolean bl = true;
                SharePatchFileUtil.closeQuietly(inputStream);
                SharePatchFileUtil.closeZip(resourceZip);
                return bl;
            }
            try {
                SharePatchFileUtil.closeQuietly(inputStream);
                break block10;
                {
                    catch (Throwable throwable) {
                        SharePatchFileUtil.closeQuietly(inputStream);
                        throw throwable;
                    }
                }
            }
            catch (Throwable e) {
                try {
                    Log.i((String)TAG, (String)("checkResourceArscMd5 throwable:" + e.getMessage()));
                }
                catch (Throwable throwable) {
                    SharePatchFileUtil.closeZip(resourceZip);
                    throw throwable;
                }
                SharePatchFileUtil.closeZip(resourceZip);
            }
        }
        SharePatchFileUtil.closeZip(resourceZip);
        return false;
    }

    public static void ensureFileDirectory(File file) {
        if (file == null) {
            return;
        }
        File parentFile = file.getParentFile();
        if (!parentFile.exists()) {
            parentFile.mkdirs();
        }
    }
}

