/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader.app;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.AssetManager;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.os.SystemClock;
import com.tencent.tinker.loader.TinkerLoader;
import com.tencent.tinker.loader.TinkerRuntimeException;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.ShareReflectUtil;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

public abstract class TinkerApplication
extends Application {
    private static final int TINKER_DISABLE = 0;
    private static final String INTENT_PATCH_EXCEPTION = "intent_patch_exception";
    private static final String TINKER_LOADER_METHOD = "tryLoad";
    private final int tinkerFlags;
    private final boolean tinkerLoadVerifyFlag;
    private final String delegateClassName;
    private final String loaderClassName;
    private boolean useSafeMode;
    private Intent tinkerResultIntent;
    private Object delegate = null;
    private Resources[] resources = new Resources[1];
    private ClassLoader[] classLoader = new ClassLoader[1];
    private AssetManager[] assetManager = new AssetManager[1];
    private long applicationStartElapsedTime;
    private long applicationStartMillisTime;

    protected TinkerApplication(int tinkerFlags) {
        this(tinkerFlags, "com.tencent.tinker.loader.app.DefaultApplicationLike", TinkerLoader.class.getName(), false);
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName, String loaderClassName, boolean tinkerLoadVerifyFlag) {
        this.tinkerFlags = tinkerFlags;
        this.delegateClassName = delegateClassName;
        this.loaderClassName = loaderClassName;
        this.tinkerLoadVerifyFlag = tinkerLoadVerifyFlag;
    }

    protected TinkerApplication(int tinkerFlags, String delegateClassName) {
        this(tinkerFlags, delegateClassName, TinkerLoader.class.getName(), false);
    }

    private Object createDelegate() {
        try {
            Class<?> delegateClass = Class.forName(this.delegateClassName, false, this.getClassLoader());
            Constructor<?> constructor = delegateClass.getConstructor(Application.class, Integer.TYPE, Boolean.TYPE, Long.TYPE, Long.TYPE, Intent.class, Resources[].class, ClassLoader[].class, AssetManager[].class);
            return constructor.newInstance(new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag, this.applicationStartElapsedTime, this.applicationStartMillisTime, this.tinkerResultIntent, this.resources, this.classLoader, this.assetManager});
        }
        catch (Throwable e) {
            throw new TinkerRuntimeException("createDelegate failed", e);
        }
    }

    private synchronized void ensureDelegate() {
        if (this.delegate == null) {
            this.delegate = this.createDelegate();
        }
    }

    private void onBaseContextAttached(Context base) {
        this.applicationStartElapsedTime = SystemClock.elapsedRealtime();
        this.applicationStartMillisTime = System.currentTimeMillis();
        this.loadTinker();
        this.ensureDelegate();
        try {
            Method method = ShareReflectUtil.findMethod(this.delegate, "onBaseContextAttached", Context.class);
            method.invoke(this.delegate, base);
        }
        catch (Throwable t) {
            throw new TinkerRuntimeException("onBaseContextAttached method not found", t);
        }
        if (this.useSafeMode) {
            String processName = ShareTinkerInternals.getProcessName((Context)this);
            String preferName = "tinker_own_config_" + processName;
            SharedPreferences sp = this.getSharedPreferences(preferName, 0);
            sp.edit().putInt("safe_mode_count", 0).commit();
        }
    }

    protected final void attachBaseContext(Context base) {
        super.attachBaseContext(base);
        this.onBaseContextAttached(base);
    }

    private void loadTinker() {
        if (this.tinkerFlags == 0) {
            return;
        }
        this.tinkerResultIntent = new Intent();
        try {
            Class<?> tinkerLoadClass = Class.forName(this.loaderClassName, false, this.getClassLoader());
            Method loadMethod = tinkerLoadClass.getMethod(TINKER_LOADER_METHOD, TinkerApplication.class, Integer.TYPE, Boolean.TYPE);
            Constructor<?> constructor = tinkerLoadClass.getConstructor(new Class[0]);
            this.tinkerResultIntent = (Intent)loadMethod.invoke(constructor.newInstance(new Object[0]), new Object[]{this, this.tinkerFlags, this.tinkerLoadVerifyFlag});
        }
        catch (Throwable e) {
            ShareIntentUtil.setIntentReturnCode(this.tinkerResultIntent, -19);
            this.tinkerResultIntent.putExtra(INTENT_PATCH_EXCEPTION, (Serializable)e);
        }
    }

    private void delegateMethod(String methodName) {
        if (this.delegate != null) {
            try {
                Method method = ShareReflectUtil.findMethod(this.delegate, methodName, new Class[0]);
                method.invoke(this.delegate, new Object[0]);
            }
            catch (Throwable t) {
                throw new TinkerRuntimeException(String.format("%s method not found", methodName), t);
            }
        }
    }

    public final void onCreate() {
        super.onCreate();
        this.ensureDelegate();
        this.delegateMethod("onCreate");
    }

    public final void onTerminate() {
        super.onTerminate();
        this.delegateMethod("onTerminate");
    }

    public final void onLowMemory() {
        super.onLowMemory();
        this.delegateMethod("onLowMemory");
    }

    private void delegateTrimMemory(int level) {
        if (this.delegate != null) {
            try {
                Method method = ShareReflectUtil.findMethod(this.delegate, "onTrimMemory", Integer.TYPE);
                method.invoke(this.delegate, level);
            }
            catch (Throwable t) {
                throw new TinkerRuntimeException("onTrimMemory method not found", t);
            }
        }
    }

    @TargetApi(value=14)
    public final void onTrimMemory(int level) {
        super.onTrimMemory(level);
        this.delegateTrimMemory(level);
    }

    private void delegateConfigurationChanged(Configuration newConfig) {
        if (this.delegate != null) {
            try {
                Method method = ShareReflectUtil.findMethod(this.delegate, "onConfigurationChanged", Configuration.class);
                method.invoke(this.delegate, newConfig);
            }
            catch (Throwable t) {
                throw new TinkerRuntimeException("onConfigurationChanged method not found", t);
            }
        }
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        this.delegateConfigurationChanged(newConfig);
    }

    public Resources getResources() {
        if (this.resources[0] != null) {
            return this.resources[0];
        }
        return super.getResources();
    }

    public ClassLoader getClassLoader() {
        if (this.classLoader[0] != null) {
            return this.classLoader[0];
        }
        return super.getClassLoader();
    }

    public AssetManager getAssets() {
        if (this.assetManager[0] != null) {
            return this.assetManager[0];
        }
        return super.getAssets();
    }

    public void setUseSafeMode(boolean useSafeMode) {
        this.useSafeMode = useSafeMode;
    }
}

