/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.tinker.loader;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.Intent;
import android.util.Log;
import com.tencent.tinker.loader.SystemClassLoaderAdder;
import com.tencent.tinker.loader.shareutil.ShareDexDiffPatchInfo;
import com.tencent.tinker.loader.shareutil.ShareIntentUtil;
import com.tencent.tinker.loader.shareutil.SharePatchFileUtil;
import com.tencent.tinker.loader.shareutil.ShareSecurityCheck;
import com.tencent.tinker.loader.shareutil.ShareTinkerInternals;
import dalvik.system.PathClassLoader;
import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;

public class TinkerDexLoader {
    private static final String TAG = "Tinker.TinkerDexLoader";
    private static final String DEX_MEAT_FILE = "assets/dex_meta.txt";
    private static final String DEX_PATH = "dex";
    private static final String DEX_OPTIMIZE_PATH = "odex";
    private static final ArrayList<ShareDexDiffPatchInfo> dexList = new ArrayList();

    private TinkerDexLoader() {
    }

    @TargetApi(value=14)
    public static boolean loadTinkerJars(Application application, boolean tinkerLoadVerifyFlag, String directory, Intent intentResult) {
        if (dexList.isEmpty()) {
            Log.w((String)TAG, (String)"there is no dex to load");
            return true;
        }
        PathClassLoader classLoader = (PathClassLoader)TinkerDexLoader.class.getClassLoader();
        if (classLoader == null) {
            Log.e((String)TAG, (String)"classloader is null");
            ShareIntentUtil.setIntentReturnCode(intentResult, -13);
            return false;
        }
        Log.i((String)TAG, (String)("classloader: " + classLoader.toString()));
        String dexPath = directory + "/" + DEX_PATH + "/";
        File optimizeDir = new File(directory + "/" + DEX_OPTIMIZE_PATH);
        ArrayList<File> legalFiles = new ArrayList<File>();
        boolean isArtPlatForm = ShareTinkerInternals.isVmArt();
        for (ShareDexDiffPatchInfo info : dexList) {
            if (TinkerDexLoader.isJustArtSupportDex(info)) continue;
            String path = dexPath + info.realName;
            File file = new File(path);
            if (tinkerLoadVerifyFlag) {
                String checkMd5;
                long start = System.currentTimeMillis();
                String string = checkMd5 = isArtPlatForm ? info.destMd5InArt : info.destMd5InDvm;
                if (!SharePatchFileUtil.verifyDexFileMd5(file, checkMd5)) {
                    ShareIntentUtil.setIntentReturnCode(intentResult, -14);
                    intentResult.putExtra("intent_patch_mismatch_dex_path", file.getAbsolutePath());
                    return false;
                }
                Log.i((String)TAG, (String)("verify dex file:" + file.getPath() + " md5, use time: " + (System.currentTimeMillis() - start)));
            }
            legalFiles.add(file);
        }
        try {
            SystemClassLoaderAdder.installDexes(application, classLoader, optimizeDir, legalFiles);
        }
        catch (Throwable e) {
            Log.e((String)TAG, (String)"install dexes failed");
            intentResult.putExtra("intent_patch_exception", (Serializable)e);
            ShareIntentUtil.setIntentReturnCode(intentResult, -15);
            return false;
        }
        Log.i((String)TAG, (String)("after loaded classloader: " + application.getClassLoader().toString()));
        return true;
    }

    public static boolean checkComplete(String directory, ShareSecurityCheck securityCheck, Intent intentResult) {
        String meta = securityCheck.getMetaContentMap().get(DEX_MEAT_FILE);
        if (meta == null) {
            return true;
        }
        dexList.clear();
        ShareDexDiffPatchInfo.parseDexDiffPatchInfo(meta, dexList);
        if (dexList.isEmpty()) {
            return true;
        }
        HashMap<String, String> dexes = new HashMap<String, String>();
        for (ShareDexDiffPatchInfo info : dexList) {
            if (TinkerDexLoader.isJustArtSupportDex(info)) continue;
            if (!ShareDexDiffPatchInfo.checkDexDiffPatchInfo(info)) {
                intentResult.putExtra("intent_patch_package_patch_check", -3);
                ShareIntentUtil.setIntentReturnCode(intentResult, -9);
                return false;
            }
            dexes.put(info.realName, info.destMd5InDvm);
        }
        String dexDirectory = directory + "/" + DEX_PATH + "/";
        File dexDir = new File(dexDirectory);
        if (!dexDir.exists() || !dexDir.isDirectory()) {
            ShareIntentUtil.setIntentReturnCode(intentResult, -10);
            return false;
        }
        String optimizeDexDirectory = directory + "/" + DEX_OPTIMIZE_PATH + "/";
        File optimizeDexDirectoryFile = new File(optimizeDexDirectory);
        for (String name : dexes.keySet()) {
            File dexFile = new File(dexDirectory + name);
            if (!dexFile.exists()) {
                intentResult.putExtra("intent_patch_missing_dex_path", dexFile.getAbsolutePath());
                ShareIntentUtil.setIntentReturnCode(intentResult, -11);
                return false;
            }
            File dexOptFile = new File(SharePatchFileUtil.optimizedPathFor(dexFile, optimizeDexDirectoryFile));
            if (dexOptFile.exists()) continue;
            intentResult.putExtra("intent_patch_missing_dex_path", dexOptFile.getAbsolutePath());
            ShareIntentUtil.setIntentReturnCode(intentResult, -12);
            return false;
        }
        intentResult.putExtra("intent_patch_dexes_path", dexes);
        return true;
    }

    private static boolean isJustArtSupportDex(ShareDexDiffPatchInfo dexDiffPatchInfo) {
        if (ShareTinkerInternals.isVmArt()) {
            return false;
        }
        String destMd5InDvm = dexDiffPatchInfo.destMd5InDvm;
        return destMd5InDvm.equals("0");
    }
}

