/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.utils;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.dongliu.apk.parser.bean.Locales;
import net.dongliu.apk.parser.exception.ParserException;
import net.dongliu.apk.parser.parser.StringPoolEntry;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.StringPool;
import net.dongliu.apk.parser.struct.StringPoolHeader;
import net.dongliu.apk.parser.struct.resource.ResourceEntry;
import net.dongliu.apk.parser.struct.resource.ResourcePackage;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.resource.TypeSpec;
import net.dongliu.apk.parser.utils.Buffers;

public class ParseUtils {
    public static Charset charsetUTF8 = Charset.forName("UTF-8");
    public static Charset charsetUTF16 = Charset.forName("UTF-16LE");

    public static String readString(ByteBuffer buffer, boolean utf8) {
        if (utf8) {
            int strLen = ParseUtils.readLen(buffer);
            int bytesLen = ParseUtils.readLen(buffer);
            byte[] bytes = Buffers.readBytes(buffer, bytesLen);
            String str = new String(bytes, charsetUTF8);
            short trailling = Buffers.readUByte(buffer);
            return str;
        }
        int strLen = ParseUtils.readLen16(buffer);
        String str = Buffers.readString(buffer, strLen);
        int trailling = Buffers.readUShort(buffer);
        return str;
    }

    public static String readStringUTF16(ByteBuffer buffer, int strLen) {
        String str = Buffers.readString(buffer, strLen);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (c != '\u0000') continue;
            return str.substring(0, i);
        }
        return str;
    }

    private static int readLen(ByteBuffer buffer) {
        int len = 0;
        int i = Buffers.readUByte(buffer);
        if ((i & 0x80) != 0) {
            len |= (i & 0x7F) << 7;
            len += Buffers.readUByte(buffer);
        } else {
            len = i;
        }
        return len;
    }

    private static int readLen16(ByteBuffer buffer) {
        int len = 0;
        int i = Buffers.readUShort(buffer);
        if ((i & 0x8000) != 0) {
            len |= (i & Short.MAX_VALUE) << 15;
            len += Buffers.readUShort(buffer);
        } else {
            len = i;
        }
        return len;
    }

    public static StringPool readStringPool(ByteBuffer buffer, StringPoolHeader stringPoolHeader) {
        long beginPos = buffer.position();
        long[] offsets = new long[(int)stringPoolHeader.getStringCount()];
        if (stringPoolHeader.getStringCount() > 0L) {
            int idx = 0;
            while ((long)idx < stringPoolHeader.getStringCount()) {
                offsets[idx] = Buffers.readUInt(buffer);
                ++idx;
            }
        }
        boolean sorted = (stringPoolHeader.getFlags() & 1L) != 0L;
        boolean utf8 = (stringPoolHeader.getFlags() & 0x100L) != 0L;
        long stringPos = beginPos + stringPoolHeader.getStringsStart() - (long)stringPoolHeader.getHeaderSize();
        buffer.position((int)stringPos);
        StringPoolEntry[] entries = new StringPoolEntry[offsets.length];
        for (int i = 0; i < offsets.length; ++i) {
            entries[i] = new StringPoolEntry(i, stringPos + offsets[i]);
        }
        String lastStr = null;
        long lastOffset = -1L;
        HashMap<Integer, Long> stringOffsets = new HashMap<Integer, Long>();
        StringPool stringPool = new StringPool((int)stringPoolHeader.getStringCount());
        for (StringPoolEntry entry : entries) {
            String str;
            stringOffsets.put(entry.getIdx(), entry.getOffset());
            if (entry.getOffset() == lastOffset) {
                stringPool.set(entry.getIdx(), lastStr);
                continue;
            }
            buffer.position((int)entry.getOffset());
            lastOffset = entry.getOffset();
            lastStr = str = ParseUtils.readString(buffer, utf8);
            stringPool.set(entry.getIdx(), str);
        }
        if (stringPoolHeader.getStyleCount() > 0L) {
            // empty if block
        }
        stringPool.setUtf8(utf8);
        stringPool.setPoolOffsets(stringOffsets);
        buffer.position((int)(beginPos + (long)stringPoolHeader.getBodySize()));
        return stringPool;
    }

    @Nullable
    public static ResourceValue readResValue(ByteBuffer buffer, StringPool stringPool, ResourceTable resourceTable, Locale locale) {
        ResourceValue resValue;
        int size = Buffers.readUShort(buffer);
        short res0 = Buffers.readUByte(buffer);
        short dataType = Buffers.readUByte(buffer);
        switch (dataType) {
            case 16: {
                resValue = ResourceValue.decimal(buffer.getInt());
                break;
            }
            case 4: {
                int rawValue = buffer.getInt();
                resValue = ResourceValue.floatValue(rawValue, Float.intBitsToFloat(rawValue));
                break;
            }
            case 2: {
                resValue = ResourceValue.reference(buffer.getInt(), resourceTable, locale);
                break;
            }
            case 17: {
                resValue = ResourceValue.hexadecimal(buffer.getInt());
                break;
            }
            case 3: {
                int strRef = buffer.getInt();
                if (strRef >= 0) {
                    resValue = ResourceValue.string(strRef, stringPool);
                    break;
                }
                resValue = null;
                break;
            }
            case 1: {
                resValue = ResourceValue.reference(buffer.getInt(), resourceTable, locale);
                break;
            }
            case 18: {
                resValue = ResourceValue.bool(buffer.getInt());
                break;
            }
            case 0: {
                resValue = ResourceValue.nullValue();
                break;
            }
            case 29: 
            case 31: {
                resValue = ResourceValue.rgb(buffer.getInt(), 6);
                break;
            }
            case 28: 
            case 30: {
                resValue = ResourceValue.rgb(buffer.getInt(), 8);
                break;
            }
            case 5: {
                resValue = ResourceValue.dimension(buffer.getInt());
                break;
            }
            case 6: {
                resValue = ResourceValue.fraction(buffer.getInt());
                break;
            }
            default: {
                resValue = ResourceValue.raw(buffer.getInt(), dataType);
            }
        }
        if (resValue != null) {
            resValue.setDataType(dataType);
            resValue.setSize(size);
        }
        return resValue;
    }

    public static void checkChunkType(int expected, int real) {
        if (expected != real) {
            throw new ParserException("Expect chunk type:" + Integer.toHexString(expected) + ", but got:" + Integer.toHexString(real));
        }
    }

    public static String getResourceById(long resourceId, ResourceTable resourceTable, Locale locale) {
        if (resourceId > 0x1030000L && resourceId < 0x1031000L) {
            return "@android:style/" + ResourceTable.sysStyle.get((int)resourceId);
        }
        String str = "resourceId:0x" + Long.toHexString(resourceId);
        if (resourceTable == null) {
            return str;
        }
        short packageId = (short)(resourceId >> 24 & 0xFFL);
        short typeId = (short)(resourceId >> 16 & 0xFFL);
        int entryIndex = (int)(resourceId & 0xFFFFL);
        ResourcePackage resourcePackage = resourceTable.getPackage(packageId);
        if (resourcePackage == null) {
            return str;
        }
        TypeSpec typeSpec = resourcePackage.getTypeSpec(typeId);
        List<Type> types = resourcePackage.getTypes(typeId);
        if (typeSpec == null || types == null) {
            return str;
        }
        if (!typeSpec.exists(entryIndex)) {
            return str;
        }
        ResourceEntry resource = null;
        String ref = null;
        int currentLevel = -1;
        for (Type type : types) {
            ResourceEntry curResourceEntry = type.getResourceEntry(entryIndex);
            if (curResourceEntry == null) continue;
            ref = curResourceEntry.getKey();
            ResourceValue currentResourceValue = curResourceEntry.getValue();
            if (currentResourceValue == null || currentResourceValue instanceof ResourceValue.ReferenceResourceValue && resourceId == ((ResourceValue.ReferenceResourceValue)currentResourceValue).getReferenceResourceId()) continue;
            int level = Locales.match(locale, type.getLocale());
            if (level == 2) {
                resource = curResourceEntry;
                break;
            }
            if (level <= currentLevel) continue;
            resource = curResourceEntry;
            currentLevel = level;
        }
        String result = locale == null || resource == null ? "@" + typeSpec.getName() + "/" + ref : resource.toStringValue();
        return result;
    }

    public static String getResourceNameById(long resourceId, ResourceTable resourceTable) {
        if (resourceId > 0x1030000L && resourceId < 0x1031000L) {
            return "@android:style/" + ResourceTable.sysStyle.get((int)resourceId);
        }
        String str = "resourceId:0x" + Long.toHexString(resourceId);
        if (resourceTable == null) {
            return str;
        }
        short packageId = (short)(resourceId >> 24 & 0xFFL);
        short typeId = (short)(resourceId >> 16 & 0xFFL);
        int entryIndex = (int)(resourceId & 0xFFFFL);
        ResourcePackage resourcePackage = resourceTable.getPackage(packageId);
        if (resourcePackage == null) {
            return str;
        }
        TypeSpec typeSpec = resourcePackage.getTypeSpec(typeId);
        List<Type> types = resourcePackage.getTypes(typeId);
        if (typeSpec == null || types == null) {
            return str;
        }
        if (!typeSpec.exists(entryIndex)) {
            return str;
        }
        ResourceEntry resource = null;
        String ref = null;
        for (Type type : types) {
            ResourceEntry curResourceEntry = type.getResourceEntry(entryIndex);
            if (curResourceEntry == null) continue;
            ref = curResourceEntry.getKey();
            return ref;
        }
        String result = resource == null ? "@" + typeSpec.getName() + "/" + ref : resource.toStringValue();
        return result;
    }
}

