/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.struct.resource;

import java.util.HashMap;
import javax.annotation.Nullable;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.resource.ResourceMapEntry;
import net.dongliu.apk.parser.struct.resource.ResourceTableMap;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.utils.ParseUtils;

public class ResourceEntry {
    private int size;
    public static final int FLAG_COMPLEX = 1;
    public static final int FLAG_PUBLIC = 2;
    private int flags;
    private String key;
    private ResourceValue value;
    private Type type;

    public String toStringValue() {
        if (this.value != null) {
            return this.value.toStringValue();
        }
        return "null";
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Nullable
    public ResourceValue getValue() {
        return this.value;
    }

    @Nullable
    public void setValue(@Nullable ResourceValue value) {
        this.value = value;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public String toString() {
        return "ResourceEntry{size=" + this.size + ", flags=" + this.flags + ", key='" + this.key + '\'' + ", value=" + this.value + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ResourceEntry) {
            boolean ifMapEntry = this instanceof ResourceMapEntry;
            boolean ifOldMapEntry = object instanceof ResourceMapEntry;
            if (ifMapEntry != ifOldMapEntry) {
                return false;
            }
            ResourceEntry oldResEntry = (ResourceEntry)object;
            if (!this.key.equals(oldResEntry.getKey())) {
                return false;
            }
            if (!this.flagIgnorePublic(this.flags, oldResEntry.getFlags())) {
                return false;
            }
            if (!this.valueIgnorePublic(this.value, this.type, oldResEntry.getValue(), oldResEntry.getType())) {
                return false;
            }
            if (ifOldMapEntry) {
                ResourceTableMap[] oldResourceTableMaps;
                String oldParentSpecName;
                ResourceMapEntry oldMapEntry = (ResourceMapEntry)object;
                ResourceMapEntry mapEntry = (ResourceMapEntry)this;
                if (mapEntry.getCount() != oldMapEntry.getCount()) {
                    return false;
                }
                String parentSpecName = ParseUtils.getResourceNameById(mapEntry.getParent(), this.type.getResourceTable());
                if (!parentSpecName.equals(oldParentSpecName = ParseUtils.getResourceNameById(oldMapEntry.getParent(), oldMapEntry.getType().getResourceTable()))) {
                    return false;
                }
                ResourceTableMap[] resourceTableMaps = mapEntry.getResourceTableMaps();
                if (resourceTableMaps.length != (oldResourceTableMaps = oldMapEntry.getResourceTableMaps()).length) {
                    return false;
                }
                HashMap<String, ResourceValue> resKeyValue = new HashMap<String, ResourceValue>();
                HashMap<String, ResourceValue> oldResKeyValue = new HashMap<String, ResourceValue>();
                int length = resourceTableMaps.length;
                for (int i = 0; i < length; ++i) {
                    ResourceTableMap resourceTable = resourceTableMaps[i];
                    String resSpecName = ParseUtils.getResourceNameById(resourceTable.getNameRef(), this.type.getResourceTable());
                    resKeyValue.put(resSpecName, resourceTable.getResValue());
                    ResourceTableMap oldResourceTable = oldResourceTableMaps[i];
                    String oldResSpecName = ParseUtils.getResourceNameById(oldResourceTable.getNameRef(), oldMapEntry.getType().getResourceTable());
                    oldResKeyValue.put(oldResSpecName, oldResourceTable.getResValue());
                }
                for (String name : resKeyValue.keySet()) {
                    if (!oldResKeyValue.containsKey(name)) {
                        return false;
                    }
                    if (this.valueIgnorePublic((ResourceValue)resKeyValue.get(name), this.type, (ResourceValue)oldResKeyValue.get(name), oldResEntry.getType())) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public boolean flagIgnorePublic(int flag1, int flag2) {
        return (flag1 & 0xFFFFFFFD) == (flag2 & 0xFFFFFFFD);
    }

    public boolean valueIgnorePublic(ResourceValue value1, Type type1, ResourceValue value2, Type type2) {
        if (value1 == null && value2 == null) {
            return true;
        }
        if (value1 == null && value2 != null || value1 != null && value2 == null) {
            return false;
        }
        if (this.type.getName().equals("id") && (value1.getDataType() == 3 && value2.getDataType() == 18 || value1.getDataType() == 18 && value1.getDataType() == 3)) {
            return true;
        }
        if (value1.getSize() != value2.getSize()) {
            return false;
        }
        if (value1.getDataType() != value2.getDataType()) {
            return false;
        }
        if (value1 instanceof ResourceValue.ReferenceResourceValue && value2 instanceof ResourceValue.ReferenceResourceValue) {
            String name1 = ParseUtils.getResourceNameById(((ResourceValue.ReferenceResourceValue)value1).getReferenceResourceId(), type1.getResourceTable());
            String name2 = ParseUtils.getResourceNameById(((ResourceValue.ReferenceResourceValue)value2).getReferenceResourceId(), type2.getResourceTable());
            return name1.equals(name2);
        }
        return value1.toStringValue().equals(value2.toStringValue());
    }
}

