/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.dongliu.apk.parser.AbstractApkParser;
import net.dongliu.apk.parser.bean.ApkSignStatus;
import net.dongliu.apk.parser.utils.Utils;

public class ApkParser
extends AbstractApkParser
implements Closeable {
    private ZipFile zf;
    private File apkFile;

    public ApkParser() {
    }

    public ApkParser(File apkFile) throws IOException {
        this.apkFile = apkFile;
        this.zf = new ZipFile(apkFile);
    }

    public ApkParser(String filePath) throws IOException {
        this(new File(filePath));
    }

    @Override
    protected byte[] getCertificateData() throws IOException {
        ZipEntry entry = null;
        Enumeration<? extends ZipEntry> enu = this.zf.entries();
        while (enu.hasMoreElements()) {
            ZipEntry ne = enu.nextElement();
            if (ne.isDirectory() || !ne.getName().toUpperCase().endsWith(".RSA") && !ne.getName().toUpperCase().endsWith(".DSA")) continue;
            entry = ne;
            break;
        }
        if (entry == null) {
            return null;
        }
        return Utils.toByteArray(this.zf.getInputStream(entry));
    }

    @Override
    public byte[] getFileData(String path) throws IOException {
        ZipEntry entry = this.zf.getEntry(path);
        if (entry == null) {
            return null;
        }
        InputStream inputStream = this.zf.getInputStream(entry);
        return Utils.toByteArray(inputStream);
    }

    @Override
    public ApkSignStatus verifyApk() throws IOException {
        ZipEntry entry = this.zf.getEntry("META-INF/MANIFEST.MF");
        if (entry == null) {
            return ApkSignStatus.notSigned;
        }
        JarFile jarFile = new JarFile(this.apkFile);
        Enumeration<JarEntry> entries = jarFile.entries();
        byte[] buffer = new byte[8192];
        while (entries.hasMoreElements()) {
            JarEntry e = entries.nextElement();
            if (e.isDirectory()) continue;
            try {
                InputStream in = jarFile.getInputStream(e);
                Throwable throwable = null;
                try {
                    int count;
                    while ((count = in.read(buffer, 0, buffer.length)) != -1) {
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            catch (SecurityException se) {
                return ApkSignStatus.incorrect;
            }
        }
        return ApkSignStatus.signed;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.zf.close();
    }
}

