/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bridge;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;

public class CacheBuilderWriter
implements Opcodes {
    private static final String packageName = "com/google/common/cache";
    private static final String className = "CacheBuilder.class";

    public static void main(String[] args) {
        if (args.length != 1) {
            System.out.print("" + args.length);
            throw new IllegalArgumentException("Must provide target path");
        }
        String outDir = args[0];
        File path = new File(outDir, packageName);
        path.mkdirs();
        File targetClass = new File(path, className);
        FilterOutputStream dout = null;
        try {
            dout = new DataOutputStream(new FileOutputStream(targetClass));
            dout.write(CacheBuilderWriter.dump());
            ((DataOutputStream)dout).flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (dout != null) {
                try {
                    dout.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    public static byte[] dump() throws Exception {
        ClassWriter cw = new ClassWriter(3);
        cw.visit(49, 49, "com/google/common/cache/CacheBuilder", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/lang/Object;", "java/lang/Object", null);
        AnnotationVisitor av0 = cw.visitAnnotation("Lcom/google/common/annotations/Beta;", false);
        av0.visitEnd();
        av0 = cw.visitAnnotation("Lcom/google/common/annotations/GwtCompatible;", false);
        av0.visit("emulated", (Object)Boolean.TRUE);
        av0.visitEnd();
        cw.visitInnerClass("com/google/common/cache/CacheBuilder$OneWeigher", "com/google/common/cache/CacheBuilder", "OneWeigher", 16408);
        cw.visitInnerClass("com/google/common/cache/CacheBuilder$NullListener", "com/google/common/cache/CacheBuilder", "NullListener", 16408);
        cw.visitInnerClass("com/google/common/cache/CacheBuilder$3", null, null, 8);
        cw.visitInnerClass("com/google/common/cache/CacheBuilder$2", null, null, 8);
        cw.visitInnerClass("com/google/common/cache/CacheBuilder$1", null, null, 8);
        cw.visitInnerClass("com/google/common/cache/AbstractCache$StatsCounter", "com/google/common/cache/AbstractCache", "StatsCounter", 1545);
        cw.visitInnerClass("com/google/common/cache/AbstractCache$SimpleStatsCounter", "com/google/common/cache/AbstractCache", "SimpleStatsCounter", 9);
        cw.visitInnerClass("com/google/common/cache/LocalCache$Strength", "com/google/common/cache/LocalCache", "Strength", 17416);
        cw.visitInnerClass("com/google/common/base/Objects$ToStringHelper", "com/google/common/base/Objects", "ToStringHelper", 25);
        cw.visitInnerClass("com/google/common/cache/LocalCache$LocalLoadingCache", "com/google/common/cache/LocalCache", "LocalLoadingCache", 8);
        cw.visitInnerClass("com/google/common/cache/LocalCache$LocalManualCache", "com/google/common/cache/LocalCache", "LocalManualCache", 8);
        FieldVisitor fv = cw.visitField(26, "DEFAULT_INITIAL_CAPACITY", "I", null, (Object)new Integer(16));
        fv.visitEnd();
        fv = cw.visitField(26, "DEFAULT_CONCURRENCY_LEVEL", "I", null, (Object)new Integer(4));
        fv.visitEnd();
        fv = cw.visitField(26, "DEFAULT_EXPIRATION_NANOS", "I", null, (Object)new Integer(0));
        fv.visitEnd();
        fv = cw.visitField(26, "DEFAULT_REFRESH_NANOS", "I", null, (Object)new Integer(0));
        fv.visitEnd();
        fv = cw.visitField(24, "NULL_STATS_COUNTER", "Lcom/google/common/base/Supplier;", "Lcom/google/common/base/Supplier<+Lcom/google/common/cache/AbstractCache$StatsCounter;>;", null);
        fv.visitEnd();
        fv = cw.visitField(24, "EMPTY_STATS", "Lcom/google/common/cache/CacheStats;", null, null);
        fv.visitEnd();
        fv = cw.visitField(24, "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;", "Lcom/google/common/base/Supplier<Lcom/google/common/cache/AbstractCache$SimpleStatsCounter;>;", null);
        fv.visitEnd();
        fv = cw.visitField(24, "NULL_TICKER", "Lcom/google/common/base/Ticker;", null, null);
        fv.visitEnd();
        fv = cw.visitField(26, "logger", "Ljava/util/logging/Logger;", null, null);
        fv.visitEnd();
        fv = cw.visitField(24, "UNSET_INT", "I", null, (Object)new Integer(-1));
        fv.visitEnd();
        fv = cw.visitField(0, "strictParsing", "Z", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "initialCapacity", "I", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "concurrencyLevel", "I", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "maximumSize", "J", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "maximumWeight", "J", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "weigher", "Lcom/google/common/cache/Weigher;", "Lcom/google/common/cache/Weigher<-TK;-TV;>;", null);
        fv.visitEnd();
        fv = cw.visitField(0, "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "expireAfterWriteNanos", "J", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "expireAfterAccessNanos", "J", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "refreshNanos", "J", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "keyEquivalence", "Lcom/google/common/base/Equivalence;", "Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
        fv.visitEnd();
        fv = cw.visitField(0, "valueEquivalence", "Lcom/google/common/base/Equivalence;", "Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
        fv.visitEnd();
        fv = cw.visitField(0, "removalListener", "Lcom/google/common/cache/RemovalListener;", "Lcom/google/common/cache/RemovalListener<-TK;-TV;>;", null);
        fv.visitEnd();
        fv = cw.visitField(0, "ticker", "Lcom/google/common/base/Ticker;", null, null);
        fv.visitEnd();
        fv = cw.visitField(0, "statsCounterSupplier", "Lcom/google/common/base/Supplier;", "Lcom/google/common/base/Supplier<+Lcom/google/common/cache/AbstractCache$StatsCounter;>;", null);
        fv.visitEnd();
        MethodVisitor mv = cw.visitMethod(0, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "java/lang/Object", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(4);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(2);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(2);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder", "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
        mv.visitInsn(177);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cw.visitMethod(9, "newBuilder", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<Ljava/lang/Object;Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitTypeInsn(187, "com/google/common/cache/CacheBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder", "<init>", "()V");
        mv.visitInsn(176);
        mv.visitMaxs(2, 0);
        mv.visitEnd();
        mv = cw.visitMethod(0, "lenientParsing", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitInsn(3);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "keyEquivalence", "(Lcom/google/common/base/Equivalence;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
        Label l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        Label l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"key equivalence was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/base/Equivalence");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(6, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getKeyEquivalence", "()Lcom/google/common/base/Equivalence;", "()Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "getKeyStrength", "()Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/LocalCache$Strength", "defaultEquivalence", "()Lcom/google/common/base/Equivalence;");
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/base/Equivalence");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "valueEquivalence", "(Lcom/google/common/base/Equivalence;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"value equivalence was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/base/Equivalence");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(6, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getValueEquivalence", "()Lcom/google/common/base/Equivalence;", "()Lcom/google/common/base/Equivalence<Ljava/lang/Object;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "getValueStrength", "()Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/LocalCache$Strength", "defaultEquivalence", "()Lcom/google/common/base/Equivalence;");
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/base/Equivalence");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "initialCapacity", "(I)Lcom/google/common/cache/CacheBuilder;", "(I)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitInsn(2);
        l0 = new Label();
        mv.visitJumpInsn(160, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"initial capacity was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(21, 1);
        Label l2 = new Label();
        mv.visitJumpInsn(155, l2);
        mv.visitInsn(4);
        Label l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(Z)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(6, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getInitialCapacity", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitInsn(2);
        l0 = new Label();
        mv.visitJumpInsn(160, l0);
        mv.visitIntInsn(16, 16);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitLabel(l1);
        mv.visitInsn(172);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "concurrencyLevel", "(I)Lcom/google/common/cache/CacheBuilder;", "(I)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitInsn(2);
        l0 = new Label();
        mv.visitJumpInsn(160, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"concurrency level was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitMethodInsn(184, "java/lang/Integer", "valueOf", "(I)Ljava/lang/Integer;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(21, 1);
        l2 = new Label();
        mv.visitJumpInsn(158, l2);
        mv.visitInsn(4);
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(Z)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(6, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getConcurrencyLevel", "()I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitInsn(2);
        l0 = new Label();
        mv.visitJumpInsn(160, l0);
        mv.visitInsn(7);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitLabel(l1);
        mv.visitInsn(172);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "maximumSize", "(J)Lcom/google/common/cache/CacheBuilder;", "(J)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"maximum size was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l2 = new Label();
        mv.visitJumpInsn(154, l2);
        mv.visitInsn(4);
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitLdcInsn((Object)"maximum weight was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        Label l4 = new Label();
        mv.visitJumpInsn(199, l4);
        mv.visitInsn(4);
        Label l5 = new Label();
        mv.visitJumpInsn(167, l5);
        mv.visitLabel(l4);
        mv.visitInsn(3);
        mv.visitLabel(l5);
        mv.visitLdcInsn((Object)"maximum size can not be combined with weigher");
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
        mv.visitVarInsn(22, 1);
        mv.visitInsn(9);
        mv.visitInsn(148);
        Label l6 = new Label();
        mv.visitJumpInsn(155, l6);
        mv.visitInsn(4);
        Label l7 = new Label();
        mv.visitJumpInsn(167, l7);
        mv.visitLabel(l6);
        mv.visitInsn(3);
        mv.visitLabel(l7);
        mv.visitLdcInsn((Object)"maximum size must not be negative");
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(22, 1);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(7, 3);
        mv.visitEnd();
        mv = cw.visitMethod(131073, "maximumSize", "(I)Lcom/google/common/cache/CacheBuilder;", "(I)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(21, 1);
        mv.visitInsn(133);
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "maximumSize", "(J)Lcom/google/common/cache/CacheBuilder;");
        mv.visitInsn(176);
        mv.visitMaxs(3, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "maximumWeight", "(J)Lcom/google/common/cache/CacheBuilder;", "(J)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"maximum weight was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l2 = new Label();
        mv.visitJumpInsn(154, l2);
        mv.visitInsn(4);
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitLdcInsn((Object)"maximum size was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(22, 1);
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitVarInsn(22, 1);
        mv.visitInsn(9);
        mv.visitInsn(148);
        l4 = new Label();
        mv.visitJumpInsn(155, l4);
        mv.visitInsn(4);
        l5 = new Label();
        mv.visitJumpInsn(167, l5);
        mv.visitLabel(l4);
        mv.visitInsn(3);
        mv.visitLabel(l5);
        mv.visitLdcInsn((Object)"maximum weight must not be negative");
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(7, 3);
        mv.visitEnd();
        mv = cw.visitMethod(1, "weigher", "(Lcom/google/common/cache/Weigher;)Lcom/google/common/cache/CacheBuilder;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/Weigher<-TK1;-TV1;>;)Lcom/google/common/cache/CacheBuilder<TK1;TV1;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(Z)V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
        l2 = new Label();
        mv.visitJumpInsn(153, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l3 = new Label();
        mv.visitJumpInsn(154, l3);
        mv.visitInsn(4);
        l4 = new Label();
        mv.visitJumpInsn(167, l4);
        mv.visitLabel(l3);
        mv.visitInsn(3);
        mv.visitLabel(l4);
        mv.visitLdcInsn((Object)"weigher can not be combined with maximum size");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/Weigher");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(7, 3);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getMaximumWeight", "()J", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitInsn(9);
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(153, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitInsn(9);
        mv.visitInsn(148);
        l1 = new Label();
        mv.visitJumpInsn(154, l1);
        mv.visitLabel(l0);
        mv.visitInsn(9);
        mv.visitInsn(173);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        l2 = new Label();
        mv.visitJumpInsn(199, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumSize", "J");
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLabel(l3);
        mv.visitInsn(173);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getWeigher", "()Lcom/google/common/cache/Weigher;", "<K1:TK;V1:TV;>()Lcom/google/common/cache/Weigher<TK1;TV1;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder$OneWeigher", "INSTANCE", "Lcom/google/common/cache/CacheBuilder$OneWeigher;");
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/Weigher");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "strongKeys", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "setKeyStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "weakKeys", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
        av0.visit("value", (Object)"java.lang.ref.WeakReference");
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "WEAK", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "setKeyStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "setKeyStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"Key strength was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/LocalCache$Strength");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(6, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getKeyStrength", "()Lcom/google/common/cache/LocalCache$Strength;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/LocalCache$Strength");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "strongValues", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "weakValues", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
        av0.visit("value", (Object)"java.lang.ref.WeakReference");
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "WEAK", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "softValues", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
        av0.visit("value", (Object)"java.lang.ref.SoftReference");
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "SOFT", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/CacheBuilder", "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "setValueStrength", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/cache/LocalCache$Strength;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"Value strength was already set to %s");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/LocalCache$Strength");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(6, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getValueStrength", "()Lcom/google/common/cache/LocalCache$Strength;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitFieldInsn(178, "com/google/common/cache/LocalCache$Strength", "STRONG", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/LocalCache$Strength");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "expireAfterWrite", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder;", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"expireAfterWrite was already set to %s ns");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(22, 1);
        mv.visitInsn(9);
        mv.visitInsn(148);
        l2 = new Label();
        mv.visitJumpInsn(155, l2);
        mv.visitInsn(4);
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitLdcInsn((Object)"duration cannot be negative: %s %s");
        mv.visitInsn(5);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(182, "java/util/concurrent/TimeUnit", "toNanos", "(J)J");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(7, 4);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getExpireAfterWriteNanos", "()J", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(9);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitLabel(l1);
        mv.visitInsn(173);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "expireAfterAccess", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder;", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"expireAfterAccess was already set to %s ns");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(22, 1);
        mv.visitInsn(9);
        mv.visitInsn(148);
        l2 = new Label();
        mv.visitJumpInsn(155, l2);
        mv.visitInsn(4);
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitLdcInsn((Object)"duration cannot be negative: %s %s");
        mv.visitInsn(5);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(182, "java/util/concurrent/TimeUnit", "toNanos", "(J)J");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(7, 4);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getExpireAfterAccessNanos", "()J", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(9);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitLabel(l1);
        mv.visitInsn(173);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "refreshAfterWrite", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder;", "(JLjava/util/concurrent/TimeUnit;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
        av0.visit("value", (Object)"To be supported");
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 3);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitInsn(87);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"refresh was already set to %s ns");
        mv.visitInsn(4);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(22, 1);
        mv.visitInsn(9);
        mv.visitInsn(148);
        l2 = new Label();
        mv.visitJumpInsn(158, l2);
        mv.visitInsn(4);
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l2);
        mv.visitInsn(3);
        mv.visitLabel(l3);
        mv.visitLdcInsn((Object)"duration must be positive: %s %s");
        mv.visitInsn(5);
        mv.visitTypeInsn(189, "java/lang/Object");
        mv.visitInsn(89);
        mv.visitInsn(3);
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(184, "java/lang/Long", "valueOf", "(J)Ljava/lang/Long;");
        mv.visitInsn(83);
        mv.visitInsn(89);
        mv.visitInsn(4);
        mv.visitVarInsn(25, 3);
        mv.visitInsn(83);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkArgument", "(ZLjava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 3);
        mv.visitVarInsn(22, 1);
        mv.visitMethodInsn(182, "java/util/concurrent/TimeUnit", "toNanos", "(J)J");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(7, 4);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getRefreshNanos", "()J", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(9);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitLabel(l1);
        mv.visitInsn(173);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "ticker", "(Lcom/google/common/base/Ticker;)Lcom/google/common/cache/CacheBuilder;", "(Lcom/google/common/base/Ticker;)Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
        av0.visit("value", (Object)"To be supported");
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(Z)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/base/Ticker");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(2, 2);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getTicker", "(Z)Lcom/google/common/base/Ticker;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
        l0 = new Label();
        mv.visitJumpInsn(198, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "ticker", "Lcom/google/common/base/Ticker;");
        mv.visitInsn(176);
        mv.visitLabel(l0);
        mv.visitVarInsn(21, 1);
        l1 = new Label();
        mv.visitJumpInsn(153, l1);
        mv.visitMethodInsn(184, "com/google/common/base/Ticker", "systemTicker", "()Lcom/google/common/base/Ticker;");
        l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l1);
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder", "NULL_TICKER", "Lcom/google/common/base/Ticker;");
        mv.visitLabel(l2);
        mv.visitInsn(176);
        mv.visitMaxs(1, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "removalListener", "(Lcom/google/common/cache/RemovalListener;)Lcom/google/common/cache/CacheBuilder;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/RemovalListener<-TK1;-TV1;>;)Lcom/google/common/cache/CacheBuilder<TK1;TV1;>;", null);
        av0 = mv.visitAnnotation("Ljavax/annotation/CheckReturnValue;", true);
        av0.visitEnd();
        av0 = mv.visitAnnotation("Lcom/google/common/annotations/GwtIncompatible;", false);
        av0.visit("value", (Object)"To be supported");
        av0.visitEnd();
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(Z)V");
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(58, 2);
        mv.visitVarInsn(25, 2);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkNotNull", "(Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/RemovalListener");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
        mv.visitVarInsn(25, 2);
        mv.visitInsn(176);
        mv.visitMaxs(2, 3);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getRemovalListener", "()Lcom/google/common/cache/RemovalListener;", "<K1:TK;V1:TV;>()Lcom/google/common/cache/RemovalListener<TK1;TV1;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder$NullListener", "INSTANCE", "Lcom/google/common/cache/CacheBuilder$NullListener;");
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "firstNonNull", "(Ljava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;");
        mv.visitTypeInsn(192, "com/google/common/cache/RemovalListener");
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "disableStats", "()Lcom/google/common/cache/CacheBuilder;", "()Lcom/google/common/cache/CacheBuilder<TK;TV;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder", "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
        l0 = new Label();
        mv.visitJumpInsn(166, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(Z)V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder", "NULL_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
        mv.visitFieldInsn(181, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
        mv.visitVarInsn(25, 0);
        mv.visitInsn(176);
        mv.visitMaxs(2, 1);
        mv.visitEnd();
        mv = cw.visitMethod(0, "getStatsCounterSupplier", "()Lcom/google/common/base/Supplier;", "()Lcom/google/common/base/Supplier<+Lcom/google/common/cache/AbstractCache$StatsCounter;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "statsCounterSupplier", "Lcom/google/common/base/Supplier;");
        mv.visitInsn(176);
        mv.visitMaxs(1, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "build", "(Lcom/google/common/cache/CacheLoader;)Lcom/google/common/cache/LoadingCache;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/CacheLoader<-TK1;TV1;>;)Lcom/google/common/cache/LoadingCache<TK1;TV1;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder", "checkWeightWithWeigher", "()V");
        mv.visitTypeInsn(187, "com/google/common/cache/LocalCache$LocalLoadingCache");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "com/google/common/cache/LocalCache$LocalLoadingCache", "<init>", "(Lcom/google/common/cache/CacheBuilder;Lcom/google/common/cache/CacheLoader;)V");
        mv.visitInsn(176);
        mv.visitMaxs(4, 2);
        mv.visitEnd();
        mv = cw.visitMethod(131073, "build", "(Lcom/google/common/cache/CacheLoader;)Lcom/google/common/cache/Cache;", "<K1:TK;V1:TV;>(Lcom/google/common/cache/CacheLoader<-TK1;TV1;>;)Lcom/google/common/cache/Cache<TK1;TV1;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder", "checkWeightWithWeigher", "()V");
        mv.visitTypeInsn(187, "com/google/common/cache/LocalCache$LocalLoadingCache");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(183, "com/google/common/cache/LocalCache$LocalLoadingCache", "<init>", "(Lcom/google/common/cache/CacheBuilder;Lcom/google/common/cache/CacheLoader;)V");
        mv.visitInsn(176);
        mv.visitMaxs(4, 2);
        mv.visitEnd();
        mv = cw.visitMethod(1, "build", "()Lcom/google/common/cache/Cache;", "<K1:TK;V1:TV;>()Lcom/google/common/cache/Cache<TK1;TV1;>;", null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder", "checkWeightWithWeigher", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder", "checkNonLoadingCache", "()V");
        mv.visitTypeInsn(187, "com/google/common/cache/LocalCache$LocalManualCache");
        mv.visitInsn(89);
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, "com/google/common/cache/LocalCache$LocalManualCache", "<init>", "(Lcom/google/common/cache/CacheBuilder;)V");
        mv.visitInsn(176);
        mv.visitMaxs(3, 1);
        mv.visitEnd();
        mv = cw.visitMethod(2, "checkNonLoadingCache", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "refreshNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l0 = new Label();
        mv.visitJumpInsn(154, l0);
        mv.visitInsn(4);
        l1 = new Label();
        mv.visitJumpInsn(167, l1);
        mv.visitLabel(l0);
        mv.visitInsn(3);
        mv.visitLabel(l1);
        mv.visitLdcInsn((Object)"refreshAfterWrite requires a LoadingCache");
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
        mv.visitInsn(177);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = cw.visitMethod(2, "checkWeightWithWeigher", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        l0 = new Label();
        mv.visitJumpInsn(199, l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l1 = new Label();
        mv.visitJumpInsn(154, l1);
        mv.visitInsn(4);
        l2 = new Label();
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l1);
        mv.visitInsn(3);
        mv.visitLabel(l2);
        mv.visitLdcInsn((Object)"maximumWeight requires weigher");
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
        l3 = new Label();
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "strictParsing", "Z");
        l4 = new Label();
        mv.visitJumpInsn(153, l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l5 = new Label();
        mv.visitJumpInsn(153, l5);
        mv.visitInsn(4);
        l6 = new Label();
        mv.visitJumpInsn(167, l6);
        mv.visitLabel(l5);
        mv.visitInsn(3);
        mv.visitLabel(l6);
        mv.visitLdcInsn((Object)"weigher requires maximumWeight");
        mv.visitMethodInsn(184, "com/google/common/base/Preconditions", "checkState", "(ZLjava/lang/Object;)V");
        mv.visitJumpInsn(167, l3);
        mv.visitLabel(l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        mv.visitJumpInsn(154, l3);
        mv.visitFieldInsn(178, "com/google/common/cache/CacheBuilder", "logger", "Ljava/util/logging/Logger;");
        mv.visitFieldInsn(178, "java/util/logging/Level", "WARNING", "Ljava/util/logging/Level;");
        mv.visitLdcInsn((Object)"ignoring weigher specified without maximumWeight");
        mv.visitMethodInsn(182, "java/util/logging/Logger", "log", "(Ljava/util/logging/Level;Ljava/lang/String;)V");
        mv.visitLabel(l3);
        mv.visitInsn(177);
        mv.visitMaxs(4, 1);
        mv.visitEnd();
        mv = cw.visitMethod(1, "toString", "()Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(184, "com/google/common/base/Objects", "toStringHelper", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitVarInsn(58, 1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitInsn(2);
        l0 = new Label();
        mv.visitJumpInsn(159, l0);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"initialCapacity");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "initialCapacity", "I");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;I)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitInsn(2);
        l1 = new Label();
        mv.visitJumpInsn(159, l1);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"concurrencyLevel");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "concurrencyLevel", "I");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;I)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l1);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l2 = new Label();
        mv.visitJumpInsn(153, l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "weigher", "Lcom/google/common/cache/Weigher;");
        l3 = new Label();
        mv.visitJumpInsn(199, l3);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"maximumSize");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;J)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitJumpInsn(167, l2);
        mv.visitLabel(l3);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"maximumWeight");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "maximumWeight", "J");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;J)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l2);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l4 = new Label();
        mv.visitJumpInsn(153, l4);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"expireAfterWrite");
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterWriteNanos", "J");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(J)Ljava/lang/StringBuilder;");
        mv.visitLdcInsn((Object)"ns");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l4);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitLdcInsn((Object)new Long(-1L));
        mv.visitInsn(148);
        l5 = new Label();
        mv.visitJumpInsn(153, l5);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"expireAfterAccess");
        mv.visitTypeInsn(187, "java/lang/StringBuilder");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "java/lang/StringBuilder", "<init>", "()V");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "expireAfterAccessNanos", "J");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(J)Ljava/lang/StringBuilder;");
        mv.visitLdcInsn((Object)"ns");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "append", "(Ljava/lang/String;)Ljava/lang/StringBuilder;");
        mv.visitMethodInsn(182, "java/lang/StringBuilder", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l5);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        l6 = new Label();
        mv.visitJumpInsn(198, l6);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"keyStrength");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/LocalCache$Strength", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(184, "com/google/common/base/Ascii", "toLowerCase", "(Ljava/lang/String;)Ljava/lang/String;");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l6);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        l7 = new Label();
        mv.visitJumpInsn(198, l7);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"valueStrength");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueStrength", "Lcom/google/common/cache/LocalCache$Strength;");
        mv.visitMethodInsn(182, "com/google/common/cache/LocalCache$Strength", "toString", "()Ljava/lang/String;");
        mv.visitMethodInsn(184, "com/google/common/base/Ascii", "toLowerCase", "(Ljava/lang/String;)Ljava/lang/String;");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "add", "(Ljava/lang/String;Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l7);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "keyEquivalence", "Lcom/google/common/base/Equivalence;");
        Label l8 = new Label();
        mv.visitJumpInsn(198, l8);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"keyEquivalence");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "addValue", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l8);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "valueEquivalence", "Lcom/google/common/base/Equivalence;");
        Label l9 = new Label();
        mv.visitJumpInsn(198, l9);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"valueEquivalence");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "addValue", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l9);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, "com/google/common/cache/CacheBuilder", "removalListener", "Lcom/google/common/cache/RemovalListener;");
        Label l10 = new Label();
        mv.visitJumpInsn(198, l10);
        mv.visitVarInsn(25, 1);
        mv.visitLdcInsn((Object)"removalListener");
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "addValue", "(Ljava/lang/Object;)Lcom/google/common/base/Objects$ToStringHelper;");
        mv.visitInsn(87);
        mv.visitLabel(l10);
        mv.visitVarInsn(25, 1);
        mv.visitMethodInsn(182, "com/google/common/base/Objects$ToStringHelper", "toString", "()Ljava/lang/String;");
        mv.visitInsn(176);
        mv.visitMaxs(5, 2);
        mv.visitEnd();
        mv = cw.visitMethod(8, "<clinit>", "()V", null, null);
        mv.visitCode();
        mv.visitTypeInsn(187, "com/google/common/cache/CacheBuilder$1");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder$1", "<init>", "()V");
        mv.visitMethodInsn(184, "com/google/common/base/Suppliers", "ofInstance", "(Ljava/lang/Object;)Lcom/google/common/base/Supplier;");
        mv.visitFieldInsn(179, "com/google/common/cache/CacheBuilder", "NULL_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
        mv.visitTypeInsn(187, "com/google/common/cache/CacheStats");
        mv.visitInsn(89);
        mv.visitInsn(9);
        mv.visitInsn(9);
        mv.visitInsn(9);
        mv.visitInsn(9);
        mv.visitInsn(9);
        mv.visitInsn(9);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheStats", "<init>", "(JJJJJJ)V");
        mv.visitFieldInsn(179, "com/google/common/cache/CacheBuilder", "EMPTY_STATS", "Lcom/google/common/cache/CacheStats;");
        mv.visitTypeInsn(187, "com/google/common/cache/CacheBuilder$2");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder$2", "<init>", "()V");
        mv.visitFieldInsn(179, "com/google/common/cache/CacheBuilder", "CACHE_STATS_COUNTER", "Lcom/google/common/base/Supplier;");
        mv.visitTypeInsn(187, "com/google/common/cache/CacheBuilder$3");
        mv.visitInsn(89);
        mv.visitMethodInsn(183, "com/google/common/cache/CacheBuilder$3", "<init>", "()V");
        mv.visitFieldInsn(179, "com/google/common/cache/CacheBuilder", "NULL_TICKER", "Lcom/google/common/base/Ticker;");
        mv.visitLdcInsn((Object)Type.getType((String)"Lcom/google/common/cache/CacheBuilder;"));
        mv.visitMethodInsn(182, "java/lang/Class", "getName", "()Ljava/lang/String;");
        mv.visitMethodInsn(184, "java/util/logging/Logger", "getLogger", "(Ljava/lang/String;)Ljava/util/logging/Logger;");
        mv.visitFieldInsn(179, "com/google/common/cache/CacheBuilder", "logger", "Ljava/util/logging/Logger;");
        mv.visitInsn(177);
        mv.visitMaxs(14, 0);
        mv.visitEnd();
        cw.visitEnd();
        return cw.toByteArray();
    }
}

