/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.concurrent;

import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.NotNull;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ThreadFactories {
    public static ThreadFactory namedThreadFactory(@NotNull String name) {
        return new Default(name, Type.USER, 5);
    }

    public static ThreadFactory namedThreadFactory(@NotNull String name, @NotNull Type type) {
        return new Default(name, type, 5);
    }

    public static ThreadFactory namedThreadFactory(@NotNull String name, @NotNull Type type, int priority) {
        return new Default(name, type, priority);
    }

    private ThreadFactories() {
        throw new AssertionError((Object)"cannot instantiate!");
    }

    static class Default
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);
        final String namePrefix;
        final Type type;
        final int priority;

        Default(String name, Type type, int priority) {
            Assertions.notNull("name", name);
            Assertions.notNull("type", type);
            Assertions.isTrue("priority too low", priority >= 1);
            Assertions.isTrue("priority too high", priority <= 10);
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = name + ":thread-";
            this.type = type;
            this.priority = priority;
        }

        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(this.type.isDaemon);
            t.setPriority(this.priority);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DAEMON(true),
        USER(false);

        final boolean isDaemon;

        private Type(boolean isDaemon) {
            this.isDaemon = isDaemon;
        }
    }
}

