/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.servlet;

import com.atlassian.plugin.servlet.PluginHttpSessionWrapper;
import com.atlassian.plugin.servlet.descriptors.BaseServletModuleDescriptor;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.StringUtils;

public class PluginHttpRequestWrapper
extends HttpServletRequestWrapper {
    private final String basePath;
    private HttpServletRequest delegate;

    public PluginHttpRequestWrapper(HttpServletRequest request, BaseServletModuleDescriptor<?> descriptor) {
        super(request);
        this.delegate = request;
        this.basePath = this.findBasePath(descriptor);
    }

    public String getServletPath() {
        String servletPath = super.getServletPath();
        if (this.basePath != null) {
            servletPath = servletPath + this.basePath;
        }
        return servletPath;
    }

    public String getPathInfo() {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null && this.basePath != null) {
            if (this.basePath.equals(pathInfo)) {
                return null;
            }
            if (pathInfo.startsWith(this.basePath)) {
                return pathInfo.substring(this.basePath.length());
            }
        }
        return pathInfo;
    }

    private String findBasePath(BaseServletModuleDescriptor<?> descriptor) {
        String pathInfo = super.getPathInfo();
        if (pathInfo != null) {
            for (String basePath : descriptor.getPaths()) {
                if (!basePath.equals(pathInfo)) continue;
                return basePath;
            }
            String[] pathInfoComponents = StringUtils.split((String)pathInfo, (char)'/');
            for (String basePath : descriptor.getPaths()) {
                String mappingRootPath;
                String[] mappingRootPathComponents;
                if (!this.isPathMapping(basePath) || !PluginHttpRequestWrapper.arrayStartsWith(pathInfoComponents, mappingRootPathComponents = StringUtils.split((String)(mappingRootPath = this.getMappingRootPath(basePath)), (char)'/'))) continue;
                return mappingRootPath;
            }
        }
        return null;
    }

    private static boolean arrayStartsWith(String[] array, String[] prefixArray) {
        if (prefixArray.length > array.length) {
            return false;
        }
        for (int i = prefixArray.length - 1; i >= 0; --i) {
            if (prefixArray[i].equals(array[i])) continue;
            return false;
        }
        return true;
    }

    private boolean isPathMapping(String path) {
        return path.startsWith("/") && path.endsWith("/*");
    }

    private String getMappingRootPath(String pathMapping) {
        return pathMapping.substring(0, pathMapping.length() - "/*".length());
    }

    public HttpSession getSession() {
        return this.getSession(true);
    }

    public HttpSession getSession(boolean create) {
        HttpSession session = this.delegate.getSession(create);
        if (session == null) {
            return null;
        }
        return new PluginHttpSessionWrapper(session);
    }
}

