/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity.jdbc;

import java.lang.ref.PhantomReference;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.ThreadSafe;
import org.ofbiz.core.entity.jdbc.SQLProcessor;
import org.ofbiz.core.util.Debug;

@ThreadSafe
class ConnectionGuard
extends PhantomReference<SQLProcessor> {
    private static final ConcurrentMap<ConnectionGuard, ConnectionGuard> GUARDS = new ConcurrentHashMap<ConnectionGuard, ConnectionGuard>(64);
    static final ReferenceQueue<SQLProcessor> ABANDONED = new ReferenceQueue();
    private final AtomicReference<Connection> connectionRef;
    private volatile String sql;

    private ConnectionGuard(SQLProcessor owner, Connection connection) {
        super(owner, ABANDONED);
        this.connectionRef = new AtomicReference<Connection>(connection);
    }

    static ConnectionGuard register(SQLProcessor owner, Connection connection) {
        ConnectionGuard guard = new ConnectionGuard(owner, connection);
        GUARDS.put(guard, guard);
        return guard;
    }

    @Override
    public void clear() {
        GUARDS.remove(this);
        this.connectionRef.set(null);
        this.sql = null;
        super.clear();
    }

    private void closeAbandonedProcessor() {
        GUARDS.remove(this);
        Connection connection = this.connectionRef.getAndSet(null);
        if (connection != null) {
            this.closeAbandonedConnection(connection);
        }
    }

    private void closeAbandonedConnection(Connection connection) {
        Debug.logError((String)("!!! ABANDONED SQLProcessor DETECTED !!!\n\tThis probably means that somebody forgot to close an EntityListIterator.\n\tConnection: " + connection + "\n\tSQL: " + this.sql), (String)SQLProcessor.module);
        try {
            connection.close();
        }
        catch (LinkageError | RuntimeException | SQLException e) {
            Debug.logError((Throwable)e, (String)"ConnectionGuard.close() failed", (String)SQLProcessor.module);
        }
    }

    void setSql(String sql) {
        this.sql = sql;
    }

    static void closeAbandonedProcessors() {
        Reference<SQLProcessor> abandoned = ABANDONED.poll();
        while (abandoned != null) {
            ((ConnectionGuard)abandoned).closeAbandonedProcessor();
            abandoned = ABANDONED.poll();
        }
    }

    public String toString() {
        return "ConnectionGuard[connection=" + this.connectionRef.get() + ",sql=" + this.sql + ']';
    }
}

