/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.entity;

import java.util.Iterator;
import java.util.List;
import org.ofbiz.core.entity.EntityCondition;
import org.ofbiz.core.entity.EntityConditionParam;
import org.ofbiz.core.entity.EntityExpr;
import org.ofbiz.core.entity.EntityOperator;
import org.ofbiz.core.entity.GenericModelException;
import org.ofbiz.core.entity.model.ModelEntity;

public class EntityExprList
extends EntityCondition {
    protected List<? extends EntityExpr> exprList;
    protected EntityOperator operator;

    protected EntityExprList() {
    }

    public EntityExprList(List<? extends EntityExpr> exprList, EntityOperator operator) {
        this.exprList = exprList;
        this.operator = operator;
    }

    public EntityOperator getOperator() {
        return this.operator;
    }

    public EntityExpr getExpr(int index) {
        return this.exprList.get(index);
    }

    public int getExprListSize() {
        return this.exprList.size();
    }

    public Iterator<? extends EntityExpr> getExprIterator() {
        return this.exprList.iterator();
    }

    @Override
    public String makeWhereString(ModelEntity modelEntity, List<? super EntityConditionParam> entityConditionParams) {
        StringBuilder whereStringBuilder = new StringBuilder();
        if (this.exprList != null && this.exprList.size() > 0) {
            for (int i = 0; i < this.exprList.size(); ++i) {
                EntityExpr expr = this.exprList.get(i);
                whereStringBuilder.append('(');
                whereStringBuilder.append(expr.makeWhereString(modelEntity, entityConditionParams));
                whereStringBuilder.append(')');
                if (i >= this.exprList.size() - 1) continue;
                whereStringBuilder.append(' ');
                whereStringBuilder.append(this.operator.getCode());
                whereStringBuilder.append(' ');
            }
        }
        return whereStringBuilder.toString();
    }

    @Override
    public void checkCondition(ModelEntity modelEntity) throws GenericModelException {
        for (EntityExpr entityExpr : this.exprList) {
            entityExpr.checkCondition(modelEntity);
        }
    }

    public String toString() {
        StringBuilder toStringBuilder = new StringBuilder();
        toStringBuilder.append("[ExprList::");
        if (this.exprList != null && this.exprList.size() > 0) {
            for (int i = 0; i < this.exprList.size(); ++i) {
                EntityExpr expr = this.exprList.get(i);
                toStringBuilder.append(expr.toString());
                if (i <= 0) continue;
                toStringBuilder.append("::");
            }
        }
        toStringBuilder.append(']');
        return toStringBuilder.toString();
    }
}

