/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.util.Hashtable;
import javax.naming.InitialContext;
import org.ofbiz.core.config.GenericConfigException;
import org.ofbiz.core.config.JNDIConfigUtil;
import org.ofbiz.core.util.Debug;
import org.ofbiz.core.util.UtilCache;
import org.ofbiz.core.util.UtilValidate;

public class JNDIContextFactory {
    static UtilCache<String, InitialContext> contexts = new UtilCache("entity.JNDIContexts", 0L, 0L);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InitialContext getInitialContext(String jndiServerName) throws GenericConfigException {
        InitialContext ic = contexts.get(jndiServerName);
        if (ic != null) return ic;
        Class<JNDIContextFactory> clazz = JNDIContextFactory.class;
        synchronized (JNDIContextFactory.class) {
            ic = contexts.get(jndiServerName);
            if (ic != null) return ic;
            JNDIConfigUtil.JndiServerInfo jndiServerInfo = JNDIConfigUtil.getJndiServerInfo(jndiServerName);
            if (jndiServerInfo == null) {
                throw new GenericConfigException("ERROR: no jndi-server definition was found with the name " + jndiServerName + " in jndiservers.xml");
            }
            try {
                if (UtilValidate.isEmpty(jndiServerInfo.contextProviderUrl)) {
                    ic = new InitialContext();
                } else {
                    Hashtable<String, String> h = new Hashtable<String, String>();
                    h.put("java.naming.factory.initial", jndiServerInfo.initialContextFactory);
                    h.put("java.naming.provider.url", jndiServerInfo.contextProviderUrl);
                    if (jndiServerInfo.urlPkgPrefixes != null && jndiServerInfo.urlPkgPrefixes.length() > 0) {
                        h.put("java.naming.factory.url.pkgs", jndiServerInfo.urlPkgPrefixes);
                    }
                    if (jndiServerInfo.securityPrincipal != null && jndiServerInfo.securityPrincipal.length() > 0) {
                        h.put("java.naming.security.principal", jndiServerInfo.securityPrincipal);
                    }
                    if (jndiServerInfo.securityCredentials != null && jndiServerInfo.securityCredentials.length() > 0) {
                        h.put("java.naming.security.credentials", jndiServerInfo.securityCredentials);
                    }
                    ic = new InitialContext(h);
                }
            }
            catch (Exception e) {
                String errorMsg = "Error getting JNDI initial context for server name " + jndiServerName;
                Debug.logError(e, errorMsg);
                throw new GenericConfigException(errorMsg, e);
            }
            if (ic == null) return ic;
            contexts.put(jndiServerName, ic);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ic;
        }
    }

    public static void clearInitialContext(String jndiServerName) {
        InitialContext ic = contexts.get(jndiServerName);
        if (ic != null) {
            contexts.remove(jndiServerName);
        }
    }
}

