/*
 * Decompiled with CFR 0.152.
 */
package org.ofbiz.core.util;

import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.ofbiz.core.util.Debug;

public class CachedClassLoader
extends URLClassLoader {
    private String contextName;
    public static Map<String, Class<?>> globalClassNameClassMap = new HashMap();
    public static HashSet<String> globalBadClassNameSet = new HashSet();
    public Map<String, Class<?>> localClassNameClassMap = new HashMap();
    public HashSet<String> localBadClassNameSet = new HashSet();
    public static Map<String, URL> globalResourceMap = new HashMap<String, URL>();
    public static HashSet<String> globalBadResourceNameSet = new HashSet();
    public Map<String, URL> localResourceMap = new HashMap<String, URL>();
    public HashSet<String> localBadResourceNameSet = new HashSet();

    public CachedClassLoader(ClassLoader parent, String contextName) {
        super(new URL[0], parent);
        this.contextName = contextName;
    }

    public String toString() {
        return "org.ofbiz.core.util.CachedClassLoader(" + this.contextName + ") / " + this.getParent().toString();
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> theClass = globalClassNameClassMap.get(name);
        if (theClass == null) {
            theClass = this.localClassNameClassMap.get(name);
        }
        if (theClass == null && (this.localBadClassNameSet.contains(name) || globalBadClassNameSet.contains(name))) {
            if (Debug.verboseOn()) {
                Debug.logVerbose("Cached loader got a known bad class name: [" + name + "]");
            }
            throw new ClassNotFoundException("Cached loader got a known bad class name: " + name);
        }
        if (theClass == null) {
            if (Debug.verboseOn()) {
                Debug.logVerbose("Cached loader cache miss for class name: [" + name + "]");
            }
            CachedClassLoader cachedClassLoader = this;
            synchronized (cachedClassLoader) {
                theClass = this.localClassNameClassMap.get(name);
                if (theClass == null) {
                    try {
                        theClass = super.loadClass(name, resolve);
                        if (this.isGlobalPath(name)) {
                            globalClassNameClassMap.put(name, theClass);
                        } else {
                            this.localClassNameClassMap.put(name, theClass);
                        }
                    }
                    catch (ClassNotFoundException e) {
                        if (Debug.verboseOn()) {
                            Debug.logVerbose("Remembering invalid class name: [" + name + "]");
                        }
                        if (this.isGlobalPath(name)) {
                            globalBadClassNameSet.add(name);
                        } else {
                            this.localBadClassNameSet.add(name);
                        }
                        throw e;
                    }
                }
            }
        }
        return theClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public URL getResource(String name) {
        URL theResource = globalResourceMap.get(name);
        if (theResource == null) {
            theResource = this.localResourceMap.get(name);
        }
        if (theResource == null && (this.localBadResourceNameSet.contains(name) || globalBadResourceNameSet.contains(name))) {
            if (Debug.verboseOn()) {
                Debug.logVerbose("Cached loader got a known bad resource name: [" + name + "]");
            }
            return null;
        }
        if (theResource == null) {
            Debug.logInfo("Cached loader cache miss for resource name: [" + name + "]");
            CachedClassLoader cachedClassLoader = this;
            synchronized (cachedClassLoader) {
                theResource = this.localResourceMap.get(name);
                if (theResource == null) {
                    theResource = super.getResource(name);
                    if (theResource == null) {
                        Debug.logInfo("Remembering invalid resource name: [" + name + "]");
                        if (this.isGlobalPath(name)) {
                            globalBadResourceNameSet.add(name);
                        } else {
                            this.localBadResourceNameSet.add(name);
                        }
                    } else if (this.isGlobalPath(name)) {
                        globalResourceMap.put(name, theResource);
                    } else {
                        this.localResourceMap.put(name, theResource);
                    }
                }
            }
        }
        return theResource;
    }

    protected boolean isGlobalPath(String name) {
        if (name.startsWith("java.") || name.startsWith("java/") || name.startsWith("/java/")) {
            return true;
        }
        if (name.startsWith("javax.") || name.startsWith("javax/") || name.startsWith("/javax/")) {
            return true;
        }
        if (name.startsWith("sun.") || name.startsWith("sun/") || name.startsWith("/sun/")) {
            return true;
        }
        return name.startsWith("org.ofbiz.core.");
    }

    static {
        globalClassNameClassMap.put("Object", Object.class);
        globalClassNameClassMap.put("java.lang.Object", Object.class);
        globalClassNameClassMap.put("String", String.class);
        globalClassNameClassMap.put("java.lang.String", String.class);
        globalClassNameClassMap.put("Boolean", Boolean.class);
        globalClassNameClassMap.put("java.lang.Boolean", Boolean.class);
        globalClassNameClassMap.put("Double", Double.class);
        globalClassNameClassMap.put("java.lang.Double", Double.class);
        globalClassNameClassMap.put("Float", Float.class);
        globalClassNameClassMap.put("java.lang.Float", Float.class);
        globalClassNameClassMap.put("Long", Long.class);
        globalClassNameClassMap.put("java.lang.Long", Long.class);
        globalClassNameClassMap.put("Integer", Integer.class);
        globalClassNameClassMap.put("java.lang.Integer", Integer.class);
        globalClassNameClassMap.put("Timestamp", Timestamp.class);
        globalClassNameClassMap.put("java.sql.Timestamp", Timestamp.class);
        globalClassNameClassMap.put("Time", Time.class);
        globalClassNameClassMap.put("java.sql.Time", Time.class);
        globalClassNameClassMap.put("Date", Date.class);
        globalClassNameClassMap.put("java.sql.Date", Date.class);
        globalClassNameClassMap.put("Locale", Locale.class);
        globalClassNameClassMap.put("java.util.Locale", Locale.class);
        globalClassNameClassMap.put("java.util.Date", java.util.Date.class);
        globalClassNameClassMap.put("Collection", Collection.class);
        globalClassNameClassMap.put("java.util.Collection", Collection.class);
        globalClassNameClassMap.put("List", List.class);
        globalClassNameClassMap.put("java.util.List", List.class);
        globalClassNameClassMap.put("Set", Set.class);
        globalClassNameClassMap.put("java.util.Set", Set.class);
        globalClassNameClassMap.put("Map", Map.class);
        globalClassNameClassMap.put("java.util.Map", Map.class);
        globalClassNameClassMap.put("HashMap", HashMap.class);
        globalClassNameClassMap.put("java.util.HashMap", HashMap.class);
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            globalClassNameClassMap.put("GenericValue", loader.loadClass("org.ofbiz.core.entity.GenericValue"));
            globalClassNameClassMap.put("org.ofbiz.core.entity.GenericValue", loader.loadClass("org.ofbiz.core.entity.GenericValue"));
            globalClassNameClassMap.put("GenericPK", loader.loadClass("org.ofbiz.core.entity.GenericPK"));
            globalClassNameClassMap.put("org.ofbiz.core.entity.GenericPK", loader.loadClass("org.ofbiz.core.entity.GenericPK"));
            globalClassNameClassMap.put("GenericEntity", loader.loadClass("org.ofbiz.core.entity.GenericEntity"));
            globalClassNameClassMap.put("org.ofbiz.core.entity.GenericEntity", loader.loadClass("org.ofbiz.core.entity.GenericEntity"));
        }
        catch (ClassNotFoundException e) {
            Debug.logError(e, "Could not pre-initialize dynamically loaded class: ");
        }
    }
}

