/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.multitenant.hibernate2;

import com.atlassian.multitenant.MultiTenantContext;
import com.atlassian.multitenant.cache.MultiTenantCacheKey;
import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.EhCacheProvider;

public class SharedMultiTenantEhCacheProvider
implements CacheProvider {
    private final CacheProvider delegate = new EhCacheProvider();

    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        return new SharedMultiTenantEhCache(this.delegate.buildCache(regionName, properties));
    }

    public long nextTimestamp() {
        return this.delegate.nextTimestamp();
    }

    public void start(Properties properties) throws CacheException {
        this.delegate.start(properties);
    }

    public void stop() {
        this.delegate.stop();
    }

    private class SharedMultiTenantEhCache
    implements Cache {
        private final Cache cache;

        private SharedMultiTenantEhCache(Cache cache) {
            this.cache = cache;
        }

        public Object get(Object key) throws CacheException {
            return this.cache.get((Object)this.createKey(key));
        }

        public void put(Object key, Object value) throws CacheException {
            this.cache.put((Object)this.createKey(key), value);
        }

        public void remove(Object key) throws CacheException {
            this.cache.remove((Object)this.createKey(key));
        }

        public void clear() throws CacheException {
            this.cache.clear();
        }

        public void destroy() throws CacheException {
            this.cache.destroy();
        }

        public void lock(Object key) throws CacheException {
            this.cache.lock((Object)this.createKey(key));
        }

        public void unlock(Object key) throws CacheException {
            this.cache.unlock((Object)this.createKey(key));
        }

        public long nextTimestamp() {
            return this.cache.nextTimestamp();
        }

        public int getTimeout() {
            return this.cache.getTimeout();
        }

        private MultiTenantCacheKey createKey(Object key) {
            return new MultiTenantCacheKey(MultiTenantContext.getTenantReference().get().getName(), key);
        }
    }
}

