/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.product.jira;

import com.atlassian.maven.plugins.amps.DataSource;
import com.atlassian.maven.plugins.amps.product.ImportMethod;
import com.atlassian.maven.plugins.amps.product.jira.AbstractJiraDatabase;
import java.io.File;
import org.apache.maven.plugin.MojoExecutionException;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.twdata.maven.mojoexecutor.MojoExecutor;

public class JiraDatabaseOracleImpl
extends AbstractJiraDatabase {
    private static final String DATA_PUMP_DIR = "DATA_PUMP_DIR";
    private static final String DROP_AND_CREATE_USER = "DECLARE\n    v_count INTEGER := 0;\nBEGIN\n    SELECT COUNT (1) INTO v_count FROM dba_users WHERE username = UPPER ('%s'); \n    IF v_count != 0\n    THEN\n        EXECUTE IMMEDIATE('DROP USER %s CASCADE');\n    END IF;\n    v_count := 0; \n    SELECT COUNT (1) INTO v_count FROM dba_tablespaces WHERE tablespace_name = UPPER('jiradb2'); \n    IF v_count != 0\n    THEN\n        EXECUTE IMMEDIATE('DROP TABLESPACE jiradb2 INCLUDING CONTENTS AND DATAFILES');\n    END IF;\n    EXECUTE IMMEDIATE(q'{CREATE TABLESPACE jiradb2 DATAFILE '/tmp/jiradb2.dbf' SIZE 32m AUTOEXTEND ON NEXT 32m MAXSIZE 4096m EXTENT MANAGEMENT LOCAL}');\n    EXECUTE IMMEDIATE('CREATE USER %s IDENTIFIED BY %s DEFAULT TABLESPACE jiradb2 QUOTA UNLIMITED ON jiradb2');\n    EXECUTE IMMEDIATE('GRANT CONNECT, RESOURCE, IMP_FULL_DATABASE TO %s');\n    EXECUTE IMMEDIATE(q'{CREATE OR REPLACE DIRECTORY %s AS '%s'}');\n    EXECUTE IMMEDIATE('GRANT READ, WRITE ON DIRECTORY %s TO %s');\nEND;\n/";

    public JiraDatabaseOracleImpl(DataSource dataSource) {
        super(dataSource);
    }

    @Override
    protected String dropDatabase() {
        return null;
    }

    @Override
    protected String dropUser() {
        return null;
    }

    @Override
    protected String createDatabase() {
        return null;
    }

    @Override
    protected String createUser() {
        return null;
    }

    private String getDropAndCreateUser() {
        String dumpFileDirectoryPath = new File(this.getDataSource().getDumpFilePath()).getParent();
        String username = this.getDataSource().getUsername();
        String dropAndCreateUser = String.format(DROP_AND_CREATE_USER, username, username, username, this.getDataSource().getPassword(), username, DATA_PUMP_DIR, dumpFileDirectoryPath, DATA_PUMP_DIR, username);
        return dropAndCreateUser;
    }

    @Override
    protected String grantPermissionForUser() {
        return null;
    }

    @Override
    protected String getDatabaseName(String url) {
        return this.getDataSource().getSchema();
    }

    @Override
    public Xpp3Dom getConfigDatabaseTool() throws MojoExecutionException {
        Xpp3Dom configDatabaseTool = null;
        if (ImportMethod.IMPDP.equals((Object)ImportMethod.getValueOf(this.getDataSource().getImportMethod()))) {
            File dumpFile = new File(this.getDataSource().getDumpFilePath());
            File dumpFileDirecotry = dumpFile.getParentFile();
            String dumpFileName = dumpFile.getName();
            dumpFile.setExecutable(true, false);
            dumpFile.setReadable(true, false);
            dumpFile.setWritable(true, false);
            dumpFileDirecotry.setExecutable(true, false);
            dumpFileDirecotry.setReadable(true, false);
            dumpFileDirecotry.setWritable(true, false);
            configDatabaseTool = MojoExecutor.configuration(MojoExecutor.element(MojoExecutor.name("executable"), "impdp"), MojoExecutor.element(MojoExecutor.name("arguments"), MojoExecutor.element(MojoExecutor.name("argument"), this.getDataSource().getUsername() + "/" + this.getDataSource().getPassword()), MojoExecutor.element(MojoExecutor.name("argument"), "DUMPFILE=" + dumpFileName), MojoExecutor.element(MojoExecutor.name("argument"), "DIRECTORY=DATA_PUMP_DIR")));
        }
        return configDatabaseTool;
    }

    @Override
    public Xpp3Dom getPluginConfiguration() {
        String sql = this.getDropAndCreateUser();
        this.getLog().info((CharSequence)("Oracle initialization database sql: " + sql));
        Xpp3Dom pluginConfiguration = this.systemDatabaseConfiguration();
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("sqlCommand"), sql).toDom());
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("delimiter"), "/").toDom());
        pluginConfiguration.addChild(MojoExecutor.element(MojoExecutor.name("delimiterType"), "row").toDom());
        return pluginConfiguration;
    }
}

