/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugins.amps.osgi;

import aQute.bnd.header.Attrs;
import aQute.bnd.header.OSGiHeader;
import aQute.bnd.header.Parameters;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public class PackageImportVersionValidator {
    private final MavenProject project;
    private final Log log;
    private final String productName;
    private final Map<String, Set<String>> jarPackageCache = new HashMap<String, Set<String>>();
    private static final int MIN_PACKAGES_FOR_WILDCARD = 4;

    public PackageImportVersionValidator(MavenProject project, Log log, String productName) {
        this.project = project;
        this.log = log;
        this.productName = productName;
    }

    public void validate(String imports) {
        if (imports != null) {
            HashMap<String, String> foundPackages = new HashMap<String, String>();
            boolean validationFailed = false;
            Parameters pkgImports = OSGiHeader.parseHeader((String)imports);
            for (Map.Entry pkgImport : pkgImports.entrySet()) {
                String pkg = (String)pkgImport.getKey();
                if (pkgImport.getValue() != null && ((Attrs)pkgImport.getValue()).size() > 0) {
                    Attrs attrs = (Attrs)pkgImport.getValue();
                    String version = attrs.get("version");
                    foundPackages.put(pkg, this.guessVersion(pkg));
                    if (version != null && version.length() != 0) continue;
                    validationFailed = true;
                    continue;
                }
                validationFailed = true;
                foundPackages.put(pkg, this.guessVersion(pkg));
            }
            if (validationFailed) {
                StringBuilder sb = new StringBuilder();
                sb.append("The manifest should contain versions for all imports to prevent ambiguity at install time ");
                sb.append("due to multiple versions of a package.  Here are some suggestions for the ");
                sb.append("maven-").append(this.productName).append("-plugin configuration generated for this project ");
                sb.append("to start from:\n ");
                sb.append("  <configuration>\n");
                sb.append("    <instructions>\n");
                sb.append("      <Import-Package>\n");
                for (Map.Entry<String, String> entry : PackageImportVersionValidator.compressPackages(foundPackages).entrySet()) {
                    sb.append("        ").append(entry.getKey()).append(";version=\"").append(entry.getValue()).append("\",\n");
                }
                sb.delete(sb.length() - 2, sb.length());
                sb.append("\n");
                sb.append("      </Import-Package>\n");
                sb.append("    </instructions>\n");
                sb.append("  </configuration>\n");
                sb.append("You may notice many packages you weren't expecting.  This is usually because of a bundled jar ");
                sb.append("that references packages that don't apply.  You can usually remove these or if necessary, ");
                sb.append("mark them as optional by adding ';resolution:=optional' to the package import.  Packages ");
                sb.append("that are detected as version '0.0.0' usually mean either they are JDK packages or ones that ");
                sb.append("aren't referenced in your project, and therefore, likely candidates for removal entirely.");
                this.log.warn((CharSequence)sb.toString());
            }
        }
    }

    static Map<String, String> compressPackages(Map<String, String> allPackages) {
        HashMap<String, String> pkgs = new HashMap<String, String>();
        TreeSet<String> unmatchedPackages = new TreeSet<String>(allPackages.keySet());
        block0: for (String pkg : new TreeSet<String>(allPackages.keySet())) {
            if (!unmatchedPackages.contains(pkg)) continue;
            String version = allPackages.get(pkg);
            TreeSet<String> others = new TreeSet<String>((Collection<String>)unmatchedPackages);
            others.remove(pkg);
            Iterator i = others.iterator();
            while (i.hasNext()) {
                String otherPkg = (String)i.next();
                if (allPackages.get(otherPkg).equals(version)) continue;
                i.remove();
            }
            int numberOfPackages = 1;
            for (int curpos = 0; curpos < pkg.length(); ++curpos) {
                char curchar = pkg.charAt(curpos);
                if (curchar == '.') {
                    ++numberOfPackages;
                }
                Iterator i2 = others.iterator();
                while (i2.hasNext()) {
                    String otherPkg = (String)i2.next();
                    if (!PackageImportVersionValidator.otherNotMatchesNextChar(curpos, curchar, otherPkg)) continue;
                    i2.remove();
                }
                if (numberOfPackages != 4 && curpos != pkg.length() - 1) continue;
                if (others.size() > 0 && numberOfPackages == 4) {
                    String pattern = PackageImportVersionValidator.greedlyBuildPattern(pkg, others, curpos).toString();
                    pkgs.put(pattern + "*", version);
                    unmatchedPackages.removeAll(others);
                } else {
                    pkgs.put(pkg, version);
                }
                unmatchedPackages.remove(pkg);
                continue block0;
            }
        }
        return pkgs;
    }

    private static boolean otherNotMatchesNextChar(int curpos, char curchar, String other) {
        return other.length() <= curpos || curchar != other.charAt(curpos);
    }

    private static StringBuilder greedlyBuildPattern(String pkg, Set<String> others, int curpos) {
        StringBuilder pattern = new StringBuilder(pkg.substring(0, curpos + 1));
        boolean canConsumeAnotherChar = true;
        for (int greedyPos = curpos + 1; greedyPos < pkg.length() && canConsumeAnotherChar; ++greedyPos) {
            for (String greedyOther : others) {
                canConsumeAnotherChar = true;
                if (!PackageImportVersionValidator.otherNotMatchesNextChar(greedyPos, pkg.charAt(greedyPos), greedyOther)) continue;
                canConsumeAnotherChar = false;
                break;
            }
            if (!canConsumeAnotherChar) continue;
            pattern.append(pkg.charAt(greedyPos));
        }
        return pattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private String guessVersion(String pkg) {
        for (Artifact artifact : new HashSet(this.project.getArtifacts())) {
            File file = artifact.getFile();
            if (!file.exists() || !file.getName().endsWith(".jar")) continue;
            Set<String> contents = this.jarPackageCache.get(file.getAbsolutePath());
            if (contents == null) {
                contents = new HashSet<String>();
                this.jarPackageCache.put(file.getAbsolutePath(), contents);
                ZipInputStream in = null;
                try {
                    ZipEntry entry;
                    in = new ZipInputStream(new FileInputStream(file));
                    while ((entry = in.getNextEntry()) != null) {
                        contents.add(entry.getName());
                    }
                }
                catch (IOException iOException) {
                    IOUtils.closeQuietly(in);
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(in);
                        throw throwable;
                    }
                }
                IOUtils.closeQuietly((InputStream)in);
            }
            if (!contents.contains(pkg.replace('.', '/') + "/")) continue;
            return artifact.getVersion();
        }
        return "0.0.0";
    }
}

